/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.esa.beam.HeadlessTestRunner;
import org.esa.beam.framework.gpf.ui.DefaultAppContext;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import ucar.nc2.constants.FeatureType;

@RunWith(value=HeadlessTestRunner.class)
public class CatalogTree_setNewRootDatasetsTest {
    private List<InvDataset> datasets;
    private InvCatalogImpl catalog;
    private CatalogTree catalogTree;

    @Before
    public void setUp() throws Exception {
        this.datasets = new ArrayList<InvDataset>();
        this.catalog = new InvCatalogImpl("catalogName", "1.0", new URI("http://x.y"));
        InvDatasetImpl dapDataset = this.createDataset(this.catalog, "first", "OPENDAP");
        this.datasets.add((InvDataset)dapDataset);
        this.catalogTree = new CatalogTree(null, (AppContext)new DefaultAppContext(""), null);
    }

    @Test
    public void testAddingDapDataset() {
        this.catalogTree.setNewRootDatasets(this.datasets);
        Assert.assertEquals((Object)true, (Object)(((JTree)this.catalogTree.getComponent()).getModel().getRoot() instanceof DefaultMutableTreeNode));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((JTree)this.catalogTree.getComponent()).getModel().getRoot();
        Assert.assertEquals((long)1L, (long)root.getChildCount());
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)root.getChildAt(0)));
        Assert.assertEquals((Object)"first", (Object)((DefaultMutableTreeNode)root.getChildAt(0)).getUserObject().toString());
    }

    @Test
    public void testAddingDatasetWithDAPAccessAndOneWithFileAccessOnly_FileAccessOnlyResolvesToNodeWithFileAccess() {
        InvDatasetImpl fileDataset = this.createDataset(this.catalog, "second", "file");
        this.datasets.add((InvDataset)fileDataset);
        this.catalogTree.setNewRootDatasets(this.datasets);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((JTree)this.catalogTree.getComponent()).getModel().getRoot();
        Assert.assertEquals((long)2L, (long)root.getChildCount());
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)root.getChildAt(0)));
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isFileNode((Object)root.getChildAt(0)));
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)root.getChildAt(1)));
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isFileNode((Object)root.getChildAt(1)));
    }

    @Test
    public void testWhetherRootNodeHasBeenExchanged() {
        InvDatasetImpl fileDataset = this.createDataset(this.catalog, "second", "file");
        ArrayList<InvDatasetImpl> otherDatasets = new ArrayList<InvDatasetImpl>();
        otherDatasets.add(fileDataset);
        this.catalogTree.setNewRootDatasets(this.datasets);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((JTree)this.catalogTree.getComponent()).getModel().getRoot();
        this.catalogTree.setNewRootDatasets(otherDatasets);
        DefaultMutableTreeNode otherRoot = (DefaultMutableTreeNode)((JTree)this.catalogTree.getComponent()).getModel().getRoot();
        Assert.assertEquals((Object)false, (Object)root.equals(otherRoot));
    }

    @Test
    public void testThatPreviousDatasetsHaveBeenRemoved() {
        this.catalogTree.setNewRootDatasets(this.datasets);
        DefaultMutableTreeNode previousRootNode = (DefaultMutableTreeNode)((JTree)this.catalogTree.getComponent()).getModel().getRoot();
        InvDatasetImpl fileDataset = this.createDataset(this.catalog, "second", "file");
        ArrayList<InvDatasetImpl> otherDatasets = new ArrayList<InvDatasetImpl>();
        otherDatasets.add(fileDataset);
        this.catalogTree.setNewRootDatasets(otherDatasets);
        DefaultMutableTreeNode newRootNode = (DefaultMutableTreeNode)((JTree)this.catalogTree.getComponent()).getModel().getRoot();
        Assert.assertNotSame((Object)previousRootNode, (Object)newRootNode);
    }

    private InvDatasetImpl createDataset(InvCatalogImpl catalog, String datasetName, String serviceName) {
        InvDatasetImpl dapDataset = new InvDatasetImpl(null, datasetName, FeatureType.NONE, serviceName, "http://wherever.you.want.bc");
        dapDataset.setCatalog((InvCatalog)catalog);
        InvService dapService = new InvService(serviceName, serviceName, "irrelevant", "irrelevant", "irrelevant");
        dapDataset.addAccess((InvAccess)new InvAccessImpl((InvDataset)dapDataset, "http://y.z", dapService));
        dapDataset.finish();
        return dapDataset;
    }
}

