/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.esa.beam.opendap.datamodel.CatalogNode;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog.InvDataset;

public class CatalogTree_isCatalogReferenceNodeTest {
    @Test
    public void testThatNullIsResolvedToFalse() {
        Object notADapNode = null;
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isCatalogReferenceNode(notADapNode));
    }

    @Test
    public void testThatUserObjectWhichIsNoStringIsResolvedToFalse() {
        Integer userObject = 4;
        DefaultMutableTreeNode notADapNode = new DefaultMutableTreeNode(userObject);
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)notADapNode));
    }

    @Test
    public void testThatOpendapLeafWhichIsNoCatalogRefIsResolvedToFalse() {
        OpendapLeaf userObject = new OpendapLeaf("any", new InvDataset(null, ""){});
        DefaultMutableTreeNode noDapNode = new DefaultMutableTreeNode(userObject);
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)noDapNode));
    }

    @Test
    public void testThatOpendapLeafWhichIsCatalogRefIsResolvedToTrue() {
        CatalogNode opendapLeaf = new CatalogNode("any", null);
        DefaultMutableTreeNode notDapNode = new DefaultMutableTreeNode(opendapLeaf);
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)notDapNode));
    }
}

