/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.esa.beam.HeadlessTestRunner;
import org.esa.beam.framework.gpf.ui.DefaultAppContext;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import ucar.nc2.constants.FeatureType;

@RunWith(value=HeadlessTestRunner.class)
public class CatalogTree_appendToNodeTest {
    private ArrayList<InvDataset> datasets;
    private InvCatalogImpl catalog;
    private DefaultMutableTreeNode parentNode;

    @Before
    public void setUp() throws Exception {
        this.datasets = new ArrayList();
        this.catalog = new InvCatalogImpl("catalogName", "1.0", new URI("http://x.y"));
        this.parentNode = new DefaultMutableTreeNode();
    }

    @Test
    public void testAppendDapNode() throws URISyntaxException {
        this.datasets.add((InvDataset)this.createDataset(this.catalog, "first", "OPENDAP"));
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendToNode(new JTree(), this.datasets, (MutableTreeNode)this.parentNode, true);
        Assert.assertEquals((long)1L, (long)this.parentNode.getChildCount());
        Assert.assertEquals((Object)true, (Object)this.parentNode.getChildAt(0).isLeaf());
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(0)));
    }

    @Test
    public void testAppendThreeDapNodes() throws URISyntaxException {
        this.datasets.add((InvDataset)this.createDataset(this.catalog, "Name_1", "OPENDAP"));
        this.datasets.add((InvDataset)this.createDataset(this.catalog, "Name_2", "OPENDAP"));
        this.datasets.add((InvDataset)this.createDataset(this.catalog, "Name_3", "OPENDAP"));
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendToNode(new JTree(), this.datasets, (MutableTreeNode)this.parentNode, true);
        Assert.assertEquals((long)3L, (long)this.parentNode.getChildCount());
        for (int i = 0; i < this.parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childAt = (DefaultMutableTreeNode)this.parentNode.getChildAt(i);
            String indexMessage = "Index = " + i;
            Assert.assertEquals((String)indexMessage, (Object)true, (Object)childAt.isLeaf());
            Assert.assertEquals((String)indexMessage, (Object)true, (Object)CatalogTreeUtils.isDapNode((Object)childAt));
            Assert.assertEquals((String)indexMessage, (Object)("Name_" + (i + 1)), (Object)childAt.getUserObject().toString());
        }
    }

    @Test
    public void testAppendFileNode() throws URISyntaxException {
        this.datasets.add((InvDataset)this.createDataset(this.catalog, "fileName", "file"));
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendToNode(new JTree(), this.datasets, (MutableTreeNode)this.parentNode, true);
        Assert.assertEquals((long)1L, (long)this.parentNode.getChildCount());
        Assert.assertEquals((Object)true, (Object)this.parentNode.getChildAt(0).isLeaf());
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(0)));
    }

    @Test
    public void testAppendCatalogNode() throws URISyntaxException {
        this.datasets.add((InvDataset)this.createCatalogRefDataset());
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendToNode(new JTree(), this.datasets, (MutableTreeNode)this.parentNode, true);
        Assert.assertEquals((long)1L, (long)this.parentNode.getChildCount());
        Assert.assertEquals((long)1L, (long)this.parentNode.getChildAt(0).getChildCount());
        Assert.assertEquals((Object)true, (Object)this.parentNode.getChildAt(0).getChildAt(0).isLeaf());
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(0)));
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)this.parentNode.getChildAt(0)));
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(0).getChildAt(0)));
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)this.parentNode.getChildAt(0).getChildAt(0)));
    }

    @Test
    public void testAppendingVariousDatasets() {
        this.datasets.add((InvDataset)this.createDataset(this.catalog, "dapName", "OPENDAP"));
        this.datasets.add((InvDataset)this.createDataset(this.catalog, "fileName", "FILE"));
        this.datasets.add((InvDataset)this.createCatalogRefDataset());
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendToNode(new JTree(), this.datasets, (MutableTreeNode)this.parentNode, true);
        Assert.assertEquals((long)3L, (long)this.parentNode.getChildCount());
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(0)));
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(1)));
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)this.parentNode.getChildAt(1)));
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)this.parentNode.getChildAt(2).getChildAt(0)));
    }

    private InvDatasetImpl createDataset(InvCatalogImpl catalog, String datasetName, String serviceName) {
        InvDatasetImpl dapDataset = new InvDatasetImpl(null, datasetName, FeatureType.NONE, serviceName, "http://wherever.you.want.bc");
        dapDataset.setCatalog((InvCatalog)catalog);
        InvService dapService = new InvService(serviceName, serviceName, "irrelevant", "irrelevant", "irrelevant");
        dapDataset.addAccess((InvAccess)new InvAccessImpl((InvDataset)dapDataset, "http://y.z", dapService));
        dapDataset.finish();
        return dapDataset;
    }

    private InvCatalogRef createCatalogRefDataset() {
        InvCatalogRef catalogRef = new InvCatalogRef(null, "catalogName", "irrelevant");
        catalogRef.setCatalog((InvCatalog)this.catalog);
        return catalogRef;
    }
}

