/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.esa.beam.HeadlessTestRunner;
import org.esa.beam.framework.gpf.ui.DefaultAppContext;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.opendap.datamodel.CatalogNode;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import ucar.nc2.constants.FeatureType;

@RunWith(value=HeadlessTestRunner.class)
public class CatalogTree_appendNodeUnitTest {
    private DefaultMutableTreeNode parentNode;

    @Before
    public void setUp() throws Exception {
        this.parentNode = new DefaultMutableTreeNode();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testAppendAn_OPeNDAP_Node() throws URISyntaxException {
        String serviceType = "OPENDAP";
        InvDatasetImpl dapDataset = this.createDataset(new String[]{"OPENDAP"});
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendLeafNode((MutableTreeNode)this.parentNode, this.getDefaultTreeModel(), (InvDataset)dapDataset);
        this.testThatChildIsOnlyDapNodeWithoutFileAccess(this.parentNode);
    }

    @Test
    public void testThatAppendDatasetWithFileAccessOnlyIsResolvedToNodeWithFileAccess() throws URISyntaxException {
        String serviceName = "FILE";
        InvDatasetImpl dapDataset = this.createDataset(new String[]{"FILE"});
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendLeafNode((MutableTreeNode)this.parentNode, this.getDefaultTreeModel(), (InvDataset)dapDataset);
        this.testThatChildIsNodeWithFileAccess(this.parentNode);
    }

    @Test
    public void testAppendDatasetWhichHasDapAccessAndAlsoFileAccess() throws URISyntaxException {
        String dapServiceName = "OPENDAP";
        String fileServiceName = "FILE";
        InvDatasetImpl dapDataset = this.createDataset(new String[]{"FILE", "OPENDAP"});
        new CatalogTree(null, (AppContext)new DefaultAppContext(""), null).appendLeafNode((MutableTreeNode)this.parentNode, this.getDefaultTreeModel(), (InvDataset)dapDataset);
        this.testThatChildIsDapNodeWhichHasFileAccessToo(this.parentNode);
    }

    @Test
    public void testAppendCatalogNodeToParent() throws URISyntaxException {
        URI whatever = null;
        InvCatalogRef catalogReference = new InvCatalogRef(null, "catalogRefName", "http://a.b");
        catalogReference.setCatalog((InvCatalog)new InvCatalogImpl("whatever", "1.0", whatever));
        CatalogTreeUtils.appendCatalogNode((MutableTreeNode)this.parentNode, (DefaultTreeModel)this.getDefaultTreeModel(), (InvCatalogRef)catalogReference);
        Assert.assertEquals((long)1L, (long)this.parentNode.getChildCount());
        Assert.assertEquals((long)1L, (long)this.parentNode.getChildAt(0).getChildCount());
        DefaultMutableTreeNode child1 = (DefaultMutableTreeNode)this.parentNode.getChildAt(0);
        Assert.assertEquals((Object)true, (Object)(child1.getUserObject() instanceof String));
        Assert.assertEquals((Object)"catalogRefName", (Object)child1.getUserObject());
        DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)this.parentNode.getChildAt(0).getChildAt(0);
        Assert.assertEquals((Object)true, (Object)(child2.getUserObject() instanceof CatalogNode));
        CatalogNode catalogNode = (CatalogNode)child2.getUserObject();
        Assert.assertEquals((Object)"http://a.b", (Object)catalogNode.getCatalogUri());
    }

    private void testThatChildIsNodeWithFileAccess(DefaultMutableTreeNode parentNode) {
        Assert.assertEquals((long)1L, (long)parentNode.getChildCount());
        Assert.assertEquals((Object)true, (Object)parentNode.getChildAt(0).isLeaf());
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)parentNode.getChildAt(0)));
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isFileNode((Object)parentNode.getChildAt(0)));
    }

    private void testThatChildIsOnlyDapNodeWithoutFileAccess(DefaultMutableTreeNode parentNode) {
        this.testThatChildIsDapNode(parentNode);
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isFileNode((Object)parentNode.getChildAt(0)));
    }

    private void testThatChildIsDapNodeWhichHasFileAccessToo(DefaultMutableTreeNode parentNode) {
        this.testThatChildIsDapNode(parentNode);
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isFileNode((Object)parentNode.getChildAt(0)));
    }

    private void testThatChildIsDapNode(DefaultMutableTreeNode parentNode) {
        Assert.assertEquals((long)1L, (long)parentNode.getChildCount());
        Assert.assertEquals((Object)true, (Object)parentNode.getChildAt(0).isLeaf());
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)parentNode.getChildAt(0)));
    }

    private InvDatasetImpl createDataset(String[] serviceTypeNames) throws URISyntaxException {
        InvDatasetImpl dapDataset = new InvDatasetImpl(null, "datasetName", FeatureType.NONE, serviceTypeNames[0], "http://wherever.you.want.bc");
        InvCatalogImpl catalog = new InvCatalogImpl("catalogName", "1.0", new URI("http://x.y"));
        dapDataset.setCatalog((InvCatalog)catalog);
        for (String serviceName : serviceTypeNames) {
            InvService dapService = new InvService(serviceName, serviceName, "irrelevant", "irrelevant", "irrelevant");
            InvAccessImpl invAccess = new InvAccessImpl((InvDataset)dapDataset, "http://y.z", dapService);
            dapDataset.addAccess((InvAccess)invAccess);
        }
        dapDataset.finish();
        return dapDataset;
    }

    private DefaultTreeModel getDefaultTreeModel() {
        return (DefaultTreeModel)new JTree().getModel();
    }
}

