/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap;

import junit.framework.Assert;
import opendap.dap.DArrayDimension;
import org.esa.beam.opendap.datamodel.DAPVariable;
import org.junit.Before;
import org.junit.Test;

public class DAPVariableTest {
    private String vType;
    private String vDataType;
    private String vName;
    private DArrayDimension validXDim;
    private DArrayDimension validYDim;
    private DArrayDimension[] vDimensions;
    private DAPVariable dapVariable;

    @Before
    public void setUp() throws Exception {
        this.vName = "validName";
        this.vType = "validType";
        this.vDataType = "Float32";
        this.validXDim = new DArrayDimension(1121, "X");
        this.validYDim = new DArrayDimension(812, "Y");
        this.vDimensions = new DArrayDimension[]{this.validYDim, this.validXDim};
        this.dapVariable = new DAPVariable(this.vName, this.vType, this.vDataType, this.vDimensions);
    }

    @Test
    public void testGetInfoString() {
        Assert.assertEquals((String)"Float32 validName (Y:812, X:1121)", (String)this.dapVariable.getInfotext());
        DAPVariable metadataVariable = new DAPVariable("metadata", "someType", "byte", new DArrayDimension[0]);
        Assert.assertEquals((String)"byte metadata", (String)metadataVariable.getInfotext());
    }

    @Test
    public void testCompareTo() {
        DAPVariable dapVariable2 = new DAPVariable(this.vName, this.vType, this.vDataType, this.vDimensions);
        DAPVariable dapVariable3 = new DAPVariable("zzzzzzName", this.vType, this.vDataType, this.vDimensions);
        DAPVariable dapVariable4 = new DAPVariable("ZzzzzzName", this.vType, this.vDataType, this.vDimensions);
        DAPVariable dapVariable5 = new DAPVariable("aAAnotherName", this.vType, this.vDataType, this.vDimensions);
        DAPVariable dapVariable6 = new DAPVariable("AAAnotherName", this.vType, this.vDataType, this.vDimensions);
        DAPVariable dapVariable7 = new DAPVariable(this.vName, this.vType, this.vDataType, new DArrayDimension[0]);
        Assert.assertEquals((int)0, (int)this.dapVariable.compareTo(dapVariable2));
        Assert.assertEquals((int)-1, (int)this.dapVariable.compareTo(dapVariable3));
        Assert.assertEquals((int)-1, (int)this.dapVariable.compareTo(dapVariable4));
        Assert.assertEquals((int)1, (int)this.dapVariable.compareTo(dapVariable5));
        Assert.assertEquals((int)1, (int)this.dapVariable.compareTo(dapVariable6));
        Assert.assertEquals((int)1, (int)this.dapVariable.compareTo(dapVariable7));
    }

    @Test
    public void testEquals() throws Exception {
        DAPVariable dapVariable2 = new DAPVariable(this.vName, this.vType, this.vDataType, this.vDimensions);
        DArrayDimension otherDimension = new DArrayDimension(1000, "otherDimension");
        DAPVariable dapVariable3 = new DAPVariable(this.vName, this.vType, this.vDataType, new DArrayDimension[]{otherDimension});
        DArrayDimension otherXDimension = new DArrayDimension(1121, "X");
        DArrayDimension otherYDimension = new DArrayDimension(812, "Y");
        DArrayDimension[] otherDimensions = new DArrayDimension[]{otherYDimension, otherXDimension};
        DAPVariable dapVariable4 = new DAPVariable(this.vName, this.vType, this.vDataType, otherDimensions);
        Assert.assertTrue((boolean)this.dapVariable.equals((Object)dapVariable2));
        Assert.assertFalse((boolean)this.dapVariable.equals((Object)dapVariable3));
        Assert.assertTrue((boolean)this.dapVariable.equals((Object)dapVariable4));
    }

    @Test
    public void testIllegalArgumentExceptionIsThrownIfNameIsNotValid() {
        String invalidName1 = null;
        String invalidName2 = "";
        String invalidName3 = "    ";
        try {
            new DAPVariable(invalidName1, this.vType, this.vDataType, this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"name", (String)e.getMessage());
        }
        try {
            new DAPVariable("", this.vType, this.vDataType, this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"name", (String)e.getMessage());
        }
        try {
            new DAPVariable("    ", this.vType, this.vDataType, this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"'    ' is not a valid name", (String)e.getMessage());
        }
    }

    @Test
    public void testIllegalArgumentExceptionIsThrownIfTypeIsNotValid() {
        String invalidType1 = null;
        String invalidType2 = "";
        String invalidType3 = "    ";
        try {
            new DAPVariable(this.vName, invalidType1, this.vDataType, this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"type", (String)e.getMessage());
        }
        try {
            new DAPVariable(this.vName, "", this.vDataType, this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"type", (String)e.getMessage());
        }
        try {
            new DAPVariable(this.vName, "    ", this.vDataType, this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"'    ' is not a valid type", (String)e.getMessage());
        }
    }

    @Test
    public void testIllegalArgumentExceptionIsThrownIfDataTypeIsNotValid() {
        String invalidDataType1 = null;
        String invalidDataType2 = "";
        String invalidDataType3 = "    ";
        try {
            new DAPVariable(this.vName, this.vType, invalidDataType1, this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"dataType", (String)e.getMessage());
        }
        try {
            new DAPVariable(this.vName, this.vType, "", this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"dataType", (String)e.getMessage());
        }
        try {
            new DAPVariable(this.vName, this.vType, "    ", this.vDimensions);
            Assert.fail((String)"never come here");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"'    ' is not a valid dataType", (String)e.getMessage());
        }
    }

    @Test
    public void testIllegalArgumentExceptionIsThrownIfDimensionsIsNotValid() {
        DArrayDimension[] invalidDimensions = null;
        try {
            new DAPVariable(this.vName, this.vType, this.vDataType, invalidDimensions);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"dimensions may not be null", (String)e.getMessage());
        }
    }
}

