/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import opendap.dap.BaseType;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DConnect2;
import opendap.dap.DDS;
import opendap.dap.DGrid;
import org.esa.beam.opendap.datamodel.DAPVariable;
import org.esa.beam.opendap.datamodel.OpendapLeaf;

public class VariableExtractor {
    public DAPVariable[] extractVariables(OpendapLeaf leaf) {
        DDS dds = this.getDDS(leaf.getDdsUri());
        return this.extractVariables(dds);
    }

    public DAPVariable[] extractVariables(DDS dds) {
        Enumeration ddsVariables = dds.getVariables();
        ArrayList<DAPVariable> dapVariables = new ArrayList<DAPVariable>();
        while (ddsVariables.hasMoreElements()) {
            BaseType ddsVariable = (BaseType)ddsVariables.nextElement();
            DAPVariable dapVariable = VariableExtractor.convertToDAPVariable(ddsVariable);
            dapVariables.add(dapVariable);
        }
        return dapVariables.toArray(new DAPVariable[dapVariables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DDS getDDS(String uri) {
        InputStream stream = null;
        DConnect2 dConnect2 = null;
        DDS dds = new DDS();
        try {
            stream = new URI(uri).toURL().openStream();
            dConnect2 = new DConnect2(stream);
            dds = dConnect2.getDDS();
        }
        catch (Exception e) {
        }
        finally {
            if (dConnect2 != null) {
                dConnect2.closeSession();
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return dds;
    }

    private static DAPVariable convertToDAPVariable(BaseType ddsVariable) {
        DArray array;
        if (ddsVariable instanceof DGrid) {
            DGrid grid = (DGrid)ddsVariable;
            array = grid.getArray();
        } else if (ddsVariable instanceof DArray) {
            array = (DArray)ddsVariable;
        } else {
            return VariableExtractor.convertToAtomicDAPVariable(ddsVariable);
        }
        String name = ddsVariable.getEncodedName();
        String typeName = ddsVariable.getTypeName();
        String dataTypeName = VariableExtractor.getDataTypeName(array);
        DArrayDimension[] dimensions = VariableExtractor.getDimensions(array);
        return new DAPVariable(name, typeName, dataTypeName, dimensions);
    }

    private static DAPVariable convertToAtomicDAPVariable(BaseType ddsVariable) {
        String name = ddsVariable.getEncodedName();
        String typeName = "atomic";
        String dataTypeName = ddsVariable.getTypeName();
        DArrayDimension[] dimensions = new DArrayDimension[]{};
        return new DAPVariable(name, "atomic", dataTypeName, dimensions);
    }

    private static String getDataTypeName(DArray array) {
        return array.getPrimitiveVector().getTemplate().getTypeName();
    }

    private static DArrayDimension[] getDimensions(DArray array) {
        Enumeration dimensions = array.getDimensions();
        ArrayList<DArrayDimension> dims = new ArrayList<DArrayDimension>();
        while (dimensions.hasMoreElements()) {
            DArrayDimension dimension = (DArrayDimension)dimensions.nextElement();
            dims.add(dimension);
        }
        return dims.toArray(new DArrayDimension[dims.size()]);
    }
}

