/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.utils;

import com.bc.ceres.binding.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.beam.util.TimeStampExtractor;

public class PatternProvider {
    public static final String[] DATE_PATTERNS = new String[]{"yyyyMMdd_hhmmss", "yyyyMMdd:hhmmss", "yyyyMMddhhmmss", "yyyyMMddhh", "yyyyMMdd", "yyyyMM"};
    public static final String[] FILENAME_PATTERNS = new String[]{"*${startDate}*", "*${startDate}*${endDate}*"};

    public static List<String[]> recommendPatterns(String fileName) {
        fileName = PatternProvider.replaceColon(fileName);
        ArrayList<String[]> patternCombinations = new ArrayList<String[]>();
        for (String dateString : DATE_PATTERNS) {
            Pattern datePattern = PatternProvider.convertDateStringToPattern(dateString = PatternProvider.replaceColon(dateString));
            Matcher matcher = datePattern.matcher(fileName);
            if (!matcher.matches()) continue;
            TimeStampExtractor timeStampExtractor = new TimeStampExtractor(dateString, FILENAME_PATTERNS[0]);
            try {
                timeStampExtractor.extractTimeStamps(fileName);
                patternCombinations.add(new String[]{PatternProvider.insertColon(dateString), FILENAME_PATTERNS[0]});
                try {
                    timeStampExtractor = new TimeStampExtractor(PatternProvider.insertColon(dateString), FILENAME_PATTERNS[1]);
                    timeStampExtractor.extractTimeStamps(fileName);
                    patternCombinations.add(new String[]{dateString, FILENAME_PATTERNS[1]});
                }
                catch (ValidationException e) {}
            }
            catch (ValidationException e) {
                // empty catch block
            }
        }
        return patternCombinations;
    }

    private static String replaceColon(String replace) {
        return replace.replace(":", "colon");
    }

    private static String insertColon(String replace) {
        return replace.replace("colon", ":");
    }

    private static Pattern convertDateStringToPattern(String datePattern) {
        String validSign = "[\\w\\. -]";
        String anyTimesModifier = "*";
        String starSignPattern = "[\\w\\. -]*";
        String dateMatcher = PatternProvider.getDateMatcher(datePattern);
        return Pattern.compile("[\\w\\. -]*" + dateMatcher + "[\\w\\. -]*");
    }

    private static String getDateMatcher(String datePattern) {
        String yearPattern = "yyyy";
        String monthPattern = "MM";
        String dayPattern = "dd";
        String hourPattern = "hh";
        String minutePattern = "mm";
        String secondPattern = "ss";
        String yearMatcher = "(\\\\d{" + "yyyy".length() + "})";
        String monthMatcher = "(\\\\d{" + "MM".length() + "})";
        String dayMatcher = "(\\\\d{" + "dd".length() + "})";
        String hourMatcher = "(\\\\d{" + "hh".length() + "})";
        String minuteMatcher = "(\\\\d{" + "mm".length() + "})";
        String secondMatcher = "(\\\\d{" + "ss".length() + "})";
        String dateMatcher = datePattern.replaceAll("yyyy", yearMatcher);
        dateMatcher = dateMatcher.replaceAll("MM", monthMatcher);
        dateMatcher = dateMatcher.replaceAll("dd", dayMatcher);
        dateMatcher = dateMatcher.replaceAll("hh", hourMatcher);
        dateMatcher = dateMatcher.replaceAll("mm", minuteMatcher);
        dateMatcher = dateMatcher.replaceAll("ss", secondMatcher);
        return dateMatcher;
    }
}

