/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;

public class TitledPanel
extends JPanel {
    public TitledPanel(JComponent titleComponent, JComponent bodyComponent) {
        this(titleComponent, bodyComponent, false, false);
    }

    public TitledPanel(JComponent titleComponent, JComponent bodyComponent, boolean isCollapsible, boolean isInitiallyCollapsed) {
        super(new BorderLayout());
        JPanel titleArea = new JPanel(new BorderLayout());
        if (titleComponent != null) {
            titleArea.add((Component)titleComponent, "West");
        }
        titleArea.add((Component)this.getSeparator(), "Center");
        if (isCollapsible) {
            titleArea.add((Component)this.getCollapseButton(bodyComponent, isInitiallyCollapsed), "East");
            bodyComponent.setVisible(!isInitiallyCollapsed);
        }
        this.add((Component)titleArea, "North");
        if (bodyComponent != null) {
            bodyComponent.setBorder(new EmptyBorder(0, 30, 0, 0));
            this.add((Component)bodyComponent, "Center");
        }
        this.setBorder(new EmptyBorder(4, 8, 4, 8));
    }

    private JComponent getCollapseButton(JComponent bodyComponent, boolean isInitiallyCollapsed) {
        AbstractButton hideAndShowButton;
        if (isInitiallyCollapsed) {
            hideAndShowButton = ToolButtonFactory.createButton((Icon)CollapseSupport.expandIcon, (boolean)false);
            hideAndShowButton.setRolloverIcon(CollapseSupport.expandRolloverIcon);
            hideAndShowButton.setToolTipText("Expand Panel");
        } else {
            hideAndShowButton = ToolButtonFactory.createButton((Icon)CollapseSupport.collapseIcon, (boolean)false);
            hideAndShowButton.setRolloverIcon(CollapseSupport.collapseRolloverIcon);
            hideAndShowButton.setToolTipText("Collapse Panel");
        }
        hideAndShowButton.addActionListener(new CollapseSupport(isInitiallyCollapsed, bodyComponent, hideAndShowButton));
        return hideAndShowButton;
    }

    private JPanel getSeparator() {
        JSeparator separator = new JSeparator(0);
        JPanel separatorPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        separatorPanel.add((Component)separator, gbc);
        return separatorPanel;
    }

    private static class CollapseSupport
    implements ActionListener {
        public boolean componentShown;
        private final JComponent bodyComponent;
        private final AbstractButton hideAndShowButton;
        private static final ImageIcon collapseIcon = UIUtils.loadImageIcon((String)"icons/PanelUp12.png");
        private static final ImageIcon collapseRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)collapseIcon);
        private static final ImageIcon expandIcon = UIUtils.loadImageIcon((String)"icons/PanelDown12.png");
        private static final ImageIcon expandRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)expandIcon);

        public CollapseSupport(boolean isInitiallyCollapsed, JComponent bodyComponent, AbstractButton hideAndShowButton) {
            this.bodyComponent = bodyComponent;
            this.hideAndShowButton = hideAndShowButton;
            this.componentShown = !isInitiallyCollapsed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.componentShown = !this.componentShown;
            this.bodyComponent.setVisible(this.componentShown);
            if (this.componentShown) {
                this.hideAndShowButton.setIcon(collapseIcon);
                this.hideAndShowButton.setRolloverIcon(collapseRolloverIcon);
                this.hideAndShowButton.setToolTipText("Collapse Panel");
            } else {
                this.hideAndShowButton.setIcon(expandIcon);
                this.hideAndShowButton.setRolloverIcon(expandRolloverIcon);
                this.hideAndShowButton.setToolTipText("Expand Panel");
            }
        }
    }
}

