/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import com.bc.ceres.binding.ValidationException;
import com.jidesoft.combobox.DateExComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.FilterChangeListener;
import org.esa.beam.opendap.ui.FilterComponent;
import org.esa.beam.opendap.utils.PatternProvider;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.TimeStampExtractor;
import org.esa.beam.util.logging.BeamLogManager;
import ucar.nc2.units.DateRange;

public class TimeRangeFilter
implements FilterComponent {
    private JComboBox datePatternComboBox;
    private JComboBox fileNamePatternComboBox;
    private DateExComboBox startTimePicker;
    private DateExComboBox stopTimePicker;
    private JButton applyButton;
    private JCheckBox filterCheckBox;
    TimeStampExtractor timeStampExtractor;
    List<FilterChangeListener> listeners;
    List<JLabel> labels;
    Date startDate;
    Date endDate;

    public TimeRangeFilter(JCheckBox filterCheckBox) {
        this.filterCheckBox = filterCheckBox;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        this.startTimePicker = new DateExComboBox();
        this.startTimePicker.setFormat((DateFormat)dateFormat);
        this.stopTimePicker = new DateExComboBox();
        this.stopTimePicker.setFormat((DateFormat)dateFormat);
        int width = 150;
        Dimension ps = this.startTimePicker.getPreferredSize();
        Dimension comboBoxDimension = new Dimension(150, ps.height);
        this.setComboBoxSize(comboBoxDimension, (JComboBox)this.startTimePicker);
        this.setComboBoxSize(comboBoxDimension, (JComboBox)this.stopTimePicker);
        this.datePatternComboBox = new JComboBox();
        this.setComboBoxSize(comboBoxDimension, this.datePatternComboBox);
        this.datePatternComboBox.setEditable(true);
        this.fileNamePatternComboBox = new JComboBox();
        this.setComboBoxSize(comboBoxDimension, this.fileNamePatternComboBox);
        this.fileNamePatternComboBox.setEditable(true);
        this.initPatterns();
        UIUpdater uiUpdater = new UIUpdater();
        TimePickerValidator timePickerValidator = new TimePickerValidator();
        filterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeRangeFilter.this.updateUIState();
                if (TimeRangeFilter.this.timeStampExtractor != null) {
                    TimeRangeFilter.this.fireFilterChangedEvent();
                }
            }
        });
        this.startTimePicker.addActionListener((ActionListener)uiUpdater);
        this.startTimePicker.addActionListener((ActionListener)timePickerValidator);
        this.stopTimePicker.addActionListener((ActionListener)uiUpdater);
        this.stopTimePicker.addActionListener((ActionListener)timePickerValidator);
        this.datePatternComboBox.addActionListener(uiUpdater);
        this.fileNamePatternComboBox.addActionListener(uiUpdater);
        this.listeners = new ArrayList<FilterChangeListener>();
        this.labels = new ArrayList<JLabel>();
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeRangeFilter.this.timeStampExtractor = StringUtils.isNotNullAndNotEmpty((String)TimeRangeFilter.this.datePatternComboBox.getEditor().getItem().toString()) && StringUtils.isNotNullAndNotEmpty((String)TimeRangeFilter.this.fileNamePatternComboBox.getEditor().getItem().toString()) ? new TimeStampExtractor(TimeRangeFilter.this.datePatternComboBox.getSelectedItem().toString(), TimeRangeFilter.this.fileNamePatternComboBox.getSelectedItem().toString()) : null;
                TimeRangeFilter.this.startDate = TimeRangeFilter.this.startTimePicker.getDate();
                TimeRangeFilter.this.endDate = TimeRangeFilter.this.stopTimePicker.getDate();
                TimeRangeFilter.this.updateUIState();
                TimeRangeFilter.this.applyButton.setEnabled(false);
                TimeRangeFilter.this.fireFilterChangedEvent();
            }
        });
    }

    private void updateUIState() {
        boolean patternProvided;
        boolean isSelected = this.filterCheckBox.isSelected();
        this.datePatternComboBox.setEnabled(isSelected);
        this.fileNamePatternComboBox.setEnabled(isSelected);
        this.startTimePicker.setEnabled(isSelected);
        this.stopTimePicker.setEnabled(isSelected);
        for (JLabel label : this.labels) {
            label.setEnabled(isSelected);
        }
        String datePattern = this.datePatternComboBox.getSelectedItem().toString();
        String fileNamePattern = this.fileNamePatternComboBox.getSelectedItem().toString();
        boolean hasStartDate = this.startTimePicker.getDate() != null;
        boolean hasEndDate = this.stopTimePicker.getDate() != null;
        boolean bl = patternProvided = !"".equals(datePattern) && !"".equals(fileNamePattern);
        if (isSelected && (patternProvided || !hasStartDate && !hasEndDate)) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }

    private void initPatterns() {
        this.datePatternComboBox.addItem("");
        this.fileNamePatternComboBox.addItem("");
        for (String datePattern : PatternProvider.DATE_PATTERNS) {
            this.datePatternComboBox.addItem(datePattern);
        }
        for (String fileNamePattern : PatternProvider.FILENAME_PATTERNS) {
            this.fileNamePatternComboBox.addItem(fileNamePattern);
        }
    }

    private void setComboBoxSize(Dimension comboBoxDimension, JComboBox comboBox) {
        comboBox.setPreferredSize(comboBoxDimension);
        comboBox.setMinimumSize(comboBoxDimension);
    }

    @Override
    public JComponent getUI() {
        JPanel filterUI = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets.bottom = 4;
        gbc.insets.right = 4;
        gbc.anchor = 17;
        JLabel datePatternLabel = new JLabel("Date pattern:");
        filterUI.add((Component)datePatternLabel, gbc);
        ++gbc.gridx;
        filterUI.add((Component)this.datePatternComboBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel filenamePatternLabel = new JLabel("Filename pattern:");
        filterUI.add((Component)filenamePatternLabel, gbc);
        ++gbc.gridx;
        filterUI.add((Component)this.fileNamePatternComboBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel startDateLabel = new JLabel("Start date:");
        filterUI.add((Component)startDateLabel, gbc);
        ++gbc.gridx;
        filterUI.add((Component)this.startTimePicker, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel stopDateLabel = new JLabel("Stop date:");
        filterUI.add((Component)stopDateLabel, gbc);
        ++gbc.gridx;
        filterUI.add((Component)this.stopTimePicker, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        filterUI.add((Component)this.applyButton, gbc);
        this.labels.add(datePatternLabel);
        this.labels.add(filenamePatternLabel);
        this.labels.add(startDateLabel);
        this.labels.add(stopDateLabel);
        this.updateUIState();
        return filterUI;
    }

    @Override
    public boolean accept(OpendapLeaf leaf) {
        DateRange timeCoverage = leaf.getDataset().getTimeCoverage();
        if (timeCoverage != null) {
            return this.fitsToServerSpecifiedTimeRange(timeCoverage);
        }
        if (this.timeStampExtractor != null) {
            return this.fitsToUserSpecifiedTimeRange(leaf);
        }
        return true;
    }

    private boolean fitsToServerSpecifiedTimeRange(DateRange dateRange) {
        if (this.startDate == null && this.endDate == null) {
            return true;
        }
        if (this.startDate == null) {
            return this.endsAtOrBeforeEndDate(dateRange);
        }
        if (this.endDate == null) {
            return this.startsAtOrAfterStartDate(dateRange);
        }
        return this.startsAtOrAfterStartDate(dateRange) && this.endsAtOrBeforeEndDate(dateRange);
    }

    private boolean endsAtOrBeforeEndDate(DateRange dateRange) {
        return dateRange.getEnd().getDate().equals(this.endDate) || dateRange.getEnd().before(this.endDate);
    }

    private boolean startsAtOrAfterStartDate(DateRange dateRange) {
        return dateRange.getStart().getDate().equals(this.startDate) || dateRange.getStart().after(this.startDate);
    }

    private boolean fitsToUserSpecifiedTimeRange(OpendapLeaf leaf) {
        try {
            boolean userHasEndDate;
            boolean startDateEqualsEndDate;
            ProductData.UTC[] timeStamps = this.timeStampExtractor.extractTimeStamps(leaf.getName());
            boolean bl = startDateEqualsEndDate = timeStamps[0].getAsDate().getTime() == timeStamps[1].getAsDate().getTime();
            if (startDateEqualsEndDate) {
                timeStamps[1] = null;
            }
            boolean fileHasEndDate = timeStamps[1] != null;
            boolean userHasStartDate = this.startDate != null;
            boolean bl2 = userHasEndDate = this.endDate != null;
            if (userHasStartDate && this.startDate.after(timeStamps[0].getAsDate())) {
                return false;
            }
            return !userHasEndDate || !(fileHasEndDate ? this.endDate.before(timeStamps[1].getAsDate()) : this.endDate.before(timeStamps[0].getAsDate()));
        }
        catch (ValidationException e) {
            return true;
        }
    }

    @Override
    public void addFilterChangeListener(FilterChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireFilterChangedEvent() {
        for (FilterChangeListener listener : this.listeners) {
            listener.filterChanged();
        }
    }

    private class TimePickerValidator
    implements ActionListener {
        private TimePickerValidator() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Date startDate = TimeRangeFilter.this.startTimePicker.getDate();
            Date endDate = TimeRangeFilter.this.stopTimePicker.getDate();
            if (startDate == null || endDate == null) {
                return;
            }
            if (startDate.after(endDate)) {
                if (e.getSource().equals(TimeRangeFilter.this.startTimePicker)) {
                    TimeRangeFilter.this.startTimePicker.setDate(endDate);
                    BeamLogManager.getSystemLogger().info("Start date after end date: Set start date to end date.");
                } else if (e.getSource().equals(TimeRangeFilter.this.stopTimePicker)) {
                    TimeRangeFilter.this.stopTimePicker.setDate(startDate);
                    BeamLogManager.getSystemLogger().info("Start date after end date: Set end date to start date.");
                }
            }
        }
    }

    private class UIUpdater
    implements ActionListener {
        private UIUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeRangeFilter.this.updateUIState();
        }
    }
}

