/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.esa.beam.framework.ui.RegionBoundsInputUI;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.FilterChangeListener;
import org.esa.beam.opendap.ui.FilterComponent;
import thredds.catalog.ThreddsMetadata;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class RegionFilter
implements FilterComponent {
    private final JButton applyButton;
    private final List<FilterChangeListener> filterChangeListeners;
    private RegionBoundsInputUI regionBoundsInputUI;
    Property eastBoundProperty;
    Property westBoundProperty;
    Property northBoundProperty;
    Property southBoundProperty;
    private final JCheckBox useRegionFilter;

    public RegionFilter(final JCheckBox useRegionFilter) {
        this.useRegionFilter = useRegionFilter;
        this.filterChangeListeners = new ArrayList<FilterChangeListener>();
        useRegionFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegionFilter.this.fireFilterChanged();
                RegionFilter.this.updateUI(useRegionFilter.isSelected(), useRegionFilter.isSelected());
            }
        });
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegionFilter.this.fireFilterChanged();
                RegionFilter.this.updateUI(false, true);
            }
        });
    }

    @Override
    public JComponent getUI() {
        JPanel regionPanel = new JPanel(new BorderLayout());
        this.regionBoundsInputUI = new RegionBoundsInputUI();
        this.regionBoundsInputUI.getUI().setBorder(new EmptyBorder(0, 0, 8, 0));
        regionPanel.add((Component)this.regionBoundsInputUI.getUI(), "North");
        regionPanel.add((Component)this.applyButton, "East");
        PropertySet propertySet = this.regionBoundsInputUI.getBindingContext().getPropertySet();
        this.eastBoundProperty = propertySet.getProperty("eastBound");
        this.westBoundProperty = propertySet.getProperty("westBound");
        this.northBoundProperty = propertySet.getProperty("northBound");
        this.southBoundProperty = propertySet.getProperty("southBound");
        BoundsChangeListener boundsChangeListener = new BoundsChangeListener();
        this.eastBoundProperty.addPropertyChangeListener((PropertyChangeListener)boundsChangeListener);
        this.westBoundProperty.addPropertyChangeListener((PropertyChangeListener)boundsChangeListener);
        this.northBoundProperty.addPropertyChangeListener((PropertyChangeListener)boundsChangeListener);
        this.southBoundProperty.addPropertyChangeListener((PropertyChangeListener)boundsChangeListener);
        this.updateUI(false, false);
        return regionPanel;
    }

    @Override
    public boolean accept(OpendapLeaf leaf) {
        LatLonPointImpl southEast;
        ThreddsMetadata.GeospatialCoverage geospatialCoverage = leaf.getDataset().getGeospatialCoverage();
        if (geospatialCoverage == null) {
            return true;
        }
        Double eastBound = (Double)this.eastBoundProperty.getValue();
        Double westBound = (Double)this.westBoundProperty.getValue();
        Double northBound = (Double)this.northBoundProperty.getValue();
        Double southBound = (Double)this.southBoundProperty.getValue();
        LatLonPointImpl northWest = new LatLonPointImpl(northBound.doubleValue(), westBound.doubleValue());
        LatLonRect latLonRect = new LatLonRect((LatLonPoint)northWest, (LatLonPoint)(southEast = new LatLonPointImpl(southBound.doubleValue(), eastBound.doubleValue())));
        return latLonRect.intersect(geospatialCoverage.getBoundingBox()) != null;
    }

    @Override
    public void addFilterChangeListener(FilterChangeListener listener) {
        this.filterChangeListeners.add(listener);
    }

    private void fireFilterChanged() {
        for (FilterChangeListener filterChangeListener : this.filterChangeListeners) {
            filterChangeListener.filterChanged();
        }
    }

    private void updateUI(boolean enableApplyButton, boolean enableRegionBoundsInputUI) {
        if (this.useRegionFilter.isSelected()) {
            this.applyButton.setEnabled(enableApplyButton);
            this.regionBoundsInputUI.setEnabled(enableRegionBoundsInputUI);
        } else {
            this.applyButton.setEnabled(false);
            this.regionBoundsInputUI.setEnabled(false);
        }
    }

    private class BoundsChangeListener
    implements PropertyChangeListener {
        private BoundsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RegionFilter.this.updateUI(true, true);
        }
    }
}

