/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.FolderChooserComboBox;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.ProgressStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.swing.SimpleScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.GridBagUtils;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.esa.beam.opendap.ui.DatasetNameFilter;
import org.esa.beam.opendap.ui.DownloadAction;
import org.esa.beam.opendap.ui.DownloadProgressBarPM;
import org.esa.beam.opendap.ui.FilterChangeListener;
import org.esa.beam.opendap.ui.FilterComponent;
import org.esa.beam.opendap.ui.RegionFilter;
import org.esa.beam.opendap.ui.TimeRangeFilter;
import org.esa.beam.opendap.ui.TitledPanel;
import org.esa.beam.opendap.ui.VariableFilter;
import org.esa.beam.opendap.utils.OpendapUtils;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.esa.beam.visat.VisatApp;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;

public class OpendapAccessPanel
extends JPanel
implements CatalogTree.UIContext {
    private static final String PROPERTY_KEY_SERVER_URLS = "opendap.server.urls";
    private static final int DDS_AREA_INDEX = 0;
    private static final int DAS_AREA_INDEX = 1;
    private JComboBox urlField;
    private AbstractButton refreshButton;
    private CatalogTree catalogTree;
    private JTabbedPane metaInfoArea;
    private JCheckBox useDatasetNameFilter;
    private FilterComponent datasetNameFilter;
    private JCheckBox useTimeRangeFilter;
    private FilterComponent timeRangeFilter;
    private JCheckBox useRegionFilter;
    private FilterComponent regionFilter;
    private JCheckBox useVariableFilter;
    private VariableFilter variableFilter;
    private JCheckBox openInVisat;
    private StatusBar statusBar;
    private double currentDataSize = 0.0;
    private final PropertyMap propertyMap;
    private final String helpId;
    private FolderChooserComboBox folderChooserComboBox;
    private JProgressBar progressBar;
    private JLabel preMessageLabel;
    private JLabel postMessageLabel;
    private Map<Integer, JTextArea> textAreas;
    private JButton downloadButton;
    private AppContext appContext;
    private JButton cancelButton;

    public OpendapAccessPanel(AppContext appContext, String helpId) {
        this.propertyMap = appContext.getPreferences();
        this.helpId = helpId;
        this.appContext = appContext;
        this.initComponents();
        this.initContentPane();
    }

    private void initComponents() {
        this.urlField = new JComboBox();
        this.urlField.setEditable(true);
        this.urlField.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    OpendapAccessPanel.this.refreshButton.doClick();
                }
            }
        });
        this.updateUrlField();
        this.refreshButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/beam/opendap/images/icons/ViewRefresh22.png", OpendapAccessPanel.class), (boolean)false);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentUrl;
                String urls;
                boolean usingUrl = OpendapAccessPanel.this.refresh();
                if (usingUrl && !(urls = OpendapAccessPanel.this.propertyMap.getPropertyString(OpendapAccessPanel.PROPERTY_KEY_SERVER_URLS)).contains(currentUrl = OpendapAccessPanel.this.urlField.getSelectedItem().toString())) {
                    OpendapAccessPanel.this.propertyMap.setPropertyString(OpendapAccessPanel.PROPERTY_KEY_SERVER_URLS, urls + "\n" + currentUrl);
                    OpendapAccessPanel.this.updateUrlField();
                }
            }
        });
        this.metaInfoArea = new JTabbedPane(1, 1);
        JTextArea ddsArea = new JTextArea(10, 40);
        JTextArea dasArea = new JTextArea(10, 40);
        ddsArea.setEditable(false);
        dasArea.setEditable(false);
        this.textAreas = new HashMap<Integer, JTextArea>();
        this.textAreas.put(1, dasArea);
        this.textAreas.put(0, ddsArea);
        this.metaInfoArea.addTab("DDS", new JScrollPane(ddsArea));
        this.metaInfoArea.addTab("DAS", new JScrollPane(dasArea));
        this.metaInfoArea.setToolTipTextAt(0, "Dataset Descriptor Structure: description of dataset variables");
        this.metaInfoArea.setToolTipTextAt(1, "Dataset Attribute Structure: description of dataset attributes");
        this.metaInfoArea.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (OpendapAccessPanel.this.catalogTree.getSelectedLeaf() != null) {
                    OpendapAccessPanel.this.setMetadataText(OpendapAccessPanel.this.metaInfoArea.getSelectedIndex(), OpendapAccessPanel.this.catalogTree.getSelectedLeaf());
                }
            }
        });
        this.catalogTree = new CatalogTree(new DefaultLeafSelectionListener(), this.appContext, this);
        this.useDatasetNameFilter = new JCheckBox("Use dataset name filter");
        this.useTimeRangeFilter = new JCheckBox("Use time range filter");
        this.useRegionFilter = new JCheckBox("Use region filter");
        this.useVariableFilter = new JCheckBox("Use variable name filter");
        DefaultFilterChangeListener filterChangeListener = new DefaultFilterChangeListener();
        this.datasetNameFilter = new DatasetNameFilter(this.useDatasetNameFilter);
        this.datasetNameFilter.addFilterChangeListener(filterChangeListener);
        this.timeRangeFilter = new TimeRangeFilter(this.useTimeRangeFilter);
        this.timeRangeFilter.addFilterChangeListener(filterChangeListener);
        this.regionFilter = new RegionFilter(this.useRegionFilter);
        this.regionFilter.addFilterChangeListener(filterChangeListener);
        this.variableFilter = new VariableFilter(this.useVariableFilter, this.catalogTree);
        this.variableFilter.addFilterChangeListener(filterChangeListener);
        this.catalogTree.addCatalogTreeListener(new CatalogTree.CatalogTreeListener(){

            @Override
            public void leafAdded(OpendapLeaf leaf, boolean hasNestedDatasets) {
                if (hasNestedDatasets) {
                    return;
                }
                if (leaf.getDataset().getGeospatialCoverage() != null) {
                    OpendapAccessPanel.this.useRegionFilter.setEnabled(true);
                }
                OpendapAccessPanel.this.filterLeaf(leaf);
            }

            @Override
            public void catalogElementsInsertionFinished() {
            }
        });
        this.openInVisat = new JCheckBox("Open in VISAT");
        this.statusBar = new StatusBar();
        LabelStatusBarItem message = new LabelStatusBarItem("label");
        message.setText("Ready.");
        message.setAlignment(2);
        this.statusBar.add((Component)message, (Object)"flexible");
        this.preMessageLabel = new JLabel();
        this.postMessageLabel = new JLabel();
        LabelStatusBarItem preMessage = new LabelStatusBarItem(){

            protected JLabel createLabel() {
                return OpendapAccessPanel.this.preMessageLabel;
            }
        };
        LabelStatusBarItem postMessage = new LabelStatusBarItem(){

            protected JLabel createLabel() {
                return OpendapAccessPanel.this.postMessageLabel;
            }
        };
        this.statusBar.add((Component)preMessage, (Object)"fix");
        ProgressStatusBarItem progressBarItem = new ProgressStatusBarItem();
        progressBarItem.setProgress(0);
        this.progressBar = progressBarItem.getProgressBar();
        this.statusBar.add((Component)progressBarItem, (Object)"fix");
        this.statusBar.add((Component)postMessage, (Object)"fix");
        this.useRegionFilter.setEnabled(false);
    }

    private void setMetadataText(int componentIndex, OpendapLeaf leaf) {
        String text = null;
        try {
            if (leaf.isDapAccess()) {
                if (this.metaInfoArea.getSelectedIndex() == 0) {
                    text = OpendapUtils.getResponse(leaf.getDdsUri());
                } else if (this.metaInfoArea.getSelectedIndex() == 1) {
                    text = OpendapUtils.getResponse(leaf.getDasUri());
                }
            } else if (leaf.isFileAccess()) {
                if (this.metaInfoArea.getSelectedIndex() == 0) {
                    text = "No DDS information for file '" + leaf.getName() + "'.";
                } else if (this.metaInfoArea.getSelectedIndex() == 1) {
                    text = "No DAS information for file '" + leaf.getName() + "'.";
                }
            }
        }
        catch (IOException e) {
            BeamLogManager.getSystemLogger().warning("Unable to retrieve meta information for file '" + leaf.getName() + "'.");
        }
        this.setResponseText(componentIndex, text);
    }

    private void setResponseText(int componentIndex, String response) {
        JTextArea textArea = this.textAreas.get(componentIndex);
        if (response.length() > 100000) {
            StringBuilder responseBuilder = new StringBuilder(response.substring(0, 10000));
            responseBuilder.append("\nCut remaining file content");
            response = responseBuilder.toString();
        }
        textArea.setText(response);
        textArea.setCaretPosition(0);
    }

    @Override
    public void updateStatusBar(String message) {
        LabelStatusBarItem messageItem = (LabelStatusBarItem)this.statusBar.getItemByName("label");
        messageItem.setText(message);
    }

    private void filterLeaf(OpendapLeaf leaf) {
        if (!(this.useDatasetNameFilter.isSelected() && !this.datasetNameFilter.accept(leaf) || this.useTimeRangeFilter.isSelected() && !this.timeRangeFilter.accept(leaf) || this.useRegionFilter.isSelected() && !this.regionFilter.accept(leaf) || this.useVariableFilter.isSelected() && !this.variableFilter.accept(leaf))) {
            this.catalogTree.setLeafVisible(leaf, true);
        } else {
            this.catalogTree.setLeafVisible(leaf, false);
        }
    }

    private void updateUrlField() {
        String[] urls;
        String urlsProperty = this.propertyMap.getPropertyString(PROPERTY_KEY_SERVER_URLS);
        for (String url : urls = urlsProperty.split("\n")) {
            if (!StringUtils.isNotNullAndNotEmpty((String)url) || OpendapAccessPanel.contains(this.urlField, url)) continue;
            this.urlField.addItem(url);
        }
    }

    private static boolean contains(JComboBox urlField, String url) {
        for (int i = 0; i < urlField.getItemCount(); ++i) {
            if (!urlField.getItemAt(i).toString().equals(url)) continue;
            return true;
        }
        return false;
    }

    private void initContentPane() {
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.right = 5;
        JPanel urlPanel = new JPanel(layout);
        urlPanel.add((Component)new JLabel("Root URL:"), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        urlPanel.add((Component)this.urlField, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        urlPanel.add((Component)this.refreshButton, gbc);
        gbc.gridx = 3;
        gbc.insets.right = 0;
        AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/beam/opendap/images/icons/Help22.png", OpendapAccessPanel.class), (boolean)false);
        HelpSys.enableHelpOnButton((Component)helpButton, (String)this.helpId);
        urlPanel.add((Component)helpButton, gbc);
        JPanel variableInfo = new JPanel(new BorderLayout(5, 5));
        variableInfo.setBorder(new EmptyBorder(10, 0, 0, 0));
        variableInfo.add((Component)this.metaInfoArea, "Center");
        JScrollPane openDapTree = new JScrollPane(this.catalogTree.getComponent());
        JSplitPane centerLeftPane = new JSplitPane(0, openDapTree, variableInfo);
        centerLeftPane.setResizeWeight(1.0);
        centerLeftPane.setContinuousLayout(true);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        JComponent datasetNameFilterUI = this.datasetNameFilter.getUI();
        JComponent timeRangeFilterUI = this.timeRangeFilter.getUI();
        JComponent regionFilterUI = this.regionFilter.getUI();
        JComponent variableFilterUI = this.variableFilter.getUI();
        GridBagUtils.addToPanel((JPanel)filterPanel, (Component)new TitledPanel(this.useDatasetNameFilter, datasetNameFilterUI, true, true), (GridBagConstraints)gbc, (String)"gridx=0,gridy=0,anchor=NORTHWEST,weightx=1,weighty=0,,fill=BOTH");
        GridBagUtils.addToPanel((JPanel)filterPanel, (Component)new TitledPanel(this.useTimeRangeFilter, timeRangeFilterUI, true, true), (GridBagConstraints)gbc, (String)"gridy=1");
        GridBagUtils.addToPanel((JPanel)filterPanel, (Component)new TitledPanel(this.useRegionFilter, regionFilterUI, true, true), (GridBagConstraints)gbc, (String)"gridy=2");
        GridBagUtils.addToPanel((JPanel)filterPanel, (Component)new TitledPanel(this.useVariableFilter, variableFilterUI, true, true), (GridBagConstraints)gbc, (String)"gridy=3");
        GridBagUtils.addToPanel((JPanel)filterPanel, (Component)new JLabel(), (GridBagConstraints)gbc, (String)"gridy=4,weighty=1");
        filterPanel.setPreferredSize(new Dimension(460, 800));
        filterPanel.setMinimumSize(new Dimension(460, 120));
        filterPanel.setMaximumSize(new Dimension(460, 800));
        JPanel downloadButtonPanel = new JPanel(new BorderLayout(8, 5));
        downloadButtonPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.cancelButton = new JButton("Cancel");
        DownloadProgressBarPM pm = new DownloadProgressBarPM(this.progressBar, this.preMessageLabel, this.postMessageLabel, this.cancelButton);
        this.progressBar.setVisible(false);
        this.folderChooserComboBox = new FolderChooserComboBox(){

            public PopupPanel createPopupComponent() {
                PopupPanel popupComponent = super.createPopupComponent();
                JScrollPane content = (JScrollPane)popupComponent.getComponents()[0];
                JComponent upperPane = (JComponent)content.getComponents()[0];
                FolderChooser folderChooser = (FolderChooser)upperPane.getComponents()[0];
                folderChooser.setRecentListVisible(false);
                popupComponent.setTitle("Choose download directory");
                return popupComponent;
            }
        };
        this.downloadButton = new JButton("Download");
        this.downloadButton.setEnabled(false);
        final DownloadAction downloadAction = this.createDownloadAction(pm);
        this.downloadButton.addActionListener(downloadAction);
        this.folderChooserComboBox.setEditable(true);
        if (VisatApp.getApp() != null) {
            downloadButtonPanel.add((Component)this.openInVisat, "North");
        }
        downloadButtonPanel.add((Component)this.folderChooserComboBox);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.downloadButton, "West");
        this.cancelButton.setEnabled(false);
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpendapAccessPanel.this.cancelButton.setEnabled(true);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                downloadAction.cancel();
                OpendapAccessPanel.this.cancelButton.setEnabled(false);
            }
        });
        buttonPanel.add((Component)this.cancelButton, "East");
        downloadButtonPanel.add((Component)buttonPanel, "East");
        JPanel centerRightPane = new JPanel(new BorderLayout());
        SimpleScrollPane simpleScrollPane = new SimpleScrollPane((Component)filterPanel, 20, 31);
        simpleScrollPane.setBorder(BorderFactory.createEmptyBorder());
        centerRightPane.add((Component)simpleScrollPane, "Center");
        centerRightPane.add((Component)downloadButtonPanel, "South");
        JSplitPane centerPanel = new JSplitPane(1, centerLeftPane, centerRightPane);
        centerPanel.setResizeWeight(1.0);
        centerPanel.setContinuousLayout(true);
        this.setLayout(new BorderLayout(15, 15));
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.add((Component)urlPanel, "North");
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.statusBar, "South");
    }

    private DownloadAction createDownloadAction(DownloadProgressBarPM pm) {
        return new DownloadAction(pm, new ParameterProviderImpl(), new DownloadAction.DownloadHandler(){

            @Override
            public void handleException(Exception e) {
                OpendapAccessPanel.this.appContext.handleError("Unable to perform download. Reason: " + e.getMessage(), (Throwable)e);
            }

            @Override
            public void handleDownloadFinished(File downloadedFiles) {
                if (OpendapAccessPanel.this.openInVisat.isSelected()) {
                    VisatApp.getApp().openProduct(downloadedFiles);
                }
            }
        });
    }

    private File fetchTargetDirectory() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select Target Directory");
        int i = chooser.showDialog(null, "Save to directory");
        if (i == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private boolean refresh() {
        String url = this.urlField.getSelectedItem() == null ? this.urlField.getEditor().getItem().toString() : this.urlField.getSelectedItem().toString();
        url = this.checkCatalogURLString(url);
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)true);
        InvCatalogImpl catalog = factory.readXML(url);
        List datasets = catalog.getDatasets();
        if (datasets.size() == 0) {
            JOptionPane.showMessageDialog(this, "Cannnot find THREDDS catalog service xml at '" + url + "'");
            return false;
        }
        this.urlField.setSelectedItem(url);
        this.catalogTree.setNewRootDatasets(datasets);
        this.variableFilter.stopFiltering();
        return true;
    }

    private String checkCatalogURLString(String url) {
        if (url.endsWith("catalog.xml")) {
            return url;
        }
        if (url.endsWith("catalog.html")) {
            return url.substring(0, url.lastIndexOf("h")).concat("xml");
        }
        if (url.endsWith("/")) {
            return url.concat("catalog.xml");
        }
        return url.concat("/catalog.xml");
    }

    private class DefaultLeafSelectionListener
    implements CatalogTree.LeafSelectionListener {
        private DefaultLeafSelectionListener() {
        }

        @Override
        public void dapLeafSelected(OpendapLeaf leaf) {
            this.setText(leaf);
        }

        @Override
        public void fileLeafSelected(OpendapLeaf leaf) {
            this.setText(leaf);
        }

        private void setText(final OpendapLeaf leaf) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    OpendapAccessPanel.this.updateStatusBar("Retrieving metadata...");
                    OpendapAccessPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    OpendapAccessPanel.this.setMetadataText(OpendapAccessPanel.this.metaInfoArea.getSelectedIndex(), leaf);
                    return null;
                }

                @Override
                protected void done() {
                    OpendapAccessPanel.this.updateStatusBar("Ready.");
                    OpendapAccessPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }.execute();
        }

        @Override
        public void leafSelectionChanged(boolean isSelected, OpendapLeaf dapObject) {
            int dataSize = dapObject.getFileSize();
            OpendapAccessPanel.this.currentDataSize = OpendapAccessPanel.this.currentDataSize + (isSelected ? (double)dataSize : (double)(-dataSize));
            if (OpendapAccessPanel.this.currentDataSize <= 0.0) {
                OpendapAccessPanel.this.updateStatusBar("Ready.");
                OpendapAccessPanel.this.downloadButton.setEnabled(false);
            } else {
                OpendapAccessPanel.this.downloadButton.setEnabled(true);
                double dataSizeInMB = OpendapAccessPanel.this.currentDataSize / 1024.0;
                OpendapAccessPanel.this.updateStatusBar("Total size of currently selected files: " + OpendapUtils.format(dataSizeInMB) + " MB");
            }
        }
    }

    private class ParameterProviderImpl
    implements DownloadAction.ParameterProvider {
        Map<String, Boolean> dapURIs = new HashMap<String, Boolean>();
        List<String> fileURIs = new ArrayList<String>();
        private boolean mayAlwaysOverwrite = false;
        private boolean mayNeverOverwrite = false;

        private ParameterProviderImpl() {
        }

        @Override
        public Map<String, Boolean> getDapURIs() {
            if (this.dapURIs.isEmpty() && this.fileURIs.isEmpty()) {
                this.collectURIs();
            }
            return new HashMap<String, Boolean>(this.dapURIs);
        }

        @Override
        public List<String> getFileURIs() {
            if (this.dapURIs.isEmpty() && this.fileURIs.isEmpty()) {
                this.collectURIs();
            }
            return new ArrayList<String>(this.fileURIs);
        }

        private void collectURIs() {
            TreePath[] selectionPaths = ((JTree)OpendapAccessPanel.this.catalogTree.getComponent()).getSelectionModel().getSelectionPaths();
            if (selectionPaths == null || selectionPaths.length <= 0) {
                return;
            }
            for (TreePath selectionPath : selectionPaths) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                if (!CatalogTreeUtils.isDapNode(treeNode) && !CatalogTreeUtils.isFileNode(treeNode)) continue;
                OpendapLeaf leaf = (OpendapLeaf)treeNode.getUserObject();
                if (leaf.isDapAccess()) {
                    this.dapURIs.put(leaf.getDapUri(), leaf.getFileSize() >= 0x200000);
                    continue;
                }
                if (!leaf.isFileAccess()) continue;
                this.fileURIs.add(leaf.getFileUri());
            }
        }

        @Override
        public void reset() {
            this.dapURIs.clear();
            this.fileURIs.clear();
            this.mayAlwaysOverwrite = false;
            this.mayNeverOverwrite = false;
        }

        @Override
        public double getDatasizeInKb() {
            return OpendapAccessPanel.this.currentDataSize;
        }

        @Override
        public File getTargetDirectory() {
            File targetDirectory;
            AbstractComboBox.DefaultTextFieldEditorComponent textField = (AbstractComboBox.DefaultTextFieldEditorComponent)OpendapAccessPanel.this.folderChooserComboBox.getEditor();
            if (textField.getText() == null || textField.getText().equals("")) {
                targetDirectory = OpendapAccessPanel.this.fetchTargetDirectory();
                if (targetDirectory != null) {
                    textField.setText(targetDirectory.toString());
                }
            } else {
                targetDirectory = new File(textField.getText());
            }
            return targetDirectory;
        }

        @Override
        public boolean inquireOverwritePermission(String filename) {
            if (this.mayAlwaysOverwrite) {
                return true;
            }
            if (this.mayNeverOverwrite) {
                return false;
            }
            boolean mayOverwrite = false;
            Object[] options = new String[]{"Overwrite", "Always overwrite", "Skip this file", "Never overwrite"};
            int result = JOptionPane.showOptionDialog(OpendapAccessPanel.this, "Target file '" + filename + "' already exists.", "Target file already exists", -1, 3, null, options, "Yes");
            switch (result) {
                case 0: {
                    mayOverwrite = true;
                    break;
                }
                case 1: {
                    mayOverwrite = true;
                    this.mayAlwaysOverwrite = true;
                    break;
                }
                case 2: {
                    mayOverwrite = false;
                    break;
                }
                case 3: {
                    mayOverwrite = false;
                    this.mayNeverOverwrite = true;
                }
            }
            return mayOverwrite;
        }
    }

    private class DefaultFilterChangeListener
    implements FilterChangeListener {
        private DefaultFilterChangeListener() {
        }

        @Override
        public void filterChanged() {
            OpendapLeaf[] leaves;
            for (OpendapLeaf leaf : leaves = OpendapAccessPanel.this.catalogTree.getLeaves()) {
                OpendapAccessPanel.this.filterLeaf(leaf);
            }
        }
    }
}

