/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.FilterChangeListener;
import org.esa.beam.opendap.ui.FilterComponent;
import org.esa.beam.util.StringUtils;

class DatasetNameFilter
implements FilterComponent {
    final JCheckBox checkBox;
    final JTextField expressionTextField;
    final JButton applyButton;
    List<FilterChangeListener> listeners;

    public DatasetNameFilter(JCheckBox filterCheckBox) {
        this.checkBox = filterCheckBox;
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetNameFilter.this.updateUIState(false);
                if (StringUtils.isNotNullAndNotEmpty((String)DatasetNameFilter.this.expressionTextField.getText())) {
                    DatasetNameFilter.this.fireFilterChangedEvent();
                }
            }
        });
        this.expressionTextField = new JTextField();
        this.expressionTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DatasetNameFilter.this.updateUIState(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DatasetNameFilter.this.updateUIState(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DatasetNameFilter.this.updateUIState(true);
            }
        });
        this.listeners = new ArrayList<FilterChangeListener>();
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetNameFilter.this.fireFilterChangedEvent();
                DatasetNameFilter.this.updateUIState(false);
            }
        });
        this.updateUIState(false);
    }

    @Override
    public JComponent getUI() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.applyButton, "East");
        JPanel filterUI = new JPanel(new BorderLayout(4, 4));
        filterUI.add((Component)this.expressionTextField, "North");
        filterUI.add((Component)buttonPanel, "South");
        return filterUI;
    }

    @Override
    public boolean accept(OpendapLeaf leaf) {
        String text = this.expressionTextField.getText();
        if (StringUtils.isNullOrEmpty((String)text)) {
            return true;
        }
        text = text.replace("*", ".*").toLowerCase();
        Pattern pattern = Pattern.compile(text);
        Matcher matcher = pattern.matcher(leaf.getName().toLowerCase());
        return matcher.matches();
    }

    @Override
    public void addFilterChangeListener(FilterChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireFilterChangedEvent() {
        for (FilterChangeListener listener : this.listeners) {
            listener.filterChanged();
        }
    }

    private void updateUIState(boolean enableApplyButton) {
        if (!this.checkBox.isSelected()) {
            this.expressionTextField.setEnabled(false);
            this.applyButton.setEnabled(false);
            return;
        }
        this.expressionTextField.setEnabled(true);
        this.applyButton.setEnabled(enableApplyButton);
    }
}

