/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.opendap.datamodel.CatalogNode;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.TreeCellRenderer;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;

class CatalogTreeUtils {
    CatalogTreeUtils() {
    }

    public static void addCellRenderer(JTree jTree) {
        ImageIcon dapIcon = UIUtils.loadImageIcon((String)"/org/esa/beam/opendap/images/icons/DRsProduct16.png", CatalogTree.class);
        ImageIcon fileIcon = UIUtils.loadImageIcon((String)"/org/esa/beam/opendap/images/icons/FRsProduct16.png", CatalogTree.class);
        ImageIcon errorIcon = UIUtils.loadImageIcon((String)"/org/esa/beam/opendap/images/icons/NoAccess16.png", CatalogTree.class);
        jTree.setToolTipText(null);
        jTree.setCellRenderer(new TreeCellRenderer(dapIcon, fileIcon, errorIcon));
    }

    public static List<InvDataset> getCatalogDatasets(InputStream catalogIS, URI catalogBaseUri) {
        InvCatalogFactory factory = InvCatalogFactory.getDefaultFactory((boolean)true);
        InvCatalogImpl catalog = factory.readXML(catalogIS, catalogBaseUri);
        return catalog.getDatasets();
    }

    public static void addTreeSelectionListener(JTree jTree, final CatalogTree.LeafSelectionListener leafSelectionListener) {
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath[] paths;
                for (TreePath path : paths = e.getPaths()) {
                    DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = lastPathComponent.getUserObject();
                    if (!(userObject instanceof OpendapLeaf)) continue;
                    OpendapLeaf dapObject = (OpendapLeaf)userObject;
                    leafSelectionListener.leafSelectionChanged(e.isAddedPath(path), dapObject);
                }
                TreePath path = e.getPath();
                DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = lastPathComponent.getUserObject();
                if (!(userObject instanceof OpendapLeaf)) {
                    return;
                }
                OpendapLeaf opendapLeaf = (OpendapLeaf)userObject;
                if (opendapLeaf.isDapAccess()) {
                    leafSelectionListener.dapLeafSelected(opendapLeaf);
                } else if (opendapLeaf.isFileAccess()) {
                    leafSelectionListener.fileLeafSelected(opendapLeaf);
                }
            }
        });
    }

    public static boolean isDapNode(Object value) {
        if (value instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            return userObject instanceof OpendapLeaf && ((OpendapLeaf)userObject).isDapAccess();
        }
        return false;
    }

    public static boolean isFileNode(Object value) {
        if (value instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            return userObject instanceof OpendapLeaf && ((OpendapLeaf)userObject).isFileAccess();
        }
        return false;
    }

    public static boolean isCatalogReferenceNode(Object value) {
        if (value instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            return userObject instanceof CatalogNode;
        }
        return false;
    }

    public static boolean isHyraxId(String id) {
        return id != null && id.startsWith("/") && id.endsWith("/");
    }

    public static void appendCatalogNode(MutableTreeNode parentNode, DefaultTreeModel treeModel, InvCatalogRef catalogRef) {
        DefaultMutableTreeNode catalogNode = new DefaultMutableTreeNode(catalogRef.getName());
        String catalogPath = catalogRef.getURI().toASCIIString();
        CatalogNode opendapNode = new CatalogNode(catalogPath, (InvDataset)catalogRef);
        opendapNode.setCatalogUri(catalogPath);
        catalogNode.add(new DefaultMutableTreeNode(opendapNode));
        treeModel.insertNodeInto(catalogNode, parentNode, parentNode.getChildCount());
    }

    public static DefaultMutableTreeNode createRootNode() {
        return new DefaultMutableTreeNode("root", true);
    }

    public static List<InvDataset> getCatalogDatasets(DefaultMutableTreeNode node) throws IOException {
        Object userObject = node.getUserObject();
        if (!(userObject instanceof CatalogNode)) {
            return Collections.emptyList();
        }
        CatalogNode catalogNode = (CatalogNode)userObject;
        InputStream inputStream = null;
        try {
            URL catalogUrl = new URL(catalogNode.getCatalogUri());
            URLConnection urlConnection = catalogUrl.openConnection();
            inputStream = urlConnection.getInputStream();
            List<InvDataset> list = CatalogTreeUtils.getCatalogDatasets(inputStream, catalogUrl.toURI());
            return list;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

