/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.esa.beam.opendap.utils.OpendapUtils;
import org.esa.beam.util.logging.BeamLogManager;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;

class CatalogTree {
    private final JTree jTree;
    private final HashMap<OpendapLeaf, MutableTreeNode> leafToParentNode = new HashMap();
    private final Set<CatalogTreeListener> catalogTreeListeners = new HashSet<CatalogTreeListener>();
    private final AppContext appContext;
    private final UIContext uiContext;

    public CatalogTree(LeafSelectionListener leafSelectionListener, AppContext appContext, UIContext uiContext) {
        this.appContext = appContext;
        this.uiContext = uiContext;
        this.jTree = new JTree();
        this.jTree.setRootVisible(false);
        ((DefaultTreeModel)this.jTree.getModel()).setRoot(CatalogTreeUtils.createRootNode());
        CatalogTreeUtils.addCellRenderer(this.jTree);
        this.addWillExpandListener();
        CatalogTreeUtils.addTreeSelectionListener(this.jTree, leafSelectionListener);
    }

    public Component getComponent() {
        return this.jTree;
    }

    public void setNewRootDatasets(List<InvDataset> rootDatasets) {
        DefaultTreeModel model = (DefaultTreeModel)this.jTree.getModel();
        DefaultMutableTreeNode rootNode = CatalogTreeUtils.createRootNode();
        model.setRoot(rootNode);
        this.appendToNode(this.jTree, rootDatasets, rootNode, true);
        this.fireCatalogElementsInsertionFinished();
        this.expandPath(rootNode);
        this.leafToParentNode.clear();
    }

    void addWillExpandListener() {
        this.jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(final TreeExpansionEvent event) throws ExpandVetoException {
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        CatalogTree.this.uiContext.updateStatusBar("Loading subtree...");
                        CatalogTree.this.uiContext.setCursor(Cursor.getPredefinedCursor(3));
                        Object lastPathComponent = event.getPath().getLastPathComponent();
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)lastPathComponent;
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(0);
                        if (CatalogTreeUtils.isCatalogReferenceNode(child)) {
                            CatalogTree.this.resolveCatalogReferenceNode(child, true);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        CatalogTree.this.uiContext.updateStatusBar("Ready.");
                        CatalogTree.this.uiContext.setCursor(Cursor.getDefaultCursor());
                    }
                }.execute();
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
    }

    public void resolveCatalogReferenceNode(DefaultMutableTreeNode catalogReferenceNode, boolean expandPath) {
        DefaultTreeModel model = (DefaultTreeModel)this.jTree.getModel();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)catalogReferenceNode.getParent();
        model.removeNodeFromParent(catalogReferenceNode);
        try {
            List<InvDataset> catalogDatasets = CatalogTreeUtils.getCatalogDatasets(catalogReferenceNode);
            this.insertCatalogElements(catalogDatasets, parent, expandPath);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to completely resolve catalog. Reason: {0}", e.getMessage());
            BeamLogManager.getSystemLogger().warning(msg);
            this.appContext.handleError(msg, (Throwable)e);
        }
    }

    void insertCatalogElements(InputStream catalogIS, URI catalogBaseUri, DefaultMutableTreeNode parent, boolean expandPath) {
        List<InvDataset> catalogDatasets = CatalogTreeUtils.getCatalogDatasets(catalogIS, catalogBaseUri);
        this.insertCatalogElements(catalogDatasets, parent, expandPath);
    }

    void appendToNode(JTree jTree, List<InvDataset> datasets, MutableTreeNode parentNode, boolean goDeeper) {
        for (InvDataset dataset : datasets) {
            MutableTreeNode deeperParent;
            if (!goDeeper || !CatalogTreeUtils.isHyraxId(dataset.getID())) {
                this.appendToNode(jTree, dataset, parentNode);
                if (parentNode.getChildCount() == 0) continue;
                deeperParent = (MutableTreeNode)parentNode.getChildAt(parentNode.getChildCount() - 1);
            } else {
                deeperParent = parentNode;
            }
            if (!goDeeper || dataset instanceof InvCatalogRef) continue;
            this.appendToNode(jTree, dataset.getDatasets(), deeperParent, false);
        }
    }

    void appendLeafNode(MutableTreeNode parentNode, DefaultTreeModel treeModel, InvDataset dataset) {
        InvAccess fileAccess;
        OpendapLeaf leaf = new OpendapLeaf(dataset.getName(), dataset);
        int fileSize = (int)(OpendapUtils.getDataSizeInBytes(leaf) / 1024L);
        leaf.setFileSize(fileSize);
        InvAccess dapAccess = dataset.getAccess(ServiceType.OPENDAP);
        if (dapAccess != null) {
            leaf.setDapAccess(true);
            leaf.setDapUri(dapAccess.getStandardUrlName());
        }
        if ((fileAccess = dataset.getAccess(ServiceType.FILE)) != null) {
            leaf.setFileAccess(true);
            leaf.setFileUri(fileAccess.getStandardUrlName());
        } else {
            InvAccess serverAccess = dataset.getAccess(ServiceType.HTTPServer);
            if (serverAccess != null) {
                leaf.setFileAccess(true);
                leaf.setFileUri(serverAccess.getStandardUrlName());
            }
        }
        boolean hasNestedDatasets = dataset.hasNestedDatasets();
        this.appendDataNodeToParent(parentNode, treeModel, leaf);
        this.fireLeafAdded(leaf, hasNestedDatasets);
    }

    MutableTreeNode getNode(OpendapLeaf leaf) {
        MutableTreeNode node = this.getNode(this.jTree.getModel(), this.jTree.getModel().getRoot(), leaf);
        if (node == null) {
            throw new IllegalStateException("node of leaf '" + leaf.toString() + "' is null.");
        }
        return node;
    }

    OpendapLeaf[] getLeaves() {
        HashSet<OpendapLeaf> leafs = new HashSet<OpendapLeaf>();
        this.getLeaves(this.jTree.getModel().getRoot(), this.jTree.getModel(), leafs);
        leafs.addAll(this.leafToParentNode.keySet());
        return leafs.toArray(new OpendapLeaf[leafs.size()]);
    }

    void setLeafVisible(OpendapLeaf leaf, boolean visible) {
        if (visible) {
            this.setLeafVisible(leaf);
        } else {
            this.setLeafInvisible(leaf);
        }
    }

    void addCatalogTreeListener(CatalogTreeListener listener) {
        this.catalogTreeListeners.add(listener);
    }

    OpendapLeaf getSelectedLeaf() {
        if (this.jTree.isSelectionEmpty()) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.jTree.getAnchorSelectionPath().getLastPathComponent();
        return (OpendapLeaf)selectedNode.getUserObject();
    }

    private void insertCatalogElements(List<InvDataset> catalogDatasets, DefaultMutableTreeNode parent, boolean expandPath) {
        this.appendToNode(this.jTree, catalogDatasets, parent, true);
        this.fireCatalogElementsInsertionFinished();
        if (expandPath) {
            this.expandPath(parent);
        }
    }

    private void appendToNode(JTree jTree, InvDataset dataset, MutableTreeNode parentNode) {
        DefaultTreeModel treeModel = (DefaultTreeModel)jTree.getModel();
        if (dataset instanceof InvCatalogRef) {
            CatalogTreeUtils.appendCatalogNode(parentNode, treeModel, (InvCatalogRef)dataset);
        } else {
            this.appendLeafNode(parentNode, treeModel, dataset);
        }
    }

    private void appendDataNodeToParent(MutableTreeNode parentNode, DefaultTreeModel treeModel, OpendapLeaf leaf) {
        DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(leaf);
        treeModel.insertNodeInto(leafNode, parentNode, parentNode.getChildCount());
    }

    private void expandPath(DefaultMutableTreeNode node) {
        this.jTree.expandPath(new TreePath(node.getPath()));
    }

    private MutableTreeNode getNode(TreeModel model, Object node, OpendapLeaf leaf) {
        for (int i = 0; i < model.getChildCount(node); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(node, i);
            if (childNode.getUserObject() == leaf) {
                return childNode;
            }
            MutableTreeNode temp = this.getNode(model, model.getChild(node, i), leaf);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    private void fireLeafAdded(OpendapLeaf leaf, boolean hasNestedDatasets) {
        for (CatalogTreeListener catalogTreeListener : this.catalogTreeListeners) {
            catalogTreeListener.leafAdded(leaf, hasNestedDatasets);
        }
    }

    private void fireCatalogElementsInsertionFinished() {
        for (CatalogTreeListener catalogTreeListener : this.catalogTreeListeners) {
            catalogTreeListener.catalogElementsInsertionFinished();
        }
    }

    private void setLeafVisible(OpendapLeaf leaf) {
        boolean leafIsRemovedFromTree = this.leafToParentNode.containsKey(leaf);
        if (leafIsRemovedFromTree) {
            this.appendDataNodeToParent(this.leafToParentNode.get(leaf), (DefaultTreeModel)this.jTree.getModel(), leaf);
            this.leafToParentNode.remove(leaf);
        }
    }

    private void setLeafInvisible(OpendapLeaf leaf) {
        boolean leafIsRemovedFromTree = this.leafToParentNode.containsKey(leaf);
        if (!leafIsRemovedFromTree) {
            MutableTreeNode node = this.getNode(leaf);
            DefaultTreeModel model = (DefaultTreeModel)this.jTree.getModel();
            this.leafToParentNode.put(leaf, (MutableTreeNode)node.getParent());
            model.removeNodeFromParent(node);
        }
    }

    private void getLeaves(Object node, TreeModel model, Set<OpendapLeaf> result) {
        for (int i = 0; i < model.getChildCount(node); ++i) {
            if (model.isLeaf(model.getChild(node, i))) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(node, i);
                if (!CatalogTreeUtils.isDapNode(childNode) && !CatalogTreeUtils.isFileNode(childNode)) continue;
                result.add((OpendapLeaf)childNode.getUserObject());
                continue;
            }
            this.getLeaves(model.getChild(node, i), model, result);
        }
    }

    static interface UIContext {
        public void setCursor(Cursor var1);

        public void updateStatusBar(String var1);
    }

    static interface CatalogTreeListener {
        public void leafAdded(OpendapLeaf var1, boolean var2);

        public void catalogElementsInsertionFinished();
    }

    static interface LeafSelectionListener {
        public void dapLeafSelected(OpendapLeaf var1);

        public void fileLeafSelected(OpendapLeaf var1);

        public void leafSelectionChanged(boolean var1, OpendapLeaf var2);
    }
}

