/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.datamodel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.esa.beam.opendap.datamodel.DAPVariable;
import org.esa.beam.opendap.datamodel.OpendapNode;
import thredds.catalog.InvDataset;

public class OpendapLeaf
extends OpendapNode {
    private boolean dapAccess;
    private boolean fileAccess;
    private String dapUri;
    private String fileUri;
    private int fileSize;
    private Set<DAPVariable> variables = new HashSet<DAPVariable>();

    public OpendapLeaf(String name, InvDataset dataset) {
        super(name, dataset);
    }

    public boolean isDapAccess() {
        return this.dapAccess;
    }

    public boolean isFileAccess() {
        return this.fileAccess;
    }

    public String getDasUri() {
        return this.getDapUri() + ".das";
    }

    public String getDdsUri() {
        return this.getDapUri() + ".dds";
    }

    public String getDdxUri() {
        return this.getDapUri() + ".ddx";
    }

    public String getDapUri() {
        return this.dapUri;
    }

    public void setDapUri(String dapUri) {
        this.dapUri = dapUri;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public void setFileUri(String fileUri) {
        this.fileUri = fileUri;
    }

    public void setDapAccess(boolean dapAccess) {
        this.dapAccess = dapAccess;
    }

    public void setFileAccess(boolean fileAccess) {
        this.fileAccess = fileAccess;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public DAPVariable[] getDAPVariables() {
        return this.variables.toArray(new DAPVariable[this.variables.size()]);
    }

    public void addDAPVariable(DAPVariable variable) {
        this.variables.add(variable);
    }

    public void addDAPVariables(DAPVariable[] dapVariables) {
        Collections.addAll(this.variables, dapVariables);
    }
}

