/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.datamodel;

import com.bc.ceres.core.Assert;
import opendap.dap.DArrayDimension;
import org.esa.beam.util.StringUtils;

public class DAPVariable
implements Comparable<DAPVariable> {
    private final String name;
    private final String type;
    private final String dataType;
    private final DArrayDimension[] dimensions;

    public DAPVariable(String name, String type, String dataType, DArrayDimension[] dimensions) {
        Assert.argument((boolean)StringUtils.isNotNullAndNotEmpty((String)name), (String)"name");
        Assert.argument((name.trim().length() > 0 ? 1 : 0) != 0, (String)("'" + name + "' is not a valid name"));
        Assert.argument((boolean)StringUtils.isNotNullAndNotEmpty((String)type), (String)"type");
        Assert.argument((type.trim().length() > 0 ? 1 : 0) != 0, (String)("'" + type + "' is not a valid type"));
        Assert.argument((boolean)StringUtils.isNotNullAndNotEmpty((String)dataType), (String)"dataType");
        Assert.argument((dataType.trim().length() > 0 ? 1 : 0) != 0, (String)("'" + dataType + "' is not a valid dataType"));
        Assert.argument((dimensions != null ? 1 : 0) != 0, (String)"dimensions may not be null");
        this.name = name;
        this.type = type;
        this.dataType = dataType;
        this.dimensions = dimensions;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDataType() {
        return this.dataType;
    }

    public DArrayDimension[] getDimensions() {
        return this.dimensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DAPVariable that = (DAPVariable)o;
        if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) {
            return false;
        }
        boolean dimensionsAreEqual = this.dimensionsAreEqual(that);
        if (!dimensionsAreEqual) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    private boolean dimensionsAreEqual(DAPVariable that) {
        if (this.dimensions == that.dimensions) {
            return true;
        }
        if (this.dimensions == null || that.dimensions == null) {
            return false;
        }
        if (this.dimensions.length != that.dimensions.length) {
            return false;
        }
        for (int i = 0; i < this.dimensions.length; ++i) {
            DArrayDimension dimension2;
            DArrayDimension dimension1 = this.dimensions[i];
            if (dimension1 == null ^ (dimension2 = that.dimensions[i]) == null) {
                return false;
            }
            if (dimension1 == null) {
                return true;
            }
            boolean dimsEqual = dimension1.getEncodedName().equals(dimension2.getEncodedName());
            if (dimsEqual) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        result = 31 * result + (this.dimensions != null ? this.dimensions.length : 0);
        return result;
    }

    public String getInfotext() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.dataType).append(" ").append(this.name);
        for (int i = 0; i < this.dimensions.length; ++i) {
            DArrayDimension dimension = this.dimensions[i];
            if (i == 0) {
                builder.append(" (");
            }
            builder.append(dimension.getEncodedName()).append(":").append(dimension.getSize());
            if (i < this.dimensions.length - 1) {
                builder.append(", ");
                continue;
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public int getNumDimensions() {
        return this.dimensions.length;
    }

    @Override
    public int compareTo(DAPVariable o) {
        String thisDenominator = this.getDenominator(this);
        String thatDenominator = this.getDenominator(o);
        int i = thisDenominator.toLowerCase().compareTo(thatDenominator.toLowerCase());
        if (i > 0) {
            return 1;
        }
        if (i < 0) {
            return -1;
        }
        return 0;
    }

    private String getDenominator(DAPVariable var) {
        StringBuilder denominator = new StringBuilder(var.getName());
        for (DArrayDimension dimension : var.dimensions) {
            denominator.append(dimension.getEncodedName());
        }
        return denominator.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (i == 0) {
                builder.append("(");
            }
            DArrayDimension dimension = this.dimensions[i];
            builder.append(dimension.getEncodedName());
            if (i < this.dimensions.length - 1) {
                builder.append(",");
                continue;
            }
            builder.append(")");
        }
        builder.append(": ").append(this.dataType);
        return builder.toString();
    }
}

