/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.opendap.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import opendap.dap.DDS;
import org.esa.snap.opendap.datamodel.DAPVariable;
import org.esa.snap.opendap.datamodel.OpendapLeaf;
import org.esa.snap.opendap.utils.VariableExtractor;

public class VariableCollector {
    private final ArrayList<DAPVariable> variableList = new ArrayList();
    private VariableExtractor variableExtractor = new VariableExtractor();

    public DAPVariable[] collectDAPVariables(DDS dds) {
        DAPVariable[] dapVariables = this.variableExtractor.extractVariables(dds);
        this.storeDAPVariables(dapVariables);
        return dapVariables;
    }

    public DAPVariable[] collectDAPVariables(OpendapLeaf leaf) {
        DAPVariable[] dapVariables = this.variableExtractor.extractVariables(leaf);
        this.storeDAPVariables(dapVariables);
        return dapVariables;
    }

    private void storeDAPVariables(DAPVariable[] dapVariables) {
        for (int i = 0; i < dapVariables.length; ++i) {
            boolean contained = false;
            for (int j = 0; j < this.variableList.size(); ++j) {
                if (!dapVariables[i].equals(this.variableList.get(j))) continue;
                dapVariables[i] = this.variableList.get(j);
                contained = true;
                break;
            }
            if (contained) continue;
            this.variableList.add(dapVariables[i]);
        }
    }

    public Set<DAPVariable> getVariables() {
        HashSet<DAPVariable> variables = new HashSet<DAPVariable>(this.variableList);
        return variables;
    }
}

