/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.opendap.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.esa.snap.opendap.datamodel.OpendapLeaf;
import thredds.catalog.InvDatasetImpl;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;

public class OpendapUtils {
    public static long getDataSizeInBytes(OpendapLeaf leaf) {
        return (long)((InvDatasetImpl)leaf.getDataset()).getLocalMetadata().getDataSize();
    }

    public static String getResponse(String fileUri) throws IOException {
        HTTPSession session = new HTTPSession();
        HTTPMethod httpMethod = HTTPMethod.Get((HTTPSession)session, (String)fileUri);
        httpMethod.execute();
        InputStream responseStream = httpMethod.getResponseAsStream();
        return OpendapUtils.convertStreamToString(responseStream, httpMethod.getCharSet());
    }

    public static String format(double value) {
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols instance = DecimalFormatSymbols.getInstance();
        instance.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(instance);
        return format.format(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is, String charSet) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, charSet));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

