/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.opendap.ui;

import com.bc.ceres.swing.progress.ProgressBarProgressMonitor;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import com.jidesoft.swing.LabeledTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.esa.snap.framework.ui.GridBagUtils;
import org.esa.snap.framework.ui.util.FilteredListModel;
import org.esa.snap.opendap.datamodel.DAPVariable;
import org.esa.snap.opendap.datamodel.OpendapLeaf;
import org.esa.snap.opendap.ui.CatalogTree;
import org.esa.snap.opendap.ui.FilterChangeListener;
import org.esa.snap.opendap.ui.FilterComponent;
import org.esa.snap.opendap.ui.LabelledProgressBarPM;
import org.esa.snap.opendap.utils.VariableCollector;
import org.esa.snap.util.logging.BeamLogManager;

public class VariableFilter
implements FilterComponent,
CatalogTree.CatalogTreeListener {
    private static final Logger LOG = Logger.getLogger(VariableFilter.class.getName());
    private static final int MAX_THREAD_COUNT = 10;
    private final JCheckBox filterCheckBox;
    private VariableCollector collector = new VariableCollector();
    private VariableListModel listModel;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private JButton applyButton;
    private LabeledTextField filterField;
    private FilteredListModel<DAPVariable> filteredListModel;
    private CheckBoxList checkBoxList;
    private List<FilterChangeListener> listeners;
    private final HashSet<VariableFilterPreparator> filterPreparators = new HashSet();
    private final List<VariableFilterPreparator> filterPreparatorsInWait = new ArrayList<VariableFilterPreparator>();
    private LabelledProgressBarPM pm;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private JLabel percentageLabel;
    private double totalWork;
    private double worked;

    public VariableFilter(JCheckBox filterCheckBox, CatalogTree catalogTree) {
        this.filterCheckBox = filterCheckBox;
        catalogTree.addCatalogTreeListener(this);
        this.listeners = new ArrayList<FilterChangeListener>();
    }

    @Override
    public JComponent getUI() {
        JPanel panel = GridBagUtils.createPanel();
        this.initComponents();
        this.configureComponents();
        this.addComponents(panel);
        this.updateUI(false, false, false);
        return panel;
    }

    private void initComponents() {
        this.applyButton = new JButton("Apply");
        this.selectAllButton = new JButton("Select all");
        this.selectNoneButton = new JButton("Select none");
        this.listModel = new VariableListModel();
        this.filterField = new LabeledTextField();
        this.filteredListModel = new FilteredListModel((ListModel)this.listModel);
        this.checkBoxList = new ToolTippedCheckBoxList((ListModel)this.filteredListModel);
        this.progressBar = new JProgressBar();
        this.statusLabel = new JLabel("");
        this.percentageLabel = new JLabel("");
        this.pm = new VariableFilterProgressBarProgressMonitor(this.progressBar, this.statusLabel, this.percentageLabel);
    }

    private void configureComponents() {
        this.selectAllButton.addActionListener(e -> {
            int variableCount = this.checkBoxList.getModel().getSize();
            int[] selectedIndices = new int[variableCount];
            for (int i = 0; i < variableCount; ++i) {
                selectedIndices[i] = i;
            }
            this.checkBoxList.setCheckBoxListSelectedIndices(selectedIndices);
            this.updateUI(true, false, true);
        });
        this.selectNoneButton.addActionListener(e -> {
            this.checkBoxList.setCheckBoxListSelectedIndices(new int[0]);
            this.updateUI(true, true, false);
        });
        this.applyButton.addActionListener(e -> {
            this.fireFilterChanged();
            this.updateUI(false, this.selectAllButton.isEnabled(), this.selectNoneButton.isEnabled());
        });
        this.filterCheckBox.setEnabled(false);
        this.filterCheckBox.addActionListener(e -> {
            boolean useFilter = this.filterCheckBox.isSelected();
            this.fireFilterChanged();
            this.updateUI(useFilter, useFilter, useFilter);
        });
        this.checkBoxList.getCheckBoxListSelectionModel().addListSelectionListener(e -> {
            CheckBoxListSelectionModel model = (CheckBoxListSelectionModel)e.getSource();
            int anchorSelectionIndex = model.getAnchorSelectionIndex();
            if (e.getValueIsAdjusting() || anchorSelectionIndex == -1) {
                return;
            }
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                DAPVariable currentVariable;
                DAPVariable variable = this.listModel.getElementAt(i);
                if (!variable.equals(currentVariable = (DAPVariable)model.getModel().getElementAt(anchorSelectionIndex))) continue;
                boolean isSelected = model.isSelectedIndex(anchorSelectionIndex);
                this.setVariableSelected(currentVariable, isSelected);
            }
            this.updateUI(true, true, true);
        });
        Font font = this.selectAllButton.getFont().deriveFont(10.0f);
        this.selectAllButton.setFont(font);
        this.selectNoneButton.setFont(font);
        this.filterField.setHintText("Type here to filter variables");
        this.filterField.getTextField().getDocument().addDocumentListener(new FilterDocumentListener());
        this.progressBar.setVisible(false);
    }

    private void addComponents(JPanel panel) {
        GridBagConstraints gbc = new GridBagConstraints();
        JScrollPane scrollPane = new JScrollPane((Component)this.checkBoxList);
        scrollPane.setPreferredSize(new Dimension(250, 100));
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.statusLabel, (GridBagConstraints)gbc, (String)"insets.top=5, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.progressBar, (GridBagConstraints)gbc, (String)"gridx=1,fill=HORIZONTAL, weightx=1.0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.percentageLabel, (GridBagConstraints)gbc, (String)"insets.left=5, gridx=2, fill=NONE, weightx=0.0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.filterField, (GridBagConstraints)gbc, (String)"insets.left=0, gridx=0, gridy=1, gridwidth=3, fill=HORIZONTAL, weightx=1.0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)scrollPane, (GridBagConstraints)gbc, (String)"gridy=2");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.selectAllButton, (GridBagConstraints)gbc, (String)"insets.right=5, gridy=3, gridwidth=1, fill=NONE, weightx=0");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.selectNoneButton, (GridBagConstraints)gbc, (String)"gridx=1");
        GridBagUtils.addToPanel((JPanel)panel, (Component)this.applyButton, (GridBagConstraints)gbc, (String)"insets.right=0, gridx=2, gridy=4, anchor=EAST");
    }

    @Override
    public boolean accept(OpendapLeaf leaf) {
        DAPVariable[] dapVariables = leaf.getDAPVariables();
        if (this.noVariablesAreSelected()) {
            return true;
        }
        for (DAPVariable dapVariable : dapVariables) {
            boolean leafContainsVariable;
            Boolean isSelected = (Boolean)this.listModel.variableToSelected.get(dapVariable);
            boolean bl = leafContainsVariable = isSelected == null ? false : isSelected;
            if (!leafContainsVariable) continue;
            return true;
        }
        return false;
    }

    private boolean noVariablesAreSelected() {
        for (Boolean selected : this.listModel.variableToSelected.values()) {
            if (!selected.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void updateUI(boolean enableApplyButton, boolean enableSelectAllButton, boolean enableSelectNoneButton) {
        boolean notAllSelected = this.checkBoxList.getModel().getSize() == 0 || this.checkBoxList.getCheckBoxListSelectedIndices().length < this.checkBoxList.getModel().getSize();
        boolean someSelected = this.checkBoxList.getCheckBoxListSelectedIndices().length > 0;
        boolean filtersAvailable = this.checkBoxList.getModel().getSize() > 0;
        this.selectAllButton.setEnabled(this.filterCheckBox.isSelected() && enableSelectAllButton && notAllSelected);
        this.selectNoneButton.setEnabled(this.filterCheckBox.isSelected() && enableSelectNoneButton && someSelected);
        this.applyButton.setEnabled(this.filterCheckBox.isSelected() && enableApplyButton && filtersAvailable);
        this.checkBoxList.setEnabled(this.filterCheckBox.isSelected());
        this.filterField.setEnabled(this.filterCheckBox.isSelected());
    }

    @Override
    public void addFilterChangeListener(FilterChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireFilterChanged() {
        for (FilterChangeListener listener : this.listeners) {
            listener.filterChanged();
        }
    }

    public void addVariable(DAPVariable dapVariable) {
        this.listModel.allVariables.add(dapVariable);
    }

    public void setVariableSelected(DAPVariable dapVariable, boolean selected) {
        this.listModel.variableToSelected.put(dapVariable, selected);
    }

    public void stopFiltering() {
        this.filterPreparators.clear();
        this.filterPreparatorsInWait.clear();
        this.listModel.allVariables.clear();
        this.listModel.variableToSelected.clear();
    }

    @Override
    public void leafAdded(OpendapLeaf leaf, boolean hasNestedDatasets) {
        VariableFilterPreparator filterPreparator = new VariableFilterPreparator(leaf);
        if (this.filterPreparators.size() <= 10) {
            this.filterPreparators.add(filterPreparator);
            filterPreparator.execute();
            this.filterCheckBox.setEnabled(false);
            this.filterCheckBox.setSelected(false);
            this.updateUI(false, false, false);
        } else {
            this.filterPreparatorsInWait.add(filterPreparator);
        }
        this.totalWork += 1.0;
    }

    @Override
    public void catalogElementsInsertionFinished() {
        this.pm.setPreMessage("Scanning variables... ");
        this.pm.setPostMessage("");
        this.pm.beginTask("", (int)this.totalWork);
        this.pm.worked((int)this.worked);
    }

    static /* synthetic */ double access$908(VariableFilter x0) {
        double d = x0.worked;
        x0.worked = d + 1.0;
        return d;
    }

    private class FilterDocumentListener
    implements DocumentListener {
        private FilterDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateFilter(this.getFilterText(e));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateFilter(this.getFilterText(e));
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void updateFilter(String text) {
            VariableFilter.this.filteredListModel.setFilter(element -> element.getName().contains(text.trim()));
        }

        private String getFilterText(DocumentEvent e) {
            Document document = e.getDocument();
            String text = null;
            try {
                text = document.getText(0, document.getLength());
            }
            catch (BadLocationException e1) {
                LOG.severe(e1.getMessage());
            }
            return text;
        }
    }

    private class ToolTippedCheckBoxList
    extends CheckBoxList {
        public ToolTippedCheckBoxList(ListModel displayListModel) {
            super(displayListModel);
        }

        public String getToolTipText(MouseEvent event) {
            int index = this.locationToIndex(event.getPoint());
            DAPVariable item = (DAPVariable)this.getModel().getElementAt(index);
            return item.getInfotext();
        }
    }

    private static class VariableFilterProgressBarProgressMonitor
    extends ProgressBarProgressMonitor
    implements LabelledProgressBarPM {
        private final JProgressBar progressBar;
        private final JLabel preMessageLabel;
        private final JLabel postMessageLabel;

        public VariableFilterProgressBarProgressMonitor(JProgressBar progressBar, JLabel preMessageLabel, JLabel postMessageLabel) {
            super(progressBar, postMessageLabel);
            this.progressBar = progressBar;
            this.preMessageLabel = preMessageLabel;
            this.postMessageLabel = postMessageLabel;
        }

        protected void setDescription(String description) {
        }

        public void setVisibility(boolean visible) {
            this.progressBar.setVisible(visible);
            this.preMessageLabel.setVisible(visible);
            this.postMessageLabel.setVisible(visible);
        }

        protected void setRunning() {
        }

        protected void finish() {
        }

        @Override
        public void setPreMessage(String preMessageText) {
            this.preMessageLabel.setText(preMessageText);
        }

        @Override
        public void setPostMessage(String postMessageText) {
            this.setTaskName(postMessageText);
        }

        @Override
        public int getTotalWork() {
            throw new IllegalStateException("not implemented");
        }

        @Override
        public int getCurrentWork() {
            throw new IllegalStateException("not implemented");
        }

        @Override
        public void setTooltip(String tooltip) {
        }
    }

    private class VariableFilterPreparator
    extends SwingWorker<DAPVariable[], Void> {
        private OpendapLeaf leaf;

        private VariableFilterPreparator(OpendapLeaf leaf) {
            this.leaf = leaf;
        }

        @Override
        protected DAPVariable[] doInBackground() throws Exception {
            DAPVariable[] leafVariables = VariableFilter.this.collector.collectDAPVariables(this.leaf);
            this.leaf.addDAPVariables(leafVariables);
            return leafVariables;
        }

        @Override
        protected void done() {
            try {
                DAPVariable[] dapVariables = (DAPVariable[])this.get();
                VariableFilter.this.listModel.addVariables(dapVariables);
            }
            catch (Exception e) {
                BeamLogManager.getSystemLogger().warning("Stopping to scan for variables due to exception: " + e.getMessage());
            }
            finally {
                VariableFilter.this.filterPreparators.remove(this);
                VariableFilter.this.pm.worked(1);
                VariableFilter.access$908(VariableFilter.this);
                if (!VariableFilter.this.filterPreparatorsInWait.isEmpty()) {
                    VariableFilterPreparator nextFilterPreparator = (VariableFilterPreparator)VariableFilter.this.filterPreparatorsInWait.remove(0);
                    VariableFilter.this.filterPreparators.add(nextFilterPreparator);
                    nextFilterPreparator.execute();
                }
                int percentage = (int)(VariableFilter.this.worked / VariableFilter.this.totalWork * 100.0);
                VariableFilter.this.pm.setTaskName(percentage + " %");
                if (VariableFilter.this.filterPreparators.isEmpty()) {
                    VariableFilter.this.updateUI(true, true, true);
                    VariableFilter.this.filterCheckBox.setEnabled(true);
                    VariableFilter.this.pm.done();
                    VariableFilter.this.worked = 0.0;
                    VariableFilter.this.totalWork = 0.0;
                }
            }
        }
    }

    private static class VariableListModel
    implements ListModel<DAPVariable> {
        private SortedSet<DAPVariable> allVariables = new TreeSet<DAPVariable>();
        private Map<DAPVariable, Boolean> variableToSelected = new HashMap<DAPVariable, Boolean>();
        private Set<ListDataListener> listeners = new HashSet<ListDataListener>();

        private VariableListModel() {
        }

        void addVariables(DAPVariable[] dapVariables) {
            this.allVariables.addAll(Arrays.asList(dapVariables));
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(new ListDataEvent(this, 0, 0, this.getSize() - 1));
            }
        }

        @Override
        public int getSize() {
            return this.allVariables.size();
        }

        @Override
        public DAPVariable getElementAt(int index) {
            return (DAPVariable)this.allVariables.toArray()[index];
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }
    }
}

