/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.opendap.ui;

import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.esa.snap.opendap.datamodel.OpendapLeaf;
import org.esa.snap.opendap.ui.CatalogTreeUtils;
import org.esa.snap.opendap.utils.OpendapUtils;

class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private final ImageIcon dapIcon;
    private final ImageIcon fileIcon;
    private final ImageIcon errorIcon;

    public TreeCellRenderer(ImageIcon dapIcon, ImageIcon fileIcon, ImageIcon errorIcon) {
        this.dapIcon = dapIcon;
        this.fileIcon = fileIcon;
        this.errorIcon = errorIcon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (CatalogTreeUtils.isDapNode(value)) {
            this.setLeafIcon(this.dapIcon);
            this.setToolTip(node, tree);
        } else if (CatalogTreeUtils.isFileNode(value)) {
            this.setLeafIcon(this.fileIcon);
            this.setToolTip(node, tree);
        } else {
            try {
                if (leaf && this.isOpendapLeaf(node) && CatalogTreeUtils.getCatalogDatasets(node).isEmpty()) {
                    this.setLeafIcon(this.errorIcon);
                    tree.setToolTipText(null);
                } else {
                    this.setLeafIcon(this.getClosedIcon());
                }
            }
            catch (IOException e) {
                this.setLeafIcon(this.errorIcon);
                tree.setToolTipText(null);
            }
        }
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        return this;
    }

    private boolean isOpendapLeaf(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        return userObject instanceof OpendapLeaf;
    }

    private void setToolTip(DefaultMutableTreeNode value, JTree tree) {
        int fileSize = ((OpendapLeaf)value.getUserObject()).getFileSize();
        tree.setToolTipText(OpendapUtils.format((double)fileSize / 1024.0) + " MB");
    }
}

