/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.opendap.ui;

import com.bc.ceres.binding.ValidationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.opendap.datamodel.OpendapLeaf;
import org.esa.snap.opendap.ui.FilterChangeListener;
import org.esa.snap.opendap.ui.FilterComponent;
import org.esa.snap.opendap.utils.PatternProvider;
import org.esa.snap.util.StringUtils;
import org.esa.snap.util.TimeStampExtractor;
import org.jdesktop.swingx.JXDatePicker;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateRange;

public class TimeRangeFilter
implements FilterComponent {
    public static final Logger LOG = Logger.getLogger(TimeRangeFilter.class.getName());
    private JComboBox<String> datePatternComboBox;
    private JComboBox<String> fileNamePatternComboBox;
    private JXDatePicker startDateButton;
    private JXDatePicker stopDateButton;
    private JButton applyButton;
    private JCheckBox filterCheckBox;
    TimeStampExtractor timeStampExtractor;
    List<FilterChangeListener> listeners;
    List<JLabel> labels;
    Date startDate;
    Date endDate;

    public TimeRangeFilter(JCheckBox filterCheckBox) {
        this.filterCheckBox = filterCheckBox;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        Date date = utc.getTime();
        this.startDateButton = new JXDatePicker(date);
        this.startDateButton.setFormats(new DateFormat[]{dateFormat});
        this.stopDateButton = new JXDatePicker(date);
        this.stopDateButton.setFormats(new DateFormat[]{dateFormat});
        int width = 150;
        Dimension ps = this.startDateButton.getPreferredSize();
        Dimension comboBoxDimension = new Dimension(150, ps.height);
        this.setJComponentSize(comboBoxDimension, (JComponent)this.startDateButton);
        this.setJComponentSize(comboBoxDimension, (JComponent)this.stopDateButton);
        this.datePatternComboBox = new JComboBox();
        this.setJComponentSize(comboBoxDimension, this.datePatternComboBox);
        this.datePatternComboBox.setEditable(true);
        this.fileNamePatternComboBox = new JComboBox();
        this.setJComponentSize(comboBoxDimension, this.fileNamePatternComboBox);
        this.fileNamePatternComboBox.setEditable(true);
        this.initPatterns();
        UIUpdater uiUpdater = new UIUpdater();
        filterCheckBox.addActionListener(e -> {
            this.updateUIState();
            if (this.timeStampExtractor != null) {
                this.fireFilterChangedEvent();
            }
        });
        this.startDateButton.addPropertyChangeListener("datePickerCommit", evt -> this.updateUIState());
        this.startDateButton.addPropertyChangeListener("datePickerCommit", evt -> this.validateDateChooser(this.startDateButton));
        this.stopDateButton.addPropertyChangeListener("datePickerCommit", evt -> this.updateUIState());
        this.stopDateButton.addPropertyChangeListener("datePickerCommit", evt -> this.validateDateChooser(this.stopDateButton));
        this.datePatternComboBox.addActionListener(uiUpdater);
        this.fileNamePatternComboBox.addActionListener(uiUpdater);
        this.listeners = new ArrayList<FilterChangeListener>();
        this.labels = new ArrayList<JLabel>();
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(e -> {
            this.timeStampExtractor = StringUtils.isNotNullAndNotEmpty((String)this.datePatternComboBox.getEditor().getItem().toString()) && StringUtils.isNotNullAndNotEmpty((String)this.fileNamePatternComboBox.getEditor().getItem().toString()) ? new TimeStampExtractor(this.datePatternComboBox.getSelectedItem().toString(), this.fileNamePatternComboBox.getSelectedItem().toString()) : null;
            this.startDate = this.startDateButton.getDate();
            this.endDate = this.stopDateButton.getDate();
            this.updateUIState();
            this.applyButton.setEnabled(false);
            this.fireFilterChangedEvent();
        });
    }

    private void updateUIState() {
        boolean patternProvided;
        boolean isSelected = this.filterCheckBox.isSelected();
        this.datePatternComboBox.setEnabled(isSelected);
        this.fileNamePatternComboBox.setEnabled(isSelected);
        this.startDateButton.setEnabled(isSelected);
        this.stopDateButton.setEnabled(isSelected);
        for (JLabel label : this.labels) {
            label.setEnabled(isSelected);
        }
        String datePattern = this.datePatternComboBox.getSelectedItem().toString();
        String fileNamePattern = this.fileNamePatternComboBox.getSelectedItem().toString();
        boolean hasStartDate = this.startDateButton.getDate() != null;
        boolean hasEndDate = this.stopDateButton.getDate() != null;
        boolean bl = patternProvided = !"".equals(datePattern) && !"".equals(fileNamePattern);
        if (isSelected && (patternProvided || !hasStartDate && !hasEndDate)) {
            this.applyButton.setEnabled(true);
        } else {
            this.applyButton.setEnabled(false);
        }
    }

    private void initPatterns() {
        this.datePatternComboBox.addItem("");
        this.fileNamePatternComboBox.addItem("");
        for (String datePattern : PatternProvider.DATE_PATTERNS) {
            this.datePatternComboBox.addItem(datePattern);
        }
        for (String fileNamePattern : PatternProvider.FILENAME_PATTERNS) {
            this.fileNamePatternComboBox.addItem(fileNamePattern);
        }
    }

    private void setJComponentSize(Dimension comboBoxDimension, JComponent comboBox) {
        comboBox.setPreferredSize(comboBoxDimension);
        comboBox.setMinimumSize(comboBoxDimension);
    }

    @Override
    public JComponent getUI() {
        JPanel filterUI = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets.bottom = 4;
        gbc.insets.right = 4;
        gbc.anchor = 17;
        JLabel datePatternLabel = new JLabel("Date pattern:");
        filterUI.add((Component)datePatternLabel, gbc);
        ++gbc.gridx;
        filterUI.add(this.datePatternComboBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel filenamePatternLabel = new JLabel("Filename pattern:");
        filterUI.add((Component)filenamePatternLabel, gbc);
        ++gbc.gridx;
        filterUI.add(this.fileNamePatternComboBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel startDateLabel = new JLabel("Start date:");
        filterUI.add((Component)startDateLabel, gbc);
        ++gbc.gridx;
        filterUI.add((Component)this.startDateButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel stopDateLabel = new JLabel("Stop date:");
        filterUI.add((Component)stopDateLabel, gbc);
        ++gbc.gridx;
        filterUI.add((Component)this.stopDateButton, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        filterUI.add((Component)this.applyButton, gbc);
        this.labels.add(datePatternLabel);
        this.labels.add(filenamePatternLabel);
        this.labels.add(startDateLabel);
        this.labels.add(stopDateLabel);
        this.updateUIState();
        return filterUI;
    }

    @Override
    public boolean accept(OpendapLeaf leaf) {
        DateRange timeCoverage = leaf.getDataset().getTimeCoverage();
        if (timeCoverage != null) {
            return this.fitsToServerSpecifiedTimeRange(timeCoverage);
        }
        return this.timeStampExtractor == null || this.fitsToUserSpecifiedTimeRange(leaf);
    }

    private boolean fitsToServerSpecifiedTimeRange(DateRange dateRange) {
        if (this.startDate == null && this.endDate == null) {
            return true;
        }
        if (this.startDate == null) {
            return this.endsAtOrBeforeEndDate(dateRange);
        }
        if (this.endDate == null) {
            return this.startsAtOrAfterStartDate(dateRange);
        }
        return this.startsAtOrAfterStartDate(dateRange) && this.endsAtOrBeforeEndDate(dateRange);
    }

    private boolean endsAtOrBeforeEndDate(DateRange dateRange) {
        return dateRange.getEnd().getCalendarDate().equals((Object)CalendarDate.of((Date)this.endDate)) || dateRange.getEnd().before(this.endDate);
    }

    private boolean startsAtOrAfterStartDate(DateRange dateRange) {
        return dateRange.getStart().getCalendarDate().equals((Object)CalendarDate.of((Date)this.startDate)) || dateRange.getStart().after(this.startDate);
    }

    private boolean fitsToUserSpecifiedTimeRange(OpendapLeaf leaf) {
        try {
            boolean userHasEndDate;
            boolean startDateEqualsEndDate;
            ProductData.UTC[] timeStamps = this.timeStampExtractor.extractTimeStamps(leaf.getName());
            boolean bl = startDateEqualsEndDate = timeStamps[0].getAsDate().getTime() == timeStamps[1].getAsDate().getTime();
            if (startDateEqualsEndDate) {
                timeStamps[1] = null;
            }
            boolean fileHasEndDate = timeStamps[1] != null;
            boolean userHasStartDate = this.startDate != null;
            boolean bl2 = userHasEndDate = this.endDate != null;
            if (userHasStartDate && this.startDate.after(timeStamps[0].getAsDate())) {
                return false;
            }
            return !userHasEndDate || !(fileHasEndDate ? this.endDate.before(timeStamps[1].getAsDate()) : this.endDate.before(timeStamps[0].getAsDate()));
        }
        catch (ValidationException e) {
            return true;
        }
    }

    @Override
    public void addFilterChangeListener(FilterChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireFilterChangedEvent() {
        for (FilterChangeListener listener : this.listeners) {
            listener.filterChanged();
        }
    }

    private void validateDateChooser(JXDatePicker button) {
        Date startDate = this.startDateButton.getDate();
        Date endDate = this.stopDateButton.getDate();
        if (startDate == null || endDate == null) {
            return;
        }
        if (startDate.after(endDate)) {
            if (button.equals(this.startDateButton)) {
                this.startDateButton.setDate(endDate);
                LOG.info("Start date after end date: Set start date to end date.");
            } else if (button.equals(this.stopDateButton)) {
                this.stopDateButton.setDate(startDate);
                LOG.info("Start date after end date: Set end date to start date.");
            }
        }
    }

    private class UIUpdater
    implements ActionListener {
        private UIUpdater() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TimeRangeFilter.this.updateUIState();
        }
    }
}

