/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.opendap.ui;

import com.bc.ceres.swing.progress.ProgressBarProgressMonitor;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.esa.snap.opendap.ui.LabelledProgressBarPM;

public class DownloadProgressBarPM
extends ProgressBarProgressMonitor
implements LabelledProgressBarPM {
    private final JProgressBar progressBar;
    private JLabel postMessageLabel;
    private int totalWork;
    private int currentWork;
    private long startTime;
    private JButton cancelButton;

    public DownloadProgressBarPM(JProgressBar progressBar, JLabel preMessageLabel, JLabel postMessageLabel, JButton cancelButton) {
        super(progressBar, preMessageLabel);
        this.progressBar = progressBar;
        this.postMessageLabel = postMessageLabel;
        this.cancelButton = cancelButton;
    }

    @Override
    public void setPreMessage(String preMessageText) {
        this.setTaskName(preMessageText);
    }

    @Override
    public void setPostMessage(String postMessageText) {
        this.postMessageLabel.setText(postMessageText);
    }

    @Override
    public void setTooltip(String tooltip) {
        this.progressBar.setToolTipText(tooltip);
    }

    public void beginTask(String name, int totalWork) {
        super.beginTask(name, totalWork);
        this.totalWork = totalWork;
        this.currentWork = 0;
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(true);
    }

    public void worked(int work) {
        super.worked(work);
        this.currentWork += work;
    }

    protected void setDescription(String description) {
    }

    protected void setVisibility(boolean visible) {
        this.progressBar.setVisible(true);
    }

    protected void setRunning() {
    }

    protected void finish() {
        this.progressBar.setIndeterminate(false);
        this.cancelButton.setEnabled(false);
    }

    @Override
    public int getTotalWork() {
        return this.totalWork;
    }

    @Override
    public int getCurrentWork() {
        return this.currentWork;
    }

    public void updateTask(int additionalWork) {
        this.totalWork += additionalWork;
        this.progressBar.setMaximum(this.totalWork);
        this.progressBar.updateUI();
    }

    public void resetStartTime() {
        GregorianCalendar gc = new GregorianCalendar();
        this.startTime = gc.getTimeInMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }
}

