/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.opendap.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingWorker;
import org.esa.snap.opendap.ui.DownloadProgressBarPM;
import org.esa.snap.opendap.utils.DAPDownloader;

class DownloadAction
implements ActionListener,
DAPDownloader.DownloadContext {
    private final Set<DownloadWorker> activeDownloaders = new HashSet<DownloadWorker>();
    private final DownloadProgressBarPM pm;
    private final ParameterProvider parameterProvider;
    private final DownloadHandler downloadHandler;
    private int downloadedFilesCount;
    private int filesToDownloadCount;

    public DownloadAction(DownloadProgressBarPM pm, ParameterProvider parameterProvider, DownloadHandler downloadHandler) {
        this.pm = pm;
        this.parameterProvider = parameterProvider;
        this.downloadHandler = downloadHandler;
    }

    @Override
    public void actionPerformed(ActionEvent ignored) {
        Map<String, Boolean> dapURIs = this.parameterProvider.getDapURIs();
        List<String> fileURIs = this.parameterProvider.getFileURIs();
        this.parameterProvider.reset();
        if (dapURIs.size() == 0 && fileURIs.size() == 0) {
            return;
        }
        File targetDirectory = this.parameterProvider.getTargetDirectory();
        DAPDownloader downloader = new DAPDownloader(dapURIs, fileURIs, this, this.pm);
        if (this.activeDownloaders.isEmpty()) {
            this.pm.beginTask("", (int)this.parameterProvider.getDatasizeInKb());
            this.pm.worked(0);
            this.pm.resetStartTime();
            this.filesToDownloadCount = dapURIs.size() + fileURIs.size();
        } else {
            this.pm.updateTask((int)this.parameterProvider.getDatasizeInKb());
            this.filesToDownloadCount += dapURIs.size() + fileURIs.size();
        }
        DownloadWorker downloadWorker = new DownloadWorker(downloader, targetDirectory);
        downloadWorker.execute();
        this.activeDownloaders.add(downloadWorker);
    }

    @Override
    public int getAllFilesCount() {
        return this.filesToDownloadCount;
    }

    @Override
    public int getAllDownloadedFilesCount() {
        return this.downloadedFilesCount;
    }

    @Override
    public void notifyFileDownloaded(File downloadedFile) {
        ++this.downloadedFilesCount;
        this.downloadHandler.handleDownloadFinished(downloadedFile);
    }

    @Override
    public boolean mayOverwrite(String filename) {
        return this.parameterProvider.inquireOverwritePermission(filename);
    }

    public void cancel() {
        for (DownloadWorker activeDownloader : new HashSet<DownloadWorker>(this.activeDownloaders)) {
            activeDownloader.cancel(true);
        }
        this.activeDownloaders.clear();
        this.pm.setCanceled(true);
        this.pm.setPreMessage("Download cancelled");
        this.pm.setPostMessage("");
        this.downloadedFilesCount = 0;
    }

    static interface DownloadHandler {
        public void handleException(Exception var1);

        public void handleDownloadFinished(File var1);
    }

    static interface ParameterProvider {
        public void reset();

        public Map<String, Boolean> getDapURIs();

        public List<String> getFileURIs();

        public double getDatasizeInKb();

        public File getTargetDirectory();

        public boolean inquireOverwritePermission(String var1);
    }

    private class DownloadWorker
    extends SwingWorker<Void, Void> {
        private final DAPDownloader downloader;
        private final File targetDirectory;

        public DownloadWorker(DAPDownloader downloader, File targetDirectory) {
            this.downloader = downloader;
            this.targetDirectory = targetDirectory;
        }

        @Override
        protected Void doInBackground() {
            try {
                this.downloader.saveProducts(this.targetDirectory);
            }
            catch (Exception e) {
                DownloadAction.this.downloadHandler.handleException(e);
            }
            return null;
        }

        @Override
        protected void done() {
            DownloadAction.this.activeDownloaders.remove(this);
            if (DownloadAction.this.activeDownloaders.isEmpty()) {
                DownloadAction.this.pm.done();
                DownloadAction.this.pm.setPreMessage("All downloads completed");
                DownloadAction.this.pm.setPostMessage("");
                DownloadAction.this.downloadedFilesCount = 0;
            }
        }
    }
}

