/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.AbstractNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.GenericNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import ucar.nc2.NetcdfFile;

public class GenericNetCdfReader
extends AbstractProductReader {
    private NetcdfFile netcdfFile;
    private ProductReader netCdfReader;

    public GenericNetCdfReader(GenericNetCdfReaderPlugIn readerPlugIn) {
        super((ProductReaderPlugIn)readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        File fileLocation = new File(this.getInput().toString());
        this.netcdfFile = NetcdfFileOpener.open(fileLocation.getPath());
        if (this.netcdfFile == null) {
            throw new IOException("Failed to open file " + fileLocation.getPath());
        }
        AbstractNetCdfReaderPlugIn[] plugIns = GenericNetCdfReaderPlugIn.getAllNetCdfReaderPlugIns();
        AbstractNetCdfReaderPlugIn bestPlugIn = null;
        for (AbstractNetCdfReaderPlugIn plugIn : plugIns) {
            DecodeQualification decodeQualification = plugIn.getDecodeQualification(this.netcdfFile);
            if (DecodeQualification.INTENDED.equals((Object)decodeQualification)) {
                bestPlugIn = plugIn;
                break;
            }
            if (!DecodeQualification.SUITABLE.equals((Object)decodeQualification) || bestPlugIn != null) continue;
            bestPlugIn = plugIn;
        }
        if (bestPlugIn == null) {
            String msg = String.format("Not able to read %s. No suitable NetCDF reader found.", this.getInput());
            throw new IOException(msg);
        }
        this.netCdfReader = bestPlugIn.createReaderInstance();
        return this.netCdfReader.readProductNodes(this.getInput(), this.getSubsetDef());
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("Data is provided by different reader");
    }

    public void close() throws IOException {
        if (this.netcdfFile != null) {
            this.netcdfFile.close();
            this.netcdfFile = null;
        }
        if (this.netCdfReader != null) {
            this.netCdfReader.close();
            this.netCdfReader = null;
        }
        super.close();
    }
}

