/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.stream.IntStream;
import org.esa.snap.dataio.netcdf.nc.N3FileWriteable;
import org.esa.snap.dataio.netcdf.nc.N4FileWriteable;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import ucar.ma2.DataType;

public class MaxStringAttributeLengthTest {
    private static final int TOO_LONG = 64545;
    private NFileWriteable nc4Writable;
    private NFileWriteable nc3Writable;
    private Path nc4TempFile;
    private Path nc3TempFile;

    @Before
    public void setUp() throws Exception {
        this.nc4TempFile = Files.createTempFile(this.getClass().getSimpleName(), "nc4", new FileAttribute[0]);
        this.nc4Writable = N4FileWriteable.create((String)this.nc4TempFile.toString());
        this.nc3TempFile = Files.createTempFile(this.getClass().getSimpleName(), "nc3", new FileAttribute[0]);
        this.nc3Writable = N3FileWriteable.create((String)this.nc3TempFile.toString());
    }

    @After
    public void tearDown() throws Exception {
        this.nc4Writable.create();
        this.nc4Writable.close();
        this.nc3Writable.create();
        this.nc3Writable.close();
        Files.delete(this.nc4TempFile);
        Files.delete(this.nc3TempFile);
    }

    @Test
    public void testMaxStringGlobalAttributeLengthNC4() throws IOException {
        this.nc4Writable.addGlobalAttribute("longGlobalAttributeValue", this.createLongString(64545));
    }

    @Test
    public void testMaxStringGlobalAttributeLengthNC3() throws IOException {
        this.nc3Writable.addGlobalAttribute("longGlobalAttributeValue", this.createLongString(64545));
    }

    @Test
    public void testMaxStringVariableAttributeLengthNC4() throws IOException {
        NVariable variable = this.nc4Writable.addScalarVariable("metadataVariable", DataType.BYTE);
        variable.addAttribute("longVariableAttributeValue", this.createLongString(64545));
    }

    @Test
    public void testMaxStringVariableAttributeLengthNC3() throws IOException {
        NFileWriteable ncFile = N3FileWriteable.create((String)Files.createTempFile(this.getClass().getSimpleName(), null, new FileAttribute[0]).toString());
        NVariable variable = ncFile.addScalarVariable("metadataVariable", DataType.BYTE);
        variable.addAttribute("longVariableAttributeValue", this.createLongString(64545));
    }

    private String createLongString(int length) {
        StringBuilder sb = new StringBuilder();
        IntStream randomStream = new Random(123456L).ints(length);
        randomStream.forEach(value -> sb.append((char)(value & 0xFF)));
        return sb.toString();
    }
}

