/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.net.URI;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfTimePart;
import org.esa.snap.dataio.netcdf.util.RasterDigest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import ucar.nc2.NetcdfFile;

public class CfTimePartTest {
    private Product product;
    private CfTimePart cfTimePart;
    private TestProfileReadContext ctx;

    @Before
    public void setUp() throws Exception {
        this.product = new Product("name", "type", 10, 10);
        this.cfTimePart = new CfTimePart();
    }

    @Test
    public void testDecode_testfile_1() throws Exception {
        this.ctx = new TestProfileReadContext("../../../test.nc");
        Assert.assertNull((Object)this.product.getStartTime());
        Assert.assertNull((Object)this.product.getEndTime());
        this.cfTimePart.decode((ProfileReadContext)this.ctx, this.product);
        long expectedStartTime = ProductData.UTC.parse((String)"2002-12-24 11:12:13", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime();
        long expectedEndTime = ProductData.UTC.parse((String)"2002-12-24 11:12:14", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime();
        Assert.assertEquals((long)expectedStartTime, (long)this.product.getStartTime().getAsDate().getTime());
        Assert.assertEquals((long)expectedEndTime, (long)this.product.getEndTime().getAsDate().getTime());
    }

    @Test
    public void testDecode_testfile_2() throws Exception {
        this.ctx = new TestProfileReadContext("../../../test_2.nc");
        Assert.assertNull((Object)this.product.getStartTime());
        Assert.assertNull((Object)this.product.getEndTime());
        this.cfTimePart.decode((ProfileReadContext)this.ctx, this.product);
        long expectedStartTime = ProductData.UTC.parse((String)"2002-12-31 11:12:13", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime();
        long expectedEndTime = ProductData.UTC.parse((String)"2002-12-31 22:12:14", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime();
        Assert.assertEquals((long)expectedStartTime, (long)this.product.getStartTime().getAsDate().getTime());
        Assert.assertEquals((long)expectedEndTime, (long)this.product.getEndTime().getAsDate().getTime());
    }

    @After
    public void tearDown() throws Exception {
        if (this.ctx != null) {
            this.ctx.netcdfFile.close();
        }
    }

    private static class TestProfileReadContext
    implements ProfileReadContext {
        private NetcdfFile netcdfFile;
        private String file;

        private TestProfileReadContext(String file) {
            this.file = file;
        }

        public NetcdfFile getNetcdfFile() {
            try {
                this.netcdfFile = NetcdfFile.openInMemory((URI)this.getClass().getResource(this.file).toURI());
                return this.netcdfFile;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setRasterDigest(RasterDigest rasterDigest) {
        }

        public RasterDigest getRasterDigest() {
            return null;
        }

        public void setProperty(String name, Object value) {
        }

        public Object getProperty(String name) {
            return null;
        }
    }
}

