/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import org.esa.snap.dataio.netcdf.util.Constants;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.junit.Assert;
import org.junit.Test;

public class HasValidExtensionTest {
    @Test
    public void testNumberOfExtensions() {
        Assert.assertEquals((long)5L, (long)Constants.FILE_EXTENSIONS.length);
    }

    @Test
    public void testInvalidExtension() {
        Assert.assertFalse((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.invalid"));
    }

    @Test
    public void testValid_Netcdf_Extensions() {
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.nc"));
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.nC"));
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.Nc"));
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.Nc.gz"));
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.Nc"));
    }

    @Test
    public void testValid_HDF_Extensions() {
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.hdf"));
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.HDF"));
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.HDF.gz"));
        Assert.assertTrue((boolean)ReaderUtils.hasValidExtension((String)"AnyPathname.hdf.bz2"));
    }
}

