/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap;

import java.util.Iterator;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.dataio.netcdf.GenericNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfNetCdfReaderPlugIn;
import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosNetCdfReaderPlugIn;
import org.junit.Assert;
import org.junit.Test;

public class ReaderLoadedAsServiceTest {
    @Test
    public void testNetCdfReaderPlugInsAreLoaded() {
        this.testReaderPlugInLoading("NetCDF", GenericNetCdfReaderPlugIn.class);
        this.testReaderPlugInLoading("NetCDF-CF", CfNetCdfReaderPlugIn.class);
        this.testReaderPlugInLoading("NetCDF-BEAM", BeamNetCdfReaderPlugIn.class);
        this.testReaderPlugInLoading("HDF-EOS", HdfEosNetCdfReaderPlugIn.class);
    }

    private void testReaderPlugInLoading(String formatName, Class<? extends ProductReaderPlugIn> readerPlugInClass) {
        ProductIOPlugInManager plugInManager = ProductIOPlugInManager.getInstance();
        Iterator readerPlugIns = plugInManager.getReaderPlugIns(formatName);
        if (readerPlugIns.hasNext()) {
            ProductReaderPlugIn plugIn = (ProductReaderPlugIn)readerPlugIns.next();
            Assert.assertEquals(readerPlugInClass, plugIn.getClass());
        } else {
            Assert.fail((String)String.format("Where is %s?", readerPlugInClass.getSimpleName()));
        }
    }
}

