/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.NetcdfMultiLevelImage;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BeamBandPart
extends ProfilePartIO {
    public static final String BANDWIDTH = "bandwidth";
    public static final String WAVELENGTH = "wavelength";
    public static final String VALID_PIXEL_EXPRESSION = "valid_pixel_expression";
    public static final String AUTO_GROUPING = "auto_grouping";
    public static final String QUICKLOOK_BAND_NAME = "quicklook_band_name";
    public static final String SOLAR_FLUX = "solar_flux";
    public static final String SPECTRAL_BAND_INDEX = "spectral_band_index";
    public static final String GEOCODING = "geocoding";
    private static final int LON_INDEX = 0;
    private static final int LAT_INDEX = 1;

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        String quicklookBandName;
        Attribute quicklookBandNameAttribute;
        String autoGrouping;
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        List variables = netcdfFile.getVariables();
        for (Variable variable : variables) {
            Band band;
            List dimensions = variable.getDimensions();
            if (dimensions.size() != 2) continue;
            boolean yDimIndex = false;
            boolean xDimIndex = true;
            int rasterDataType = DataTypeUtils.getRasterDataType(variable);
            int width = ((ucar.nc2.Dimension)dimensions.get(1)).getLength();
            int height = ((ucar.nc2.Dimension)dimensions.get(0)).getLength();
            if (height == p.getSceneRasterHeight() && width == p.getSceneRasterWidth()) {
                band = p.addBand(variable.getFullName(), rasterDataType);
            } else {
                if (((ucar.nc2.Dimension)dimensions.get(1)).getFullName().startsWith("tp_") || ((ucar.nc2.Dimension)dimensions.get(0)).getFullName().startsWith("tp_")) continue;
                band = new Band(variable.getFullName(), rasterDataType, width, height);
                this.setGeoCoding(ctx, p, variable, band);
                p.addBand(band);
            }
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)band);
            BeamBandPart.readBeamBandAttributes(variable, band);
            band.setSourceImage((MultiLevelImage)new NetcdfMultiLevelImage((RasterDataNode)band, variable, ctx));
        }
        this.maybeApplySpectralIndexAndSolarFluxFromMetadata(p);
        Attribute autoGroupingAttribute = netcdfFile.findGlobalAttribute(AUTO_GROUPING);
        if (autoGroupingAttribute != null && (autoGrouping = autoGroupingAttribute.getStringValue()) != null) {
            p.setAutoGrouping(autoGrouping);
        }
        if ((quicklookBandNameAttribute = netcdfFile.findGlobalAttribute(QUICKLOOK_BAND_NAME)) != null && (quicklookBandName = quicklookBandNameAttribute.getStringValue()) != null) {
            p.setQuicklookBandName(quicklookBandName);
        }
    }

    private void setGeoCoding(ProfileReadContext ctx, Product p, Variable variable, Band band) throws IOException {
        Attribute geoCodingAttribute = variable.findAttribute(GEOCODING);
        NetcdfFile netcdfFile = ctx.getNetcdfFile();
        if (geoCodingAttribute != null) {
            String expectedCRSName;
            String geoCodingValue = geoCodingAttribute.getStringValue();
            if (geoCodingValue.equals(expectedCRSName = "crs_" + variable.getFullName())) {
                Variable crsVariable = netcdfFile.getRootGroup().findVariable(expectedCRSName);
                if (crsVariable != null) {
                    Attribute wktAtt = crsVariable.findAttribute("wkt");
                    Attribute i2mAtt = crsVariable.findAttribute("i2m");
                    if (wktAtt != null && i2mAtt != null) {
                        band.setGeoCoding(this.createGeoCodingFromWKT(p, wktAtt.getStringValue(), i2mAtt.getStringValue()));
                    }
                }
            } else {
                String[] tpGridNames = geoCodingValue.split(" ");
                if (tpGridNames.length == 2 && p.containsTiePointGrid(tpGridNames[0]) && p.containsTiePointGrid(tpGridNames[1])) {
                    TiePointGrid lon = p.getTiePointGrid(tpGridNames[0]);
                    TiePointGrid lat = p.getTiePointGrid(tpGridNames[1]);
                    band.setGeoCoding((GeoCoding)new TiePointGeoCoding(lat, lon));
                }
            }
        }
    }

    private GeoCoding createGeoCodingFromWKT(Product p, String wktString, String i2mString) {
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)wktString);
            String[] parameters = StringUtils.csvToArray((String)i2mString);
            double[] matrix = new double[parameters.length];
            for (int i = 0; i < matrix.length; ++i) {
                matrix[i] = Double.valueOf(parameters[i]);
            }
            AffineTransform i2m = new AffineTransform(matrix);
            Rectangle imageBounds = new Rectangle(p.getSceneRasterWidth(), p.getSceneRasterHeight());
            return new CrsGeoCoding(crs, imageBounds, i2m);
        }
        catch (FactoryException factoryException) {
        }
        catch (TransformException transformException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        String quicklookBandName;
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        String productDimensions = ncFile.getDimensions();
        HashMap<String, String> dimMap = new HashMap<String, String>();
        for (Band band : p.getBands()) {
            NVariable variable;
            int dataType;
            if (this.isPixelGeoCodingBand(band)) continue;
            if (band.isLog10Scaled()) {
                dataType = band.getGeophysicalDataType();
                ctx.setProperty("convertLogScaledBands", true);
            } else {
                dataType = band.getDataType();
            }
            DataType ncDataType = DataTypeUtils.getNetcdfDataType(dataType);
            String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
            if (!ncFile.isNameValid(variableName)) {
                variableName = ncFile.makeNameValid(variableName);
            }
            int bandSceneRasterWidth = band.getRasterWidth();
            int bandSceneRasterHeight = band.getRasterHeight();
            if (bandSceneRasterWidth != p.getSceneRasterWidth() || bandSceneRasterHeight != p.getSceneRasterHeight()) {
                String key = "" + bandSceneRasterWidth + " " + bandSceneRasterHeight;
                String dimString = (String)dimMap.get(key);
                if (dimString == null) {
                    int size = dimMap.size();
                    String suffix = "" + (size + 1);
                    ncFile.addDimension("y" + suffix, bandSceneRasterHeight);
                    ncFile.addDimension("x" + suffix, bandSceneRasterWidth);
                    dimString = "y" + suffix + " " + "x" + suffix;
                    dimMap.put(key, dimString);
                }
                Dimension tileSize = JAIUtils.computePreferredTileSize((int)bandSceneRasterWidth, (int)bandSceneRasterHeight, (int)1);
                variable = ncFile.addVariable(variableName, ncDataType, tileSize, dimString);
                this.encodeGeoCoding(ncFile, band, p, variable);
            } else {
                Dimension tileSize = ImageManager.getPreferredTileSize((Product)p);
                variable = ncFile.addVariable(variableName, ncDataType, tileSize, productDimensions);
            }
            CfBandPart.writeCfBandAttributes((RasterDataNode)band, variable);
            BeamBandPart.writeBeamBandAttributes(band, variable);
        }
        Product.AutoGrouping autoGrouping = p.getAutoGrouping();
        if (autoGrouping != null) {
            ncFile.addGlobalAttribute(AUTO_GROUPING, autoGrouping.toString());
        }
        if ((quicklookBandName = p.getQuicklookBandName()) != null && !quicklookBandName.isEmpty()) {
            ncFile.addGlobalAttribute(QUICKLOOK_BAND_NAME, quicklookBandName);
        }
    }

    private void encodeGeoCoding(NFileWriteable ncFile, Band band, Product product, NVariable variable) throws IOException {
        GeoCoding geoCoding = band.getGeoCoding();
        if (!geoCoding.equals(product.getSceneGeoCoding())) {
            if (geoCoding instanceof TiePointGeoCoding) {
                TiePointGeoCoding tpGC = (TiePointGeoCoding)geoCoding;
                String[] names = new String[]{tpGC.getLonGrid().getName(), tpGC.getLatGrid().getName()};
                String value = StringUtils.arrayToString((Object)names, (String)" ");
                variable.addAttribute(GEOCODING, value);
            } else if (geoCoding instanceof CrsGeoCoding) {
                CoordinateReferenceSystem crs = geoCoding.getMapCRS();
                double[] matrix = new double[6];
                MathTransform transform = geoCoding.getImageToMapTransform();
                if (transform instanceof AffineTransform) {
                    ((AffineTransform)transform).getMatrix(matrix);
                }
                String crsName = "crs_" + band.getName();
                NVariable crsVariable = ncFile.addScalarVariable(crsName, DataType.INT);
                crsVariable.addAttribute("wkt", crs.toWKT());
                crsVariable.addAttribute("i2m", StringUtils.arrayToCsv((Object)matrix));
                variable.addAttribute(GEOCODING, crsName);
            }
        }
    }

    private boolean isPixelGeoCodingBand(Band band) {
        GeoCoding geoCoding = band.getGeoCoding();
        if (geoCoding instanceof BasicPixelGeoCoding) {
            BasicPixelGeoCoding pixelGeoCoding = (BasicPixelGeoCoding)geoCoding;
            return pixelGeoCoding.getLatBand() == band || pixelGeoCoding.getLonBand() == band;
        }
        return false;
    }

    private static void readBeamBandAttributes(Variable variable, Band band) {
        Attribute attribute = variable.findAttribute(BANDWIDTH);
        if (attribute != null) {
            band.setSpectralBandwidth(attribute.getNumericValue().floatValue());
        }
        if ((attribute = variable.findAttribute(WAVELENGTH)) != null) {
            band.setSpectralWavelength(attribute.getNumericValue().floatValue());
        }
        if ((attribute = variable.findAttribute(SPECTRAL_BAND_INDEX)) != null) {
            band.setSpectralBandIndex(attribute.getNumericValue().intValue());
        }
        if ((attribute = variable.findAttribute(VALID_PIXEL_EXPRESSION)) != null) {
            band.setValidPixelExpression(attribute.getStringValue());
        }
        if ((attribute = variable.findAttribute(SOLAR_FLUX)) != null) {
            band.setSolarFlux(attribute.getNumericValue().floatValue());
        }
        band.setName(ReaderUtils.getRasterName(variable));
    }

    private void maybeApplySpectralIndexAndSolarFluxFromMetadata(Product p) {
        List<Band> bands = Arrays.asList(p.getBands());
        int spectralIndex = 0;
        for (Band band : bands) {
            boolean isSolarFluxSet;
            boolean isSpectralBandIndexSet;
            boolean isSpectralBand = band.getSpectralWavelength() != 0.0f;
            boolean bl = isSpectralBandIndexSet = band.getSpectralBandIndex() != -1;
            if (!isSpectralBand || isSpectralBandIndexSet) continue;
            band.setSpectralBandIndex(spectralIndex);
            boolean bl2 = isSolarFluxSet = band.getSolarFlux() != 0.0f;
            if (!isSolarFluxSet) {
                BeamBandPart.applySolarFluxFromMetadata(band, spectralIndex);
            }
            ++spectralIndex;
        }
    }

    private static void applySolarFluxFromMetadata(Band band, int spectralIndex) {
        MetadataElement metadataRoot = band.getProduct().getMetadataRoot();
        band.setSolarFlux(BeamBandPart.getSolarFluxFromMetadata(metadataRoot, spectralIndex));
    }

    private static float getSolarFluxFromMetadata(MetadataElement metadataRoot, int bandIndex) {
        MetadataAttribute sunSpecFlux;
        ProductData data;
        MetadataElement scalingFactorGads;
        if (metadataRoot != null && (scalingFactorGads = metadataRoot.getElement("Scaling_Factor_GADS")) != null && (data = (sunSpecFlux = scalingFactorGads.getAttribute("sun_spec_flux")).getData()).getNumElems() > bandIndex) {
            return data.getElemFloatAt(bandIndex);
        }
        return 0.0f;
    }

    public static void writeBeamBandAttributes(Band band, NVariable variable) throws IOException {
        float spectralBandIndex;
        float solarFlux;
        String validPixelExpression;
        float spectralWavelength;
        float spectralBandwidth = band.getSpectralBandwidth();
        if (spectralBandwidth > 0.0f) {
            variable.addAttribute(BANDWIDTH, Float.valueOf(spectralBandwidth));
        }
        if ((spectralWavelength = band.getSpectralWavelength()) > 0.0f) {
            variable.addAttribute(WAVELENGTH, Float.valueOf(spectralWavelength));
        }
        if ((validPixelExpression = band.getValidPixelExpression()) != null && validPixelExpression.trim().length() > 0) {
            variable.addAttribute(VALID_PIXEL_EXPRESSION, validPixelExpression);
        }
        if ((solarFlux = band.getSolarFlux()) > 0.0f) {
            variable.addAttribute(SOLAR_FLUX, Float.valueOf(solarFlux));
        }
        if ((spectralBandIndex = (float)band.getSpectralBandIndex()) >= 0.0f) {
            variable.addAttribute(SPECTRAL_BAND_INDEX, Float.valueOf(spectralBandIndex));
        }
        if (!band.getName().equals(variable.getName())) {
            variable.addAttribute("orig_name", band.getName());
        }
    }
}

