/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.runtime.ProxyConfig;
import com.bc.ceres.core.runtime.internal.JarFilenameFilter;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import sun.misc.BASE64Encoder;

public class UrlHelper {
    public static boolean existsResource(String urlString, ProxyConfig proxyConfig) {
        try {
            URLConnection urlConnection = UrlHelper.openConnection(urlString, proxyConfig, "HEAD");
            urlConnection.connect();
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                httpURLConnection.disconnect();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static URLConnection openConnection(String urlString, ProxyConfig proxyConfig, String request) throws IOException {
        return UrlHelper.openConnection(new URL(urlString), proxyConfig, request);
    }

    public static URLConnection openConnection(URL url, ProxyConfig proxyConfig, String request) throws IOException {
        URLConnection urlConnection = proxyConfig == ProxyConfig.NULL ? url.openConnection() : url.openConnection(UrlHelper.createProxy(proxyConfig));
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpUrlConnection = (HttpURLConnection)urlConnection;
            httpUrlConnection.setRequestMethod(request);
        }
        if (proxyConfig.isAuthorizationUsed()) {
            UrlHelper.addProxyAuthorization(urlConnection, proxyConfig);
        }
        return urlConnection;
    }

    private static void addProxyAuthorization(URLConnection urlConnection, ProxyConfig proxyConfig) {
        String s = proxyConfig.getUsername() + ':' + new String(proxyConfig.getPassword());
        byte[] bytes = s.getBytes();
        BASE64Encoder base64Encoder = new BASE64Encoder();
        urlConnection.setRequestProperty("Proxy-Authorization", "Basic " + base64Encoder.encode(bytes));
    }

    private static Proxy createProxy(ProxyConfig proxyConfig) {
        InetSocketAddress socketAddress = new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort());
        return new Proxy(Proxy.Type.HTTP, socketAddress);
    }

    public static URI urlToUri(URL url) throws URISyntaxException {
        return new URI(url.toExternalForm().replace(" ", "%20"));
    }

    public static File urlToFile(URL url) {
        try {
            URI uri;
            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                String path = url.getPath();
                int jarEntrySepPos = path.lastIndexOf("!/");
                if (jarEntrySepPos > 0) {
                    path = path.substring(0, jarEntrySepPos);
                }
                url = new URL(path);
            }
            if ("file".equalsIgnoreCase((uri = UrlHelper.urlToUri(url)).getScheme()) && uri.isAbsolute() && !uri.isOpaque() && uri.getAuthority() == null && uri.getFragment() == null && uri.getQuery() == null) {
                return new File(uri);
            }
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL locationToManifestUrl(URL locationUrl) {
        String xmlUrlString;
        String location = locationUrl.toExternalForm();
        if (JarFilenameFilter.isJarName(location)) {
            xmlUrlString = "jar:" + location + "!/" + "module.xml";
        } else if (location.endsWith("/")) {
            xmlUrlString = location + "module.xml";
        } else {
            return null;
        }
        try {
            return new URL(xmlUrlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL manifestToLocationUrl(URL manifestUrl) {
        String location = manifestUrl.toExternalForm();
        if (!location.endsWith("module.xml")) {
            return null;
        }
        location = location.substring(0, location.length() - "module.xml".length());
        location = location.replace(" ", "%20");
        String prefix = "jar:";
        String suffix = "!/";
        if (location.startsWith(prefix) && location.endsWith(suffix)) {
            location = location.substring(prefix.length(), location.length() - suffix.length());
        }
        try {
            return new URL(location);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

