/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ExtensionFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ExtensionManager {
    private static ExtensionManager instance = new Impl();
    private static final TypeCondition IS_EQUAL_TO = new TypeCondition(){

        @Override
        public boolean fulfilled(Class<?> a, Class<?> b) {
            return a.equals(b);
        }
    };
    private static final TypeCondition IS_SUBTYPE_OF = new TypeCondition(){

        @Override
        public boolean fulfilled(Class<?> a, Class<?> b) {
            return !a.equals(b) && b.isAssignableFrom(a);
        }
    };

    public static ExtensionManager getInstance() {
        return instance;
    }

    public static void setInstance(ExtensionManager instance) {
        Assert.notNull(instance, "instance");
        ExtensionManager.instance = instance;
    }

    public abstract void register(Class<?> var1, ExtensionFactory var2);

    public abstract void unregister(Class<?> var1, ExtensionFactory var2);

    public abstract ExtensionFactory[] getExtensionFactories(Class<?> var1);

    public <E> E getExtension(Object extensibleObject, Class<E> extensionType) {
        Assert.notNull(extensibleObject, "extensibleObject");
        Assert.notNull(extensionType, "extensionType");
        return this.findExtensionDeep(extensibleObject, extensibleObject.getClass(), extensionType);
    }

    @Deprecated
    public <E> ExtensionFactory findFactory(Class<?> extensibleType, Class<E> extensionType) {
        Class<?> cls;
        Assert.notNull(extensibleType, "extensibleType");
        Assert.notNull(extensionType, "extensionType");
        ExtensionFactory factory = this.findFactoryFlat(extensibleType, extensionType, IS_EQUAL_TO);
        if (factory == null) {
            factory = this.findFactoryFlat(extensibleType, extensionType, IS_SUBTYPE_OF);
        }
        if (factory == null && (cls = extensibleType.getSuperclass()) != null) {
            factory = this.findFactory(cls, extensionType);
        }
        if (factory == null) {
            Class<?> ifc;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = extensibleType.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (factory = this.findFactory(ifc = classArray[i], extensionType)) == null; ++i) {
            }
        }
        return factory;
    }

    private <E> ExtensionFactory findFactoryFlat(Class<?> extensibleType, Class<E> extensionType, TypeCondition condition) {
        for (ExtensionFactory factory : this.getExtensionFactories(extensibleType)) {
            for (Class<?> cls : factory.getExtensionTypes()) {
                if (!condition.fulfilled(cls, extensionType)) continue;
                return factory;
            }
        }
        return null;
    }

    private <E> E findExtensionDeep(Object extensibleObject, Class<?> extensibleType, Class<E> extensionType) {
        Class<?>[] interfaces;
        Assert.notNull(extensibleObject, "extensibleObject");
        Assert.notNull(extensibleType, "extensibleType");
        Assert.notNull(extensionType, "extensionType");
        E extension = this.findExtensionFlat(extensibleObject, extensibleType, extensionType, IS_EQUAL_TO);
        if (extension != null) {
            return extension;
        }
        extension = this.findExtensionFlat(extensibleObject, extensibleType, extensionType, IS_SUBTYPE_OF);
        if (extension != null) {
            return extension;
        }
        Class<?> cls = extensibleType.getSuperclass();
        if (cls != null && (extension = this.findExtensionDeep(extensibleObject, cls, extensionType)) != null) {
            return extension;
        }
        for (Class<?> ifc : interfaces = extensibleType.getInterfaces()) {
            extension = this.findExtensionDeep(extensibleObject, ifc, extensionType);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }

    private <E> E findExtensionFlat(Object extensibleObject, Class<?> extensibleType, Class<E> extensionType, TypeCondition condition) {
        for (ExtensionFactory factory : this.getExtensionFactories(extensibleType)) {
            for (Class<?> cls : factory.getExtensionTypes()) {
                E extension;
                if (!condition.fulfilled(cls, extensionType) || (extension = this.getExtensionSafe(factory, extensibleObject, extensionType)) == null) continue;
                return extension;
            }
        }
        return null;
    }

    private <E> E getExtensionSafe(ExtensionFactory factory, Object extensibleObject, Class<E> extensionType) {
        try {
            return (E)factory.getExtension(extensibleObject, extensionType);
        }
        catch (Throwable thrown) {
            this.handleExtensionFactoryFailure(extensibleObject, extensionType, thrown);
            return null;
        }
    }

    private <E> void handleExtensionFactoryFailure(Object extensibleObject, Class<E> extensionType, Throwable thrown) {
        Logger logger = Logger.getLogger(System.getProperty("ceres.context", "ceres"));
        logger.log(Level.FINEST, String.format("Extension factory %s failed providing an extension for a %s of type %s: %s", this.getClass(), extensibleObject.getClass(), extensionType, thrown.getMessage()), thrown);
    }

    private static class Impl
    extends ExtensionManager {
        private HashMap<Class, List<ExtensionFactory>> extensionFactoryListMap = new HashMap();
        private static final ExtensionFactory[] NO_EXTENSION_FACTORIES = new ExtensionFactory[0];

        private Impl() {
        }

        @Override
        public void register(Class<?> extensibleType, ExtensionFactory factory) {
            Assert.notNull(extensibleType, "extensibleType");
            Assert.notNull(factory, "factory");
            List<ExtensionFactory> extensionFactoryList = this.extensionFactoryListMap.get(extensibleType);
            if (extensionFactoryList == null) {
                extensionFactoryList = new ArrayList<ExtensionFactory>();
                this.extensionFactoryListMap.put(extensibleType, extensionFactoryList);
            }
            if (!extensionFactoryList.contains(factory)) {
                extensionFactoryList.add(factory);
            }
        }

        @Override
        public void unregister(Class<?> extensibleType, ExtensionFactory factory) {
            Assert.notNull(extensibleType, "extensibleType");
            Assert.notNull(factory, "factory");
            List<ExtensionFactory> extensionFactoryList = this.extensionFactoryListMap.get(extensibleType);
            if (extensionFactoryList != null) {
                extensionFactoryList.remove(factory);
            }
        }

        @Override
        public ExtensionFactory[] getExtensionFactories(Class<?> extensibleType) {
            Assert.notNull(extensibleType, "extensibleType");
            List<ExtensionFactory> extensionFactoryList = this.extensionFactoryListMap.get(extensibleType);
            if (extensionFactoryList != null) {
                return extensionFactoryList.toArray(new ExtensionFactory[extensionFactoryList.size()]);
            }
            return NO_EXTENSION_FACTORIES;
        }
    }

    private static interface TypeCondition {
        public boolean fulfilled(Class<?> var1, Class<?> var2);
    }
}

