/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.launcher.internal;

import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.launcher.internal.AbstractClasspathFactory;
import java.io.File;
import java.util.ArrayList;

public class BootstrapClasspathFactory
extends AbstractClasspathFactory {
    private ArrayList<File> classpath = new ArrayList(10);
    private File ceresCoreFile;

    public BootstrapClasspathFactory(RuntimeConfig config) {
        super(config);
    }

    @Override
    protected File[] getClasspathFiles() throws RuntimeConfigException {
        if (this.ceresCoreFile != null) {
            this.classpath.add(0, this.ceresCoreFile);
        }
        return this.classpath.toArray(new File[this.classpath.size()]);
    }

    @Override
    public void processClasspathFile(File file, AbstractClasspathFactory.LibType libType, int level) {
        if (level > 0) {
            return;
        }
        String name = file.getName().toLowerCase();
        if (name.startsWith("snap-ceres-core")) {
            this.ceresCoreFile = BootstrapClasspathFactory.getMax(this.ceresCoreFile, file);
        } else {
            if (name.startsWith("snap-launcher")) {
                return;
            }
            if (libType.equals((Object)AbstractClasspathFactory.LibType.LIBRARY)) {
                this.classpath.add(file);
            }
        }
    }

    static File getMax(File file1, File file2) {
        String nameNoExt2;
        if (file1 == null) {
            return file2;
        }
        if (file2 == null) {
            return file1;
        }
        String nameNoExt1 = BootstrapClasspathFactory.trimExt(file1.getName());
        if (nameNoExt1.compareToIgnoreCase(nameNoExt2 = BootstrapClasspathFactory.trimExt(file2.getName())) > 0) {
            return file1;
        }
        return file2;
    }

    private static String trimExt(String name) {
        int p = name.lastIndexOf(46);
        String nameNoExt = name;
        if (p > 0) {
            nameNoExt = name.substring(0, p);
        }
        return nameNoExt;
    }
}

