/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class LandCoverMaskOpUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JComboBox<String> landCoverBandCombo = new JComboBox();
    private final JList validLandCoverClassesList = new JList();
    private final JCheckBox includeOtherBandsCheckBox = new JCheckBox("Include all other bands");
    private final Map<Integer, Integer> classMap = new HashMap<Integer, Integer>();
    private final Map<Integer, String> classNameMap = new HashMap<Integer, String>();

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.landCoverBandCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LandCoverMaskOpUI.this.validLandCoverClassesList.removeAll();
                LandCoverMaskOpUI.this.validLandCoverClassesList.setListData(LandCoverMaskOpUI.this.getLandCoverClasses((String)LandCoverMaskOpUI.this.landCoverBandCombo.getSelectedItem()));
                int[] selClasses = (int[])LandCoverMaskOpUI.this.paramMap.get("validLandCoverClasses");
                if (selClasses != null) {
                    LandCoverMaskOpUI.this.validLandCoverClassesList.setSelectedIndices(LandCoverMaskOpUI.this.getClassIndexes(selClasses));
                }
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        Boolean includeOtherBands;
        String[] landCoverBandNames;
        String[] bandNames = this.getBandNames();
        OperatorUIUtils.initParamList((JList)this.bandList, (String[])bandNames, (Object[])((Object[])this.paramMap.get("sourceBands")));
        this.landCoverBandCombo.removeAllItems();
        for (String bandName : landCoverBandNames = this.getLandCoverNames()) {
            this.landCoverBandCombo.addItem(bandName);
        }
        String landCoverBand = (String)this.paramMap.get("landCoverBand");
        if (landCoverBand != null && StringUtils.contains((String[])landCoverBandNames, (String)landCoverBand)) {
            this.landCoverBandCombo.setSelectedItem(landCoverBand);
        }
        if ((includeOtherBands = (Boolean)this.paramMap.get("includeOtherBands")) != null) {
            this.includeOtherBandsCheckBox.setSelected(includeOtherBands);
        }
    }

    private String[] getLandCoverNames() {
        ArrayList<String> namesList = new ArrayList<String>();
        try {
            if (this.sourceProducts != null) {
                for (Band b : this.sourceProducts[0].getBands()) {
                    if (b.getUnit() == null || !b.getUnit().equals("class")) continue;
                    namesList.add(b.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return namesList.toArray(new String[namesList.size()]);
    }

    private String[] getLandCoverClasses(String landCoverBandName) {
        IndexCoding indexCoding;
        Band srcBand;
        ArrayList<String> classList = new ArrayList<String>();
        if (landCoverBandName != null && (srcBand = this.sourceProducts[0].getBand(landCoverBandName)) != null && (indexCoding = srcBand.getIndexCoding()) != null) {
            String[] indexNames = indexCoding.getIndexNames();
            int i = 0;
            for (String indexName : indexNames) {
                classList.add(indexName);
                int classVal = indexCoding.getIndexValue(indexName);
                this.classMap.put(i++, classVal);
                this.classNameMap.put(classVal, indexName);
            }
        }
        return classList.toArray(new String[classList.size()]);
    }

    private int[] getClassIndexes(int[] selClasses) {
        ArrayList<Integer> indexList = new ArrayList<Integer>(selClasses.length);
        for (int i = 0; i < this.validLandCoverClassesList.getModel().getSize(); ++i) {
            String listName = (String)this.validLandCoverClassesList.getModel().getElementAt(i);
            for (int selClass : selClasses) {
                String selClassName = this.classNameMap.get(selClass);
                if (!listName.equals(selClassName)) continue;
                indexList.add(i);
            }
        }
        int[] index = new int[indexList.size()];
        int i = 0;
        Object object = indexList.iterator();
        while (object.hasNext()) {
            Integer val = (Integer)object.next();
            index[i++] = val;
        }
        return index;
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        if (!this.hasSourceProducts()) {
            return;
        }
        OperatorUIUtils.updateParamList((JList)this.bandList, (Map)this.paramMap, (String)"sourceBandNames");
        this.paramMap.put("landCoverBand", this.landCoverBandCombo.getSelectedItem());
        this.paramMap.put("validLandCoverClasses", this.getSelectedClasses());
        this.paramMap.put("includeOtherBands", this.includeOtherBandsCheckBox.isSelected());
    }

    private int[] getSelectedClasses() {
        int[] selIndex = this.validLandCoverClassesList.getSelectedIndices();
        int[] classList = new int[selIndex.length];
        for (int i = 0; i < selIndex.length; ++i) {
            classList[i] = this.classMap.get(selIndex[i]);
        }
        return classList;
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Land Cover Band:", this.landCoverBandCombo);
        ++gbc.gridy;
        contentPane.add((Component)new JLabel("Valid land cover classes:"), gbc);
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.validLandCoverClassesList), gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        contentPane.add((Component)this.includeOtherBandsCheckBox, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

