/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.hdf5;

import java.util.List;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.dataio.hdf5.Hdf5ProductWriter;
import org.junit.Assert;
import org.junit.Test;

public class Hdf5ProductWriterTest {
    @Test
    public void testEnumerateChildrenWithSameName() throws Exception {
        MetadataElement childOne = new MetadataElement("child");
        childOne.addAttribute(new MetadataAttribute("1", 10));
        MetadataElement childTwo = new MetadataElement("child");
        childTwo.addAttribute(new MetadataAttribute("2", 10));
        MetadataElement childThree = new MetadataElement("child");
        childThree.addAttribute(new MetadataAttribute("3", 10));
        MetadataElement parent = new MetadataElement("parent");
        parent.addElement(new MetadataElement("one"));
        parent.addElement(childOne);
        parent.addElement(childTwo);
        parent.addElement(childThree);
        parent.addElement(new MetadataElement("sister"));
        parent.addElement(new MetadataElement("brother"));
        List metadataElements = Hdf5ProductWriter.enumerateChildrenWithSameName((MetadataElement)parent);
        Assert.assertEquals((Object)"one", (Object)((MetadataElement)metadataElements.get(0)).getName());
        Assert.assertEquals((Object)"child.1", (Object)((MetadataElement)metadataElements.get(1)).getName());
        Assert.assertEquals((Object)"1", (Object)((MetadataElement)metadataElements.get(1)).getAttributeAt(0).getName());
        Assert.assertEquals((Object)"child.2", (Object)((MetadataElement)metadataElements.get(2)).getName());
        Assert.assertEquals((Object)"2", (Object)((MetadataElement)metadataElements.get(2)).getAttributeAt(0).getName());
        Assert.assertEquals((Object)"child.3", (Object)((MetadataElement)metadataElements.get(3)).getName());
        Assert.assertEquals((Object)"3", (Object)((MetadataElement)metadataElements.get(3)).getAttributeAt(0).getName());
        Assert.assertEquals((Object)"sister", (Object)((MetadataElement)metadataElements.get(4)).getName());
        Assert.assertEquals((Object)"brother", (Object)((MetadataElement)metadataElements.get(5)).getName());
    }

    @Test
    public void testEnumerateChildrenWithSameName_AllNamesAreDifferent() throws Exception {
        MetadataElement parent = new MetadataElement("parent");
        parent.addElement(new MetadataElement("one"));
        parent.addElement(new MetadataElement("sister"));
        parent.addElement(new MetadataElement("brother"));
        List metadataElements = Hdf5ProductWriter.enumerateChildrenWithSameName((MetadataElement)parent);
        Assert.assertEquals((Object)"one", (Object)((MetadataElement)metadataElements.get(0)).getName());
        Assert.assertEquals((Object)"sister", (Object)((MetadataElement)metadataElements.get(1)).getName());
        Assert.assertEquals((Object)"brother", (Object)((MetadataElement)metadataElements.get(2)).getName());
    }
}

