/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.hdf5;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.hdf5.Hdf5ProductWriter;

public class Hdf5ProductWriterPlugIn
implements ProductWriterPlugIn {
    public static final String HDF5_FORMAT_NAME = "HDF5";
    public static final String HDF5_FILE_EXTENSION = ".h5";
    private static final String H5_CLASS_NAME = "ncsa.hdf.hdf5lib.H5";
    private static final boolean hdf5LibAvailable = Hdf5ProductWriterPlugIn.loadHdf5Lib();

    public static boolean isHdf5LibAvailable() {
        return hdf5LibAvailable;
    }

    public EncodeQualification getEncodeQualification(Product product) {
        return new EncodeQualification(EncodeQualification.Preservation.PARTIAL);
    }

    public String[] getFormatNames() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return new String[0];
        }
        return new String[]{HDF5_FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return new String[0];
        }
        return new String[]{HDF5_FILE_EXTENSION};
    }

    public Class[] getOutputTypes() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return new Class[0];
        }
        return new Class[]{String.class, File.class};
    }

    public String getDescription(Locale name) {
        return "HDF5 product writer";
    }

    public ProductWriter createWriterInstance() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return null;
        }
        return new Hdf5ProductWriter(this);
    }

    public SnapFileFilter getProductFileFilter() {
        String[] formatNames = this.getFormatNames();
        String formatName = "";
        if (formatNames.length > 0) {
            formatName = formatNames[0];
        }
        return new SnapFileFilter(formatName, this.getDefaultFileExtensions(), this.getDescription(null));
    }

    private static boolean loadHdf5Lib() {
        try {
            Class.forName(H5_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (LinkageError e) {
            SystemUtils.LOG.warning(MessageFormat.format("{0}: HDF-5 library not available: {1}: {2}", Hdf5ProductWriterPlugIn.class, e.getClass(), e.getMessage()));
            return false;
        }
    }
}

