/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.hdf5;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import org.esa.beam.dataio.hdf5.Hdf5ProductWriter;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.logging.BeamLogManager;

public class Hdf5ProductWriterPlugIn
implements ProductWriterPlugIn {
    public static final String HDF5_FORMAT_NAME = "HDF5";
    public static final String HDF5_FILE_EXTENSION = ".h5";
    private static final String _H5_CLASS_NAME = "ncsa.hdf.hdf5lib.H5";
    private static boolean hdf5LibAvailable = false;

    public static boolean isHdf5LibAvailable() {
        return hdf5LibAvailable;
    }

    public String[] getFormatNames() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return new String[0];
        }
        return new String[]{HDF5_FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return new String[0];
        }
        return new String[]{HDF5_FILE_EXTENSION};
    }

    public Class[] getOutputTypes() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return new Class[0];
        }
        return new Class[]{String.class, File.class};
    }

    public String getDescription(Locale name) {
        return "HDF5 product writer";
    }

    public ProductWriter createWriterInstance() {
        if (!Hdf5ProductWriterPlugIn.isHdf5LibAvailable()) {
            return null;
        }
        return new Hdf5ProductWriter(this);
    }

    public BeamFileFilter getProductFileFilter() {
        String[] formatNames = this.getFormatNames();
        String formatName = "";
        if (formatNames.length > 0) {
            formatName = formatNames[0];
        }
        return new BeamFileFilter(formatName, this.getDefaultFileExtensions(), this.getDescription(null));
    }

    private static Class<?> loadHdf5Lib(Class<?> callerClass) {
        return Hdf5ProductWriterPlugIn.loadClassWithNativeDependencies(callerClass, _H5_CLASS_NAME, "{0}: HDF-5 library not available: {1}: {2}");
    }

    private static Class<?> loadClassWithNativeDependencies(Class<?> callerClass, String className, String warningPattern) {
        ClassLoader classLoader = callerClass.getClassLoader();
        String classResourceName = "/" + className.replace('.', '/') + ".class";
        if (callerClass.getResource(classResourceName) != null) {
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (Throwable error) {
                BeamLogManager.getSystemLogger().warning(MessageFormat.format(warningPattern, callerClass, error.getClass(), error.getMessage()));
                return null;
            }
        }
        return null;
    }

    static {
        hdf5LibAvailable = Hdf5ProductWriterPlugIn.loadHdf5Lib(Hdf5ProductWriterPlugIn.class) != null;
    }
}

