/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.hdf5;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import org.esa.beam.framework.dataio.AbstractProductWriter;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.dataio.ProductWriterPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.MapInfo;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.io.FileUtils;

public class Hdf5ProductWriter
extends AbstractProductWriter {
    private File _outputFile;
    private Map _bandIDs;
    private int _fileID;
    private boolean _hdf5LibInit;
    private boolean _metadataAnnotated = false;

    public Hdf5ProductWriter(ProductWriterPlugIn writerPlugIn) {
        super(writerPlugIn);
    }

    public File getOutputFile() {
        return this._outputFile;
    }

    public Map getBandOutputStreams() {
        return this._bandIDs;
    }

    public boolean shouldWrite(ProductNode node) {
        return !(node instanceof VirtualBand) && super.shouldWrite(node);
    }

    protected void writeProductNodesImpl() throws IOException {
        if (!this._hdf5LibInit) {
            try {
                H5.H5open();
                this._hdf5LibInit = true;
            }
            catch (HDF5LibraryException e) {
                throw new ProductIOException(this.createErrorMessage((HDF5Exception)e));
            }
        }
        if (this.getOutput() instanceof String) {
            this._outputFile = new File((String)this.getOutput());
        } else if (this.getOutput() instanceof File) {
            this._outputFile = (File)this.getOutput();
        }
        Debug.assertNotNull((Object)this._outputFile);
        this._outputFile = FileUtils.ensureExtension((File)this._outputFile, (String)".h5");
        try {
            Debug.trace((String)("creating HDF5 file " + this._outputFile.getPath()));
            this._fileID = H5.H5Fcreate((String)this._outputFile.getPath(), (int)HDF5Constants.H5F_ACC_TRUNC, (int)HDF5Constants.H5P_DEFAULT, (int)HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5LibraryException e) {
            throw new ProductIOException(this.createErrorMessage((HDF5Exception)e));
        }
        this.writeTiePointGrids();
        this.writeGeoCoding();
        this.writeFlagCodings();
        this.writeMetadata();
    }

    private void writeGeoCoding() throws IOException {
        Product product = this.getSourceProduct();
        if (product.getGeoCoding() instanceof TiePointGeoCoding) {
            this.writeGeoCoding((TiePointGeoCoding)product.getGeoCoding());
        } else if (product.getGeoCoding() instanceof MapGeoCoding) {
            this.writeGeoCoding((MapGeoCoding)product.getGeoCoding());
        }
    }

    private void writeGeoCoding(TiePointGeoCoding geoCoding) throws IOException {
        int groupID = this.createH5G(this._fileID, "geo_coding");
        try {
            this.createScalarAttribute(groupID, "java_class_name", TiePointGeoCoding.class.getName());
            this.createScalarAttribute(groupID, "lat_grid", geoCoding.getLatGrid().getName());
            this.createScalarAttribute(groupID, "lon_grid", geoCoding.getLonGrid().getName());
        }
        finally {
            this.closeH5G(groupID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGeoCoding(MapGeoCoding geoCoding) throws IOException {
        MapInfo mapInfo = geoCoding.getMapInfo();
        MapProjection mapProjection = mapInfo.getMapProjection();
        int groupID = this.createH5G(this._fileID, "geo_coding");
        try {
            this.createScalarAttribute(groupID, "java_class_name", MapGeoCoding.class.getName());
            this.createScalarAttribute(groupID, "easting", mapInfo.getEasting());
            this.createScalarAttribute(groupID, "northing", mapInfo.getNorthing());
            this.createScalarAttribute(groupID, "pixel_x", mapInfo.getPixelX());
            this.createScalarAttribute(groupID, "pixel_y", mapInfo.getPixelY());
            this.createScalarAttribute(groupID, "pixel_size_x", mapInfo.getPixelSizeX());
            this.createScalarAttribute(groupID, "pixel_size_y", mapInfo.getPixelSizeY());
            this.createScalarAttribute(groupID, "datum", mapInfo.getDatum().getName());
            this.createScalarAttribute(groupID, "unit", mapProjection.getMapUnit());
            this.createScalarAttribute(groupID, "projection", mapProjection.getName());
            int paramsID = this.createH5G(groupID, "projection_params");
            try {
                MapTransform mapTransform = mapProjection.getMapTransform();
                MapTransformDescriptor mapTransformDescriptor = mapTransform.getDescriptor();
                Parameter[] parameters = mapTransformDescriptor.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    this.createScalarAttribute(paramsID, parameters[i].getName(), mapTransform.getParameterValues()[i]);
                }
            }
            finally {
                this.closeH5G(paramsID);
            }
        }
        finally {
            this.closeH5G(groupID);
        }
    }

    public void writeBandRasterData(Band sourceBand, int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, ProductData sourceBuffer, ProgressMonitor pm) throws IOException {
        this.checkBufferSize(sourceWidth, sourceHeight, sourceBuffer);
        int sourceBandWidth = sourceBand.getSceneRasterWidth();
        int sourceBandHeight = sourceBand.getSceneRasterHeight();
        this.checkSourceRegionInsideBandRegion(sourceWidth, sourceBandWidth, sourceHeight, sourceBandHeight, sourceOffsetX, sourceOffsetY);
        int memTypeID = -1;
        int memSpaceID = -1;
        pm.beginTask("Writing band '" + sourceBand.getName() + "'...", 1);
        try {
            int datasetID = this.getOrCreateBandH5D(sourceBand);
            int fileSpaceID = H5.H5Dget_space((int)datasetID);
            long[] memDims = new long[]{sourceHeight, sourceWidth};
            long[] memStart = new long[2];
            long[] memCount = new long[2];
            long[] fileStart = new long[2];
            long[] fileCount = new long[2];
            memTypeID = this.createH5TypeID(sourceBuffer.getType());
            memSpaceID = H5.H5Screate_simple((int)2, (long[])memDims, null);
            memStart[0] = 0L;
            memStart[1] = 0L;
            memCount[0] = sourceHeight;
            memCount[1] = sourceWidth;
            H5.H5Sselect_hyperslab((int)memSpaceID, (int)HDF5Constants.H5S_SELECT_SET, (long[])memStart, null, (long[])memCount, null);
            fileStart[0] = sourceOffsetY;
            fileStart[1] = sourceOffsetX;
            fileCount[0] = sourceHeight;
            fileCount[1] = sourceWidth;
            H5.H5Sselect_hyperslab((int)fileSpaceID, (int)HDF5Constants.H5S_SELECT_SET, (long[])fileStart, null, (long[])fileCount, null);
            H5.H5Dwrite((int)datasetID, (int)memTypeID, (int)memSpaceID, (int)fileSpaceID, (int)HDF5Constants.H5P_DEFAULT, (Object)sourceBuffer.getElems());
            pm.worked(1);
        }
        catch (IOException e) {
            throw e;
        }
        catch (HDF5Exception e) {
            throw new ProductIOException(this.createErrorMessage(e));
        }
        finally {
            this.closeH5S(memSpaceID);
            this.closeH5T(memTypeID);
            pm.done();
        }
    }

    public void deleteOutput() {
        if (this._outputFile != null) {
            this._outputFile.delete();
        }
    }

    public void flush() throws IOException {
        if (this._fileID == -1) {
            return;
        }
        if (this._bandIDs != null) {
            Iterator it = this._bandIDs.values().iterator();
            while (it.hasNext()) {
                int datasetID = (Integer)it.next();
                if (datasetID == -1) continue;
                try {
                    H5.H5Fflush((int)datasetID, (int)HDF5Constants.H5F_SCOPE_LOCAL);
                }
                catch (HDF5LibraryException e) {
                    Debug.trace((Throwable)e);
                }
            }
        }
        try {
            H5.H5Fflush((int)this._fileID, (int)HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (HDF5LibraryException e) {
            throw new ProductIOException(this.createErrorMessage((HDF5Exception)((Object)e)));
        }
    }

    public void close() throws IOException {
        if (this._fileID == -1) {
            return;
        }
        if (this._bandIDs != null) {
            Iterator it = this._bandIDs.values().iterator();
            while (it.hasNext()) {
                int datasetID = (Integer)it.next();
                this.closeH5D(datasetID);
            }
            this._bandIDs.clear();
            this._bandIDs = null;
        }
        try {
            H5.H5Fclose((int)this._fileID);
        }
        catch (HDF5LibraryException e) {
            throw new ProductIOException(this.createErrorMessage((HDF5Exception)((Object)e)));
        }
        this._fileID = -1;
    }

    private int getH5DataType(int productDataType) {
        int jh5DataType = -1;
        if (productDataType == 10) {
            jh5DataType = HDF5Constants.H5T_NATIVE_INT8;
        } else if (productDataType == 20) {
            jh5DataType = HDF5Constants.H5T_NATIVE_UINT8;
        } else if (productDataType == 11) {
            jh5DataType = HDF5Constants.H5T_NATIVE_INT16;
        } else if (productDataType == 21) {
            jh5DataType = HDF5Constants.H5T_NATIVE_UINT16;
        } else if (productDataType == 12) {
            jh5DataType = HDF5Constants.H5T_NATIVE_INT32;
        } else if (productDataType == 22) {
            jh5DataType = HDF5Constants.H5T_NATIVE_UINT32;
        } else if (productDataType == 30) {
            jh5DataType = HDF5Constants.H5T_NATIVE_FLOAT;
        } else if (productDataType == 31) {
            jh5DataType = HDF5Constants.H5T_NATIVE_DOUBLE;
        } else if (productDataType == 41) {
            jh5DataType = HDF5Constants.H5T_C_S1;
        } else if (productDataType == 51) {
            jh5DataType = HDF5Constants.H5T_C_S1;
        } else {
            throw new IllegalArgumentException("illegal data type ID: " + productDataType);
        }
        return jh5DataType;
    }

    private int createH5TypeID(int productDataType) throws IOException {
        try {
            int h5DataType = this.getH5DataType(productDataType);
            return H5.H5Tcopy((int)h5DataType);
        }
        catch (HDF5LibraryException e) {
            throw new ProductIOException(this.createErrorMessage((HDF5Exception)((Object)e)));
        }
    }

    private void checkSourceRegionInsideBandRegion(int sourceWidth, int sourceBandWidth, int sourceHeight, int sourceBandHeight, int sourceOffsetX, int sourceOffsetY) {
        Guardian.assertWithinRange((String)"sourceWidth", (long)sourceWidth, (long)1L, (long)sourceBandWidth);
        Guardian.assertWithinRange((String)"sourceHeight", (long)sourceHeight, (long)1L, (long)sourceBandHeight);
        Guardian.assertWithinRange((String)"sourceOffsetX", (long)sourceOffsetX, (long)0L, (long)(sourceBandWidth - sourceWidth));
        Guardian.assertWithinRange((String)"sourceOffsetY", (long)sourceOffsetY, (long)0L, (long)(sourceBandHeight - sourceHeight));
    }

    private void checkBufferSize(int sourceWidth, int sourceHeight, ProductData sourceBuffer) {
        int expectedBufferSize = sourceWidth * sourceHeight;
        int actualBufferSize = sourceBuffer.getNumElems();
        Guardian.assertEquals((String)"wrong sourceBuffer size", (long)actualBufferSize, (long)expectedBufferSize);
    }

    private void writeFlagCodings() throws IOException {
        if (this.getSourceProduct().getFlagCodingGroup().getNodeCount() == 0) {
            return;
        }
        int groupID = this.createH5G(this._fileID, "/flag_codings");
        try {
            for (int i = 0; i < this.getSourceProduct().getFlagCodingGroup().getNodeCount(); ++i) {
                FlagCoding flagCoding = (FlagCoding)this.getSourceProduct().getFlagCodingGroup().get(i);
                this.writeMetadataElement(groupID, (MetadataElement)flagCoding);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.closeH5G(groupID);
        }
    }

    private void writeMetadata() throws IOException {
        MetadataElement root = this.getSourceProduct().getMetadataRoot();
        if (root != null) {
            this.writeMetadataElement(this._fileID, root);
        }
    }

    private void writeMetadataElement(int locationID, MetadataElement element) throws IOException {
        int groupID = this.createH5G(locationID, element.getName());
        try {
            int i;
            for (i = 0; i < element.getNumAttributes(); ++i) {
                MetadataAttribute attribute = element.getAttributeAt(i);
                this.writeMetadataAttribute(groupID, attribute);
            }
            for (i = 0; i < element.getNumElements(); ++i) {
                MetadataElement subElement = element.getElementAt(i);
                this.writeMetadataElement(groupID, subElement);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.closeH5G(groupID);
        }
    }

    private void writeMetadataAttribute(int locationID, MetadataAttribute attribute) throws IOException {
        int productDataType = attribute.getDataType();
        if (attribute.getData() instanceof ProductData.ASCII || attribute.getData() instanceof ProductData.UTC) {
            this.createScalarAttribute(locationID, attribute.getName(), attribute.getData().getElemString());
        } else if (attribute.getData().isScalar()) {
            this.createScalarAttribute(locationID, attribute.getName(), this.getH5DataType(productDataType), attribute.getData().getElems());
        } else {
            this.createArrayAttribute(locationID, attribute.getName(), this.getH5DataType(productDataType), attribute.getData().getNumElems(), attribute.getData().getElems());
        }
        if (this._metadataAnnotated) {
            if (attribute.getUnit() != null) {
                this.createScalarAttribute(locationID, attribute.getName() + ".unit", attribute.getUnit());
            }
            if (attribute.getDescription() != null) {
                this.createScalarAttribute(locationID, attribute.getName() + ".descr", attribute.getDescription());
            }
        }
    }

    private void writeTiePointGrids() throws IOException {
        if (this.getSourceProduct().getNumTiePointGrids() > 0) {
            this.createGroup("/tie_point_grids");
            for (int i = 0; i < this.getSourceProduct().getNumTiePointGrids(); ++i) {
                TiePointGrid grid = this.getSourceProduct().getTiePointGridAt(i);
                this.writeTiePointGrid(grid, "/tie_point_grids");
            }
        }
    }

    private void writeTiePointGrid(TiePointGrid grid, String path) throws IOException {
        int w = grid.getRasterWidth();
        int h = grid.getRasterHeight();
        long[] dims = new long[]{h, w};
        int dataTypeID = -1;
        int dataSpaceID = -1;
        int datasetID = -1;
        try {
            dataTypeID = this.createH5TypeID(grid.getDataType());
            dataSpaceID = H5.H5Screate_simple((int)2, (long[])dims, null);
            datasetID = H5.H5Dcreate((int)this._fileID, (String)(path + "/" + grid.getName()), (int)dataTypeID, (int)dataSpaceID, (int)HDF5Constants.H5P_DEFAULT);
            this.createScalarAttribute(datasetID, "scene_raster_width", grid.getSceneRasterWidth());
            this.createScalarAttribute(datasetID, "scene_raster_height", grid.getSceneRasterHeight());
            this.createScalarAttribute(datasetID, "offset_x", grid.getOffsetX());
            this.createScalarAttribute(datasetID, "offset_y", grid.getOffsetY());
            this.createScalarAttribute(datasetID, "sub_sampling_x", grid.getSubSamplingX());
            this.createScalarAttribute(datasetID, "sub_sampling_y", grid.getSubSamplingY());
            try {
                this.createScalarAttribute(datasetID, "raster_width", grid.getRasterWidth());
                this.createScalarAttribute(datasetID, "raster_height", grid.getRasterHeight());
                this.createScalarAttribute(datasetID, "unit", grid.getUnit());
                this.createScalarAttribute(datasetID, "description", grid.getDescription());
                this.createScalarAttribute(datasetID, "CLASS", "IMAGE");
                this.createScalarAttribute(datasetID, "IMAGE_VERSION", 1.0f);
            }
            catch (IOException e) {
                Debug.trace((String)("failed to create attribute: " + e.getMessage()));
            }
            H5.H5Dwrite((int)datasetID, (int)dataTypeID, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (Object)grid.getData().getElems());
        }
        catch (HDF5Exception e) {
            throw new ProductIOException(this.createErrorMessage(e));
        }
        finally {
            this.closeH5D(datasetID);
            this.closeH5S(dataSpaceID);
            this.closeH5T(dataTypeID);
        }
    }

    private void createScalarAttribute(int locationID, String name, int value) throws IOException {
        this.createScalarAttribute(locationID, name, HDF5Constants.H5T_NATIVE_INT, new int[]{value});
    }

    private void createScalarAttribute(int locationID, String name, float value) throws IOException {
        this.createScalarAttribute(locationID, name, HDF5Constants.H5T_NATIVE_FLOAT, new float[]{value});
    }

    private void createScalarAttribute(int locationID, String name, double value) throws IOException {
        this.createScalarAttribute(locationID, name, HDF5Constants.H5T_NATIVE_DOUBLE, new double[]{value});
    }

    private void createScalarAttribute(int locationID, String name, String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.createScalarAttribute(locationID, name, HDF5Constants.H5T_C_S1, value.length(), value.getBytes());
        }
    }

    private void createScalarAttribute(int locationID, String name, int jh5DataType, Object value) throws IOException {
        this.createScalarAttribute(locationID, name, jh5DataType, -1, value);
    }

    private void createScalarAttribute(int locationID, String name, int jh5DataType, int typeSize, Object value) throws IOException {
        Debug.trace((String)("Hdf5ProductWriter.createScalarAttribute(locationID=" + locationID + ", name=" + name + ", jh5DataType=" + jh5DataType + ", typeSize=" + typeSize + ", value=" + value + ")"));
        int attrTypeID = -1;
        int attrSpaceID = -1;
        int attributeID = -1;
        try {
            attrTypeID = H5.H5Tcopy((int)jh5DataType);
            if (typeSize > 0) {
                H5.H5Tset_size((int)attrTypeID, (int)typeSize);
            }
            attrSpaceID = H5.H5Screate((int)HDF5Constants.H5S_SCALAR);
            attributeID = H5.H5Acreate((int)locationID, (String)name, (int)attrTypeID, (int)attrSpaceID, (int)HDF5Constants.H5P_DEFAULT);
            H5.H5Awrite((int)attributeID, (int)attrTypeID, (Object)value);
        }
        catch (HDF5Exception e) {
            throw new ProductIOException(this.createErrorMessage(e));
        }
        finally {
            this.closeH5A(attributeID);
            this.closeH5S(attrSpaceID);
            this.closeH5T(attrTypeID);
        }
    }

    private void createArrayAttribute(int locationID, String name, float[] values) throws IOException {
        this.createArrayAttribute(locationID, name, HDF5Constants.H5T_NATIVE_FLOAT, values.length, values);
    }

    private void createArrayAttribute(int locationID, String name, int jh5DataType, int arraySize, Object value) throws IOException {
        int attrTypeID = -1;
        int attrSpaceID = -1;
        int attributeID = -1;
        try {
            attrTypeID = H5.H5Tcopy((int)jh5DataType);
            attrSpaceID = H5.H5Screate_simple((int)1, (long[])new long[]{arraySize}, null);
            attributeID = H5.H5Acreate((int)locationID, (String)name, (int)attrTypeID, (int)attrSpaceID, (int)HDF5Constants.H5P_DEFAULT);
            H5.H5Awrite((int)attributeID, (int)attrTypeID, (Object)value);
        }
        catch (HDF5Exception e) {
            throw new ProductIOException(this.createErrorMessage(e));
        }
        finally {
            this.closeH5A(attributeID);
            this.closeH5S(attrSpaceID);
            this.closeH5T(attrTypeID);
        }
    }

    private Integer getOrCreateBandH5D(Band band) throws IOException {
        Integer bandID = this.getBandH5D(band);
        if (bandID == null) {
            if (this._bandIDs == null) {
                this._bandIDs = new HashMap();
                this.createGroup("/bands");
            }
            bandID = this.createBandH5D(band);
            this._bandIDs.put(band, bandID);
        }
        return bandID;
    }

    private Integer getBandH5D(Band band) {
        if (this._bandIDs != null) {
            return (Integer)this._bandIDs.get(band);
        }
        return null;
    }

    private Integer createBandH5D(Band band) throws IOException {
        int w = band.getRasterWidth();
        int h = band.getRasterHeight();
        long[] dims = new long[]{h, w};
        int datasetID = -1;
        int fileTypeID = -1;
        int fileSpaceID = -1;
        try {
            fileTypeID = this.createH5TypeID(band.getDataType());
            fileSpaceID = H5.H5Screate_simple((int)2, (long[])dims, null);
            datasetID = H5.H5Dcreate((int)this._fileID, (String)("/bands/" + band.getName()), (int)fileTypeID, (int)fileSpaceID, (int)HDF5Constants.H5P_DEFAULT);
            try {
                this.createScalarAttribute(datasetID, "raster_width", band.getRasterWidth());
                this.createScalarAttribute(datasetID, "raster_height", band.getRasterHeight());
                this.createScalarAttribute(datasetID, "scaling_factor", band.getScalingFactor());
                this.createScalarAttribute(datasetID, "scaling_offset", band.getScalingOffset());
                this.createScalarAttribute(datasetID, "log10_scaled", band.isLog10Scaled() ? "true" : "false");
                this.createScalarAttribute(datasetID, "unit", band.getUnit());
                this.createScalarAttribute(datasetID, "description", band.getDescription());
                if (band.getSpectralBandIndex() >= 0) {
                    this.createScalarAttribute(datasetID, "spectral_band_index", band.getSpectralBandIndex() + 1);
                    this.createScalarAttribute(datasetID, "solar_flux", band.getSolarFlux());
                    this.createScalarAttribute(datasetID, "bandwidth", band.getSpectralBandwidth());
                    this.createScalarAttribute(datasetID, "wavelength", band.getSpectralWavelength());
                }
                if (band.getFlagCoding() != null) {
                    this.createScalarAttribute(datasetID, "flag_coding", band.getFlagCoding().getName());
                }
                this.createScalarAttribute(datasetID, "CLASS", "IMAGE");
                this.createScalarAttribute(datasetID, "IMAGE_VERSION", 1.2f);
                if (band.isStxSet()) {
                    Stx stx = band.getStx();
                    this.createScalarAttribute(datasetID, "min_sample", stx.getMinimum());
                    this.createScalarAttribute(datasetID, "max_sample", stx.getMaximum());
                }
                if (band.getImageInfo() != null) {
                    ColorPaletteDef paletteDef = band.getImageInfo().getColorPaletteDef();
                    float[] minmax = new float[]{(float)paletteDef.getMinDisplaySample(), (float)paletteDef.getMaxDisplaySample()};
                    this.createArrayAttribute(datasetID, "IMAGE_MINMAXRANGE", minmax);
                }
            }
            catch (IOException e) {
                Debug.trace((String)("failed to create attribute: " + e.getMessage()));
            }
        }
        catch (HDF5Exception e) {
            this.closeH5D(datasetID);
            throw new ProductIOException(this.createErrorMessage(e));
        }
        finally {
            this.closeH5S(fileSpaceID);
            this.closeH5T(fileTypeID);
        }
        return datasetID;
    }

    private void createGroup(String path) throws IOException {
        int groupID = -1;
        try {
            groupID = H5.H5Gcreate((int)this._fileID, (String)path, (long)-1L);
        }
        catch (HDF5LibraryException e) {
            throw new ProductIOException(this.createErrorMessage((HDF5Exception)((Object)e)));
        }
        finally {
            this.closeH5G(groupID);
        }
    }

    private int createH5G(int locationID, String name) throws IOException {
        int groupID = -1;
        try {
            groupID = H5.H5Gcreate((int)locationID, (String)name, (long)-1L);
        }
        catch (HDF5LibraryException e) {
            throw new ProductIOException(this.createErrorMessage((HDF5Exception)((Object)e)));
        }
        return groupID;
    }

    private void closeH5T(int typeID) {
        if (typeID != -1) {
            try {
                H5.H5Tclose((int)typeID);
            }
            catch (HDF5LibraryException e) {
                Debug.trace((Throwable)e);
            }
        }
    }

    private void closeH5S(int spaceID) {
        if (spaceID != -1) {
            try {
                H5.H5Sclose((int)spaceID);
            }
            catch (HDF5LibraryException e) {
                Debug.trace((Throwable)e);
            }
        }
    }

    private void closeH5D(int datasetID) {
        if (datasetID != -1) {
            try {
                H5.H5Dclose((int)datasetID);
            }
            catch (HDF5LibraryException e) {
                Debug.trace((Throwable)e);
            }
        }
    }

    private void closeH5A(int attributeID) {
        if (attributeID != -1) {
            try {
                H5.H5Aclose((int)attributeID);
            }
            catch (HDF5LibraryException e) {
                Debug.trace((Throwable)e);
            }
        }
    }

    private void closeH5G(int groupID) {
        if (groupID != -1) {
            try {
                H5.H5Gclose((int)groupID);
            }
            catch (HDF5LibraryException e) {
                Debug.trace((Throwable)e);
            }
        }
    }

    private String createErrorMessage(HDF5Exception e) {
        return "HDF library error: " + e.getMessage();
    }
}

