/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.progress;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class LabelBarProgressMonitor
implements ProgressMonitor {
    public static final String stopCommand = "stop";
    public static final String updateCommand = "update";
    private final JProgressBar progressBar;
    private final JLabel messageLabel;
    private double currentWork;
    private double totalWork;
    private int totalWorkUI;
    private int currentWorkUI;
    private int lastWorkUI;
    private boolean cancelRequested;
    private final List<ProgressBarListener> listenerList = new ArrayList<ProgressBarListener>(1);

    public LabelBarProgressMonitor(JProgressBar progressBar) {
        this(progressBar, null);
    }

    public LabelBarProgressMonitor(JProgressBar progressBar, JLabel messageLabel) {
        this.progressBar = progressBar;
        this.messageLabel = messageLabel;
    }

    public void beginTask(String name, int totalWork) {
        Assert.notNull((Object)name, (String)"name");
        this.currentWork = 0.0;
        this.totalWork = totalWork;
        this.currentWorkUI = 0;
        this.lastWorkUI = 0;
        this.totalWorkUI = totalWork;
        if (this.messageLabel != null) {
            this.messageLabel.setText(name);
        }
        this.cancelRequested = false;
        this.setDescription(name);
        this.progressBar.setMaximum(totalWork);
    }

    public void done() {
        LabelBarProgressMonitor.runInUI(new Runnable(){

            @Override
            public void run() {
                if (LabelBarProgressMonitor.this.progressBar != null) {
                    LabelBarProgressMonitor.this.progressBar.setValue(LabelBarProgressMonitor.this.progressBar.getMaximum());
                    for (ProgressBarListener listener : LabelBarProgressMonitor.this.listenerList) {
                        listener.notifyProgressDone();
                    }
                }
                if (LabelBarProgressMonitor.this.messageLabel != null) {
                    LabelBarProgressMonitor.this.messageLabel.setText("");
                }
            }
        });
    }

    public void internalWorked(double work) {
        this.currentWork += work;
        this.currentWorkUI = (int)((double)this.totalWorkUI * this.currentWork / this.totalWork);
        if (this.currentWorkUI > this.lastWorkUI) {
            LabelBarProgressMonitor.runInUI(new Runnable(){

                @Override
                public void run() {
                    if (LabelBarProgressMonitor.this.progressBar != null) {
                        int progress = LabelBarProgressMonitor.this.progressBar.getMinimum() + LabelBarProgressMonitor.this.currentWorkUI;
                        LabelBarProgressMonitor.this.progressBar.setValue(progress);
                        for (ProgressBarListener listener : LabelBarProgressMonitor.this.listenerList) {
                            listener.notifyProgressStart();
                        }
                    }
                    LabelBarProgressMonitor.this.lastWorkUI = LabelBarProgressMonitor.this.currentWorkUI;
                }
            });
        }
    }

    public boolean isCanceled() {
        return this.cancelRequested;
    }

    public void setCanceled(boolean canceled) {
        this.cancelRequested = canceled;
        if (canceled) {
            this.done();
        }
    }

    public void setTaskName(final String name) {
        LabelBarProgressMonitor.runInUI(new Runnable(){

            @Override
            public void run() {
                if (LabelBarProgressMonitor.this.messageLabel != null) {
                    LabelBarProgressMonitor.this.messageLabel.setText(name);
                }
            }
        });
    }

    public void setSubTaskName(String name) {
        if (this.messageLabel != null) {
            this.messageLabel.setText(name);
        }
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    private static void runInUI(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    private void setDescription(String description) {
        if (this.messageLabel != null) {
            this.messageLabel.setText(description);
        }
    }

    public void addListener(ProgressBarListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(ProgressBarListener listener) {
        this.listenerList.remove(listener);
    }

    public static interface ProgressBarListener {
        public void notifyProgressStart();

        public void notifyProgressDone();
    }
}

