/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;

public class IOPanel {
    private final TargetProductSelector targetProductSelector;
    private final boolean useSourceSelector;
    private final List<SourceProductSelector> sourceProductSelectorList = new ArrayList<SourceProductSelector>(3);
    private String targetProductNameSuffix = "";

    IOPanel(AppContext theAppContext, JTabbedPane tabbedPane, boolean createSourceSelector) {
        this.useSourceSelector = createSourceSelector;
        this.targetProductSelector = new TargetProductSelector();
        String homeDirPath = SystemUtils.getUserHomeDir().getPath();
        String saveDir = SnapApp.getDefault().getPreferences().get("last_product_save_dir", homeDirPath);
        this.targetProductSelector.getModel().setProductDir(new File(saveDir));
        this.targetProductSelector.getOpenInAppCheckBox().setText("Open in " + theAppContext.getApplicationName());
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTablePadding(1, 1);
        JPanel ioParametersPanel = new JPanel((LayoutManager)tableLayout);
        if (this.useSourceSelector) {
            this.sourceProductSelectorList.add(new SourceProductSelector(theAppContext));
            for (SourceProductSelector selector : this.sourceProductSelectorList) {
                ioParametersPanel.add(selector.createDefaultPanel());
            }
            ioParametersPanel.add(tableLayout.createVerticalSpacer());
            this.sourceProductSelectorList.get(0).addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

                public void selectionChanged(SelectionChangeEvent event) {
                    Product selectedProduct = (Product)event.getSelection().getSelectedValue();
                    if (selectedProduct != null) {
                        TargetProductSelectorModel targetProductSelectorModel = IOPanel.this.targetProductSelector.getModel();
                        targetProductSelectorModel.setProductName(selectedProduct.getName() + IOPanel.this.getTargetProductNameSuffix());
                    }
                }
            });
        }
        ioParametersPanel.add(this.targetProductSelector.createDefaultPanel());
        if (this.useSourceSelector) {
            tabbedPane.add("I/O Parameters", ioParametersPanel);
        } else {
            tabbedPane.add("Target Product", ioParametersPanel);
        }
    }

    public void setTargetProductName(String name) {
        TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
        targetProductSelectorModel.setProductName(name + this.getTargetProductNameSuffix());
    }

    public void initProducts() {
        if (this.useSourceSelector) {
            for (SourceProductSelector sourceProductSelector : this.sourceProductSelectorList) {
                sourceProductSelector.initProducts();
            }
        }
    }

    public void releaseProducts() {
        if (!this.useSourceSelector) {
            for (SourceProductSelector sourceProductSelector : this.sourceProductSelectorList) {
                sourceProductSelector.releaseProducts();
            }
        }
    }

    public void onApply() {
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        SnapApp.getDefault().getPreferences().put("last_product_save_dir", productDir);
    }

    public Product getSelectedSourceProduct() {
        if (this.useSourceSelector) {
            return this.sourceProductSelectorList.get(0).getSelectedProduct();
        }
        return null;
    }

    public File getTargetFile() {
        return this.targetProductSelector.getModel().getProductFile();
    }

    public String getTargetFormat() {
        return this.targetProductSelector.getModel().getFormatName();
    }

    String getTargetProductNameSuffix() {
        return this.targetProductNameSuffix;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.targetProductNameSuffix = suffix;
    }

    public boolean isOpenInAppSelected() {
        return this.targetProductSelector.getModel().isOpenInAppSelected();
    }
}

