/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.engine_utilities.gpf.CommonReaders;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;

public class SourceUI
extends BaseOperatorUI {
    SourceProductSelector sourceProductSelector = null;
    private JComboBox<String> formatNameComboBox;
    private static final String FILE_PARAMETER = "file";
    private static final String FORMAT_PARAMETER = "formatName";
    private static final String ANY_FORMAT = "Any Format";

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.paramMap = parameterMap;
        this.sourceProductSelector = new SourceProductSelector(appContext);
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(3, 3);
        JPanel sourcePanel = this.sourceProductSelector.createDefaultPanel();
        this.formatNameComboBox = new JComboBox();
        this.formatNameComboBox.setToolTipText("Select 'Any Format' to let SNAP decide");
        JPanel formatPanel = new JPanel();
        formatPanel.add(new JLabel("Data Format:      "));
        formatPanel.add(this.formatNameComboBox);
        sourcePanel.add(formatPanel);
        JPanel ioParametersPanel = new JPanel((LayoutManager)tableLayout);
        ioParametersPanel.add(sourcePanel);
        ioParametersPanel.add(tableLayout.createVerticalSpacer());
        this.sourceProductSelector.initProducts();
        this.sourceProductSelector.addSelectionChangeListener((SelectionChangeListener)new SourceSelectionChangeListener());
        Product selectedProduct = this.sourceProductSelector.getSelectedProduct();
        if (selectedProduct != null) {
            this.updateFormatNamesCombo(selectedProduct.getFileLocation());
        }
        this.initParameters();
        return ioParametersPanel;
    }

    private void updateFormatNamesCombo(File file) {
        if (file == null) {
            return;
        }
        List<String> formatNameList = SourceUI.getFormatsForFile(file);
        this.formatNameComboBox.removeAllItems();
        for (String format : formatNameList) {
            this.formatNameComboBox.addItem(format);
        }
    }

    private static List<String> getFormatsForFile(File file) {
        Iterator allReaderPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        ArrayList<String> formatNameList = new ArrayList<String>();
        while (allReaderPlugIns.hasNext()) {
            String[] formatNames;
            ProductReaderPlugIn reader = (ProductReaderPlugIn)allReaderPlugIns.next();
            for (String formatName : formatNames = reader.getFormatNames()) {
                if (file != null && (reader.getDecodeQualification((Object)file) == DecodeQualification.UNABLE || formatNameList.contains(formatName))) continue;
                formatNameList.add(formatName);
            }
        }
        formatNameList.sort(String::compareTo);
        formatNameList.add(0, ANY_FORMAT);
        return formatNameList;
    }

    @Override
    public void initParameters() {
        Object formatValue;
        assert (this.paramMap != null);
        Object fileValue = this.paramMap.get(FILE_PARAMETER);
        if (fileValue != null) {
            try {
                Product[] openedProducts;
                File file = (File)fileValue;
                Product srcProduct = null;
                for (Product openedProduct : openedProducts = SnapApp.getDefault().getProductManager().getProducts()) {
                    if (!file.equals(openedProduct.getFileLocation())) continue;
                    srcProduct = openedProduct;
                    break;
                }
                if (srcProduct == null) {
                    srcProduct = CommonReaders.readProduct((File)file);
                }
                this.sourceProductSelector.setSelectedProduct(srcProduct);
            }
            catch (IOException file) {
                // empty catch block
            }
        }
        if ((formatValue = this.paramMap.get(FORMAT_PARAMETER)) != null) {
            this.formatNameComboBox.setSelectedItem(formatValue);
        } else {
            this.formatNameComboBox.setSelectedItem(ANY_FORMAT);
        }
    }

    @Override
    public UIValidation validateParameters() {
        if (this.sourceProductSelector != null && this.sourceProductSelector.getSelectedProduct() == null) {
            return new UIValidation(UIValidation.State.ERROR, "Source product not selected");
        }
        return new UIValidation(UIValidation.State.OK, "");
    }

    @Override
    public void updateParameters() {
        String selectedFormat;
        Product prod;
        if (this.sourceProductSelector != null && (prod = this.sourceProductSelector.getSelectedProduct()) != null && prod.getFileLocation() != null) {
            this.paramMap.put(FILE_PARAMETER, prod.getFileLocation());
        }
        if ((selectedFormat = (String)this.formatNameComboBox.getSelectedItem()) != null && selectedFormat.equals(ANY_FORMAT)) {
            selectedFormat = null;
        }
        this.paramMap.put(FORMAT_PARAMETER, selectedFormat);
    }

    public void setSourceProduct(Product product) {
        if (this.sourceProductSelector != null) {
            this.sourceProductSelector.setSelectedProduct(product);
            if (product != null && product.getFileLocation() != null) {
                this.paramMap.put(FILE_PARAMETER, product.getFileLocation());
            }
        }
    }

    private class SourceSelectionChangeListener
    implements SelectionChangeListener {
        private SourceSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangeEvent event) {
            Product product;
            Object selected = event.getSelection().getSelectedValue();
            if (selected != null && selected instanceof Product && (product = (Product)selected).getFileLocation() != null) {
                SourceUI.this.updateFormatNamesCombo(product.getFileLocation());
            }
        }

        public void selectionContextChanged(SelectionChangeEvent event) {
        }
    }
}

