/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.internal.ComboBoxAdapter;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.ui.AppContext;

public class ResamplingUI
extends BaseOperatorUI {
    private final String REFERENCE_BAND_TOOLTIP_TEXT = "<html>Set the reference band.<br/>All other bands will be resampled to match its size and resolution.</html>";
    private final String TARGET_WIDTH_AND_HEIGHT_TOOLTIP_TEXT = "<html>Set explicitly the width and height of the resampled product.<br/>This option is only available when all bands have the same offset.</html>";
    private final String TARGET_RESOLUTION_TOOLTIP_TEXT = "<html>Define the target resolution of the resampled product.<br/>This option is only available for products with a geocoding based on a cartographic map CRS.</html>";
    private final String UPSAMPLING_METHOD_PARAMETER_NAME = "upsamplingMethod";
    private final String DOWNSAMPLING_METHOD_PARAMETER_NAME = "downsamplingMethod";
    private final String FLAGDOWNSAMPLING_METHOD_PARAMETER_NAME = "flagDownsamplingMethod";
    private final String PYRAMID_LEVELS_PARAMETER_NAME = "resampleOnPyramidLevels";
    private ArrayList<String> listBands = new ArrayList();
    int lastProductWidth = 0;
    int lastProductHeight = 0;
    private String referenceBandParam = null;
    private JRadioButton referenceBandButton;
    private JRadioButton widthAndHeightButton;
    private JRadioButton resolutionButton;
    private ReferenceBandNameBoxPanel referenceBandNameBoxPanel;
    private TargetWidthAndHeightPanel targetWidthAndHeightPanel;
    private TargetResolutionPanel targetResolutionPanel;
    private JComboBox upsamplingCombo = new JComboBox();
    private JComboBox downsamplingCombo = new JComboBox();
    private JComboBox flagDownsamplingCombo = new JComboBox();
    private JCheckBox pyramidLevelCheckBox = new JCheckBox("Resample on pyramid levels (for faster imaging)");
    private BindingContext bindingContext;
    private OperatorDescriptor operatorDescriptor;
    private OperatorParameterSupport parameterSupport;
    private boolean updatingTargetWidthAndHeight = false;

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new IllegalArgumentException("No SPI found for operator name '" + operatorName + "'");
        }
        this.operatorDescriptor = operatorSpi.getOperatorDescriptor();
        this.parameterSupport = new OperatorParameterSupport(this.operatorDescriptor);
        PropertySet propertySet = this.parameterSupport.getPropertySet();
        this.bindingContext = new BindingContext(propertySet);
        if (this.sourceProducts != null) {
            for (Band band : this.sourceProducts[0].getBands()) {
                this.listBands.add(band.getName());
            }
        }
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        return new JScrollPane(panel);
    }

    @Override
    public void initParameters() {
        String flagDownParam;
        String downsamplingParam;
        Integer targetWidthParam = (Integer)this.paramMap.get("targetWidth");
        Integer targetHeightParam = (Integer)this.paramMap.get("targetHeight");
        Integer targetResolutionParam = (Integer)this.paramMap.get("targetResolution");
        String referenceBandParamAux = (String)this.paramMap.get("referenceBand");
        if (referenceBandParamAux == null) {
            referenceBandParamAux = (String)this.paramMap.get("referenceBandName");
        }
        this.referenceBandParam = referenceBandParamAux;
        String upsamplingParam = (String)this.paramMap.get("upsampling");
        if (upsamplingParam == null) {
            upsamplingParam = (String)this.paramMap.get("upsamplingMethod");
        }
        if ((downsamplingParam = (String)this.paramMap.get("downsampling")) == null) {
            downsamplingParam = (String)this.paramMap.get("downsamplingMethod");
        }
        if ((flagDownParam = (String)this.paramMap.get("flagDownsampling")) == null) {
            flagDownParam = (String)this.paramMap.get("flagDownsamplingMethod");
        }
        Boolean pyramidParam = (Boolean)this.paramMap.get("resampleOnPyramidLevels");
        if (targetWidthParam != null && targetHeightParam != null) {
            this.widthAndHeightButton.setSelected(true);
            this.referenceBandButton.setSelected(false);
            this.resolutionButton.setSelected(false);
            this.targetResolutionPanel.setEnabled(false);
            this.targetWidthAndHeightPanel.setEnabled(true);
            this.referenceBandNameBoxPanel.setEnabled(false);
            this.targetWidthAndHeightPanel.widthSpinner.setValue(targetWidthParam);
            this.targetWidthAndHeightPanel.heightSpinner.setValue(targetHeightParam);
        } else if (targetResolutionParam != null) {
            this.widthAndHeightButton.setSelected(false);
            this.referenceBandButton.setSelected(false);
            this.resolutionButton.setSelected(true);
            this.targetResolutionPanel.setEnabled(true);
            this.targetWidthAndHeightPanel.setEnabled(false);
            this.referenceBandNameBoxPanel.setEnabled(false);
            this.targetResolutionPanel.resolutionSpinner.setValue(targetResolutionParam);
        } else if (this.referenceBandParam != null) {
            this.widthAndHeightButton.setSelected(false);
            this.referenceBandButton.setSelected(true);
            this.resolutionButton.setSelected(false);
            this.targetResolutionPanel.setEnabled(false);
            this.targetWidthAndHeightPanel.setEnabled(false);
            this.referenceBandNameBoxPanel.setEnabled(true);
            this.referenceBandNameBoxPanel.referenceBandNameBox.setSelectedItem(this.referenceBandParam);
        } else {
            this.widthAndHeightButton.setSelected(false);
            this.referenceBandButton.setSelected(false);
            this.resolutionButton.setSelected(true);
            this.targetResolutionPanel.setEnabled(true);
            this.targetWidthAndHeightPanel.setEnabled(false);
            this.referenceBandNameBoxPanel.setEnabled(false);
            this.targetResolutionPanel.resolutionSpinner.setValue(100);
        }
        this.upsamplingCombo.setSelectedItem(upsamplingParam);
        this.downsamplingCombo.setSelectedItem(downsamplingParam);
        this.flagDownsamplingCombo.setSelectedItem(flagDownParam);
        this.pyramidLevelCheckBox.setSelected(pyramidParam);
        if (this.hasSourceProducts()) {
            this.reactToSourceProductChange(this.sourceProducts[0]);
            this.referenceBandButton.setEnabled(true);
        }
    }

    @Override
    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    @Override
    public void updateParameters() {
        this.paramMap.clear();
        if (this.referenceBandButton.isSelected()) {
            if (this.referenceBandNameBoxPanel.referenceBandNameBox.getSelectedItem() != null) {
                this.referenceBandParam = this.referenceBandNameBoxPanel.referenceBandNameBox.getSelectedItem().toString();
            }
            this.paramMap.put("referenceBandName", this.referenceBandParam);
            this.paramMap.remove("targetResolution");
            this.paramMap.remove("targetWidth");
            this.paramMap.remove("targetHeight");
        } else if (this.widthAndHeightButton.isSelected()) {
            this.paramMap.put("targetWidth", this.targetWidthAndHeightPanel.widthSpinner.getValue());
            this.paramMap.put("targetHeight", this.targetWidthAndHeightPanel.heightSpinner.getValue());
            this.paramMap.remove("targetResolution");
            this.paramMap.remove("referenceBandName");
        } else if (this.resolutionButton.isSelected()) {
            this.paramMap.put("targetResolution", this.targetResolutionPanel.resolutionSpinner.getValue());
            this.paramMap.remove("referenceBandName");
            this.paramMap.remove("targetWidth");
            this.paramMap.remove("targetHeight");
        }
        this.paramMap.put("upsamplingMethod", this.upsamplingCombo.getSelectedItem());
        this.paramMap.put("downsamplingMethod", this.downsamplingCombo.getSelectedItem());
        this.paramMap.put("flagDownsamplingMethod", this.flagDownsamplingCombo.getSelectedItem());
        this.paramMap.put("resampleOnPyramidLevels", this.pyramidLevelCheckBox.isSelected());
    }

    private JComponent createPanel() {
        PropertySet propertySet = this.bindingContext.getPropertySet();
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTablePadding(4, 4);
        GridLayout defineTargetResolutionPanelLayout = new GridLayout(3, 2);
        defineTargetResolutionPanelLayout.setVgap(4);
        JPanel defineTargetSizePanel = new JPanel(defineTargetResolutionPanelLayout);
        defineTargetSizePanel.setBorder(BorderFactory.createTitledBorder("Define size of resampled product"));
        ButtonGroup targetSizeButtonGroup = new ButtonGroup();
        this.referenceBandButton = new JRadioButton("By reference band from source product:");
        this.referenceBandButton.setToolTipText("<html>Set the reference band.<br/>All other bands will be resampled to match its size and resolution.</html>");
        this.widthAndHeightButton = new JRadioButton("By target width and height:");
        this.widthAndHeightButton.setToolTipText("<html>Set explicitly the width and height of the resampled product.<br/>This option is only available when all bands have the same offset.</html>");
        this.resolutionButton = new JRadioButton("By pixel resolution (in m):");
        this.resolutionButton.setToolTipText("<html>Define the target resolution of the resampled product.<br/>This option is only available for products with a geocoding based on a cartographic map CRS.</html>");
        targetSizeButtonGroup.add(this.referenceBandButton);
        targetSizeButtonGroup.add(this.widthAndHeightButton);
        targetSizeButtonGroup.add(this.resolutionButton);
        defineTargetSizePanel.add(this.referenceBandButton);
        this.referenceBandNameBoxPanel = new ReferenceBandNameBoxPanel();
        defineTargetSizePanel.add(this.referenceBandNameBoxPanel);
        defineTargetSizePanel.add(this.widthAndHeightButton);
        this.targetWidthAndHeightPanel = new TargetWidthAndHeightPanel();
        defineTargetSizePanel.add(this.targetWidthAndHeightPanel);
        defineTargetSizePanel.add(this.resolutionButton);
        this.targetResolutionPanel = new TargetResolutionPanel();
        defineTargetSizePanel.add(this.targetResolutionPanel);
        this.referenceBandButton.addActionListener(e -> {
            if (this.referenceBandButton.isSelected()) {
                this.referenceBandNameBoxPanel.setEnabled(true);
                this.targetWidthAndHeightPanel.setEnabled(false);
                this.targetResolutionPanel.setEnabled(false);
            }
        });
        this.widthAndHeightButton.addActionListener(e -> {
            if (this.widthAndHeightButton.isSelected()) {
                this.referenceBandNameBoxPanel.setEnabled(false);
                this.targetWidthAndHeightPanel.setEnabled(true);
                this.targetResolutionPanel.setEnabled(false);
            }
        });
        this.resolutionButton.addActionListener(e -> {
            if (this.resolutionButton.isSelected()) {
                this.referenceBandNameBoxPanel.setEnabled(false);
                this.targetWidthAndHeightPanel.setEnabled(false);
                this.targetResolutionPanel.setEnabled(true);
            }
        });
        this.referenceBandButton.setSelected(true);
        JPanel upsamplingMethodPanel = new JPanel(new GridLayout(1, 2));
        PropertyDescriptor descriptorUp = propertySet.getProperty("upsamplingMethod").getDescriptor();
        JLabel upsamplingMethodLabel = new JLabel(descriptorUp.getAttribute("displayName").toString());
        upsamplingMethodLabel.setToolTipText(descriptorUp.getAttribute("description").toString());
        upsamplingMethodPanel.add(upsamplingMethodLabel);
        ComboBoxAdapter adapterUp = new ComboBoxAdapter(this.upsamplingCombo);
        this.bindingContext.bind(descriptorUp.getName(), (ComponentAdapter)adapterUp);
        upsamplingMethodPanel.add(this.upsamplingCombo);
        JPanel downsamplingMethodPanel = new JPanel(new GridLayout(1, 2));
        PropertyDescriptor descriptorDown = propertySet.getProperty("downsamplingMethod").getDescriptor();
        JLabel downsamplingMethodLabel = new JLabel(descriptorDown.getAttribute("displayName").toString());
        downsamplingMethodPanel.setToolTipText(descriptorDown.getAttribute("description").toString());
        downsamplingMethodPanel.add(downsamplingMethodLabel);
        ComboBoxAdapter adapterDown = new ComboBoxAdapter(this.downsamplingCombo);
        this.bindingContext.bind(descriptorDown.getName(), (ComponentAdapter)adapterDown);
        downsamplingMethodPanel.add(this.downsamplingCombo);
        JPanel flagDownsamplingMethodPanel = new JPanel(new GridLayout(1, 2));
        PropertyDescriptor descriptorFlag = propertySet.getProperty("flagDownsamplingMethod").getDescriptor();
        JLabel flagDownsamplingMethodLabel = new JLabel(descriptorFlag.getAttribute("displayName").toString());
        flagDownsamplingMethodPanel.setToolTipText(descriptorFlag.getAttribute("description").toString());
        flagDownsamplingMethodPanel.add(flagDownsamplingMethodLabel);
        ComboBoxAdapter adapterFlag = new ComboBoxAdapter(this.flagDownsamplingCombo);
        this.bindingContext.bind(descriptorFlag.getName(), (ComponentAdapter)adapterFlag);
        flagDownsamplingMethodPanel.add(this.flagDownsamplingCombo);
        JPanel resampleOnPyramidLevelsPanel = new JPanel(new GridLayout(1, 2));
        PropertyDescriptor descriptorResampleOnPyramidLevels = propertySet.getProperty("resampleOnPyramidLevels").getDescriptor();
        this.pyramidLevelCheckBox.setSelected((Boolean)descriptorResampleOnPyramidLevels.getAttribute("defaultValue"));
        this.pyramidLevelCheckBox.setText(descriptorResampleOnPyramidLevels.getAttribute("displayName").toString());
        this.pyramidLevelCheckBox.setToolTipText(descriptorResampleOnPyramidLevels.getAttribute("description").toString());
        resampleOnPyramidLevelsPanel.add(this.pyramidLevelCheckBox);
        JPanel parametersPanel = new JPanel((LayoutManager)tableLayout);
        parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        parametersPanel.add(defineTargetSizePanel);
        parametersPanel.add(upsamplingMethodPanel);
        parametersPanel.add(downsamplingMethodPanel);
        parametersPanel.add(flagDownsamplingMethodPanel);
        parametersPanel.add(resampleOnPyramidLevelsPanel);
        parametersPanel.add(tableLayout.createVerticalSpacer());
        return parametersPanel;
    }

    private void reactToSourceProductChange(Product product) {
        if (this.hasChangedProductListBand(product)) {
            this.updateListBands(product);
            this.referenceBandNameBoxPanel.reactToSourceProductChange(product);
        }
        if (this.hasChangedProductSize(product)) {
            this.updateProductSize(product);
            this.targetWidthAndHeightPanel.reactToSourceProductChange(product);
            this.targetResolutionPanel.reactToSourceProductChange(product);
        }
        if (product != null) {
            this.referenceBandButton.setEnabled(product.getBandNames().length > 0);
            ProductNodeGroup productBands = product.getBandGroup();
            ProductNodeGroup productTiePointGrids = product.getTiePointGridGroup();
            double xOffset = Double.NaN;
            double yOffset = Double.NaN;
            if (productBands.getNodeCount() > 0) {
                xOffset = ((Band)productBands.get(0)).getImageToModelTransform().getTranslateX();
                yOffset = ((Band)productBands.get(0)).getImageToModelTransform().getTranslateY();
            } else if (productTiePointGrids.getNodeCount() > 0) {
                xOffset = ((TiePointGrid)productTiePointGrids.get(0)).getImageToModelTransform().getTranslateX();
                yOffset = ((TiePointGrid)productTiePointGrids.get(0)).getImageToModelTransform().getTranslateY();
            }
            boolean allowToSetWidthAndHeight = true;
            if (!Double.isNaN(xOffset) && !Double.isNaN(yOffset)) {
                allowToSetWidthAndHeight = this.allOffsetsAreEqual(productBands, xOffset, yOffset) && this.allOffsetsAreEqual(productTiePointGrids, xOffset, yOffset);
            }
            this.widthAndHeightButton.setEnabled(allowToSetWidthAndHeight);
            GeoCoding sceneGeoCoding = product.getSceneGeoCoding();
            boolean resolutionEnable = sceneGeoCoding != null && sceneGeoCoding instanceof CrsGeoCoding;
            this.resolutionButton.setEnabled(resolutionEnable);
            if (this.resolutionButton.isSelected() && !resolutionEnable) {
                this.targetResolutionPanel.setEnabled(false);
                this.targetWidthAndHeightPanel.setEnabled(true);
                this.widthAndHeightButton.setSelected(true);
            }
        }
    }

    private RasterDataNode getAnyRasterDataNode(Product product) {
        RasterDataNode node = null;
        if (product != null) {
            ProductNodeGroup bandGroup = product.getBandGroup();
            if (bandGroup.getNodeCount() == 0) {
                ProductNodeGroup tiePointGridGroup = product.getTiePointGridGroup();
                if (tiePointGridGroup.getNodeCount() > 0) {
                    node = (RasterDataNode)tiePointGridGroup.get(0);
                }
            } else {
                node = (RasterDataNode)bandGroup.get(0);
            }
        }
        return node;
    }

    private boolean allOffsetsAreEqual(ProductNodeGroup productNodeGroup, double xOffset, double yOffset) {
        for (int i = 0; i < productNodeGroup.getNodeCount(); ++i) {
            double nodeXOffset = ((RasterDataNode)productNodeGroup.get(i)).getImageToModelTransform().getTranslateX();
            double nodeYOffset = ((RasterDataNode)productNodeGroup.get(i)).getImageToModelTransform().getTranslateY();
            if (!(Math.abs(nodeXOffset - xOffset) > 1.0E-8) && !(Math.abs(nodeYOffset - yOffset) > 1.0E-8)) continue;
            return false;
        }
        return true;
    }

    private boolean hasChangedProductSize(Product product) {
        return product.getSceneRasterWidth() != this.lastProductWidth || product.getSceneRasterHeight() != this.lastProductHeight;
    }

    private boolean hasChangedProductListBand(Product product) {
        if (product.getBands().length != this.listBands.size()) {
            return true;
        }
        for (String bandName : this.listBands) {
            if (product.getBand(bandName) != null) continue;
            return true;
        }
        return false;
    }

    private void updateListBands(Product product) {
        this.listBands.clear();
        if (product == null) {
            return;
        }
        for (Band band : product.getBands()) {
            this.listBands.add(band.getName());
        }
    }

    private void updateProductSize(Product product) {
        if (product == null) {
            this.lastProductWidth = 0;
            this.lastProductHeight = 0;
            return;
        }
        this.lastProductWidth = product.getSceneRasterWidth();
        this.lastProductHeight = product.getSceneRasterHeight();
    }

    private class ReferenceBandNameBoxPanel
    extends JPanel {
        private JComboBox<String> referenceBandNameBox;
        private JLabel referenceBandTargetWidthLabel;
        private JLabel referenceBandTargetHeightLabel;
        private final JLabel referenceBandTargetHeightNameLabel;
        private final JLabel referenceBandTargetWidthNameLabel;

        ReferenceBandNameBoxPanel() {
            this.setToolTipText("<html>Set the reference band.<br/>All other bands will be resampled to match its size and resolution.</html>");
            this.referenceBandNameBox = new JComboBox();
            this.referenceBandNameBox.addActionListener(e -> this.updateReferenceBandTargetWidthAndHeight());
            GridLayout referenceBandNameBoxPanelLayout = new GridLayout(3, 1);
            referenceBandNameBoxPanelLayout.setVgap(2);
            this.setLayout(referenceBandNameBoxPanelLayout);
            this.add(this.referenceBandNameBox);
            JPanel referenceBandNameTargetWidthPanel = new JPanel(new GridLayout(1, 2));
            this.referenceBandTargetWidthNameLabel = new JLabel("Resulting target width: ");
            referenceBandNameTargetWidthPanel.add(this.referenceBandTargetWidthNameLabel);
            this.referenceBandTargetWidthLabel = new JLabel();
            referenceBandNameTargetWidthPanel.add(this.referenceBandTargetWidthLabel);
            JPanel referenceBandNameTargetHeightPanel = new JPanel(new GridLayout(1, 2));
            this.referenceBandTargetHeightNameLabel = new JLabel("Resulting target height: ");
            referenceBandNameTargetHeightPanel.add(this.referenceBandTargetHeightNameLabel);
            this.referenceBandTargetHeightLabel = new JLabel();
            referenceBandNameTargetHeightPanel.add(this.referenceBandTargetHeightLabel);
            this.add(referenceBandNameTargetWidthPanel);
            this.add(referenceBandNameTargetHeightPanel);
            this.referenceBandNameBox.addActionListener(e -> this.updateReferenceBandName());
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.referenceBandNameBox.setEnabled(enabled);
            this.referenceBandTargetWidthLabel.setEnabled(enabled);
            this.referenceBandTargetHeightLabel.setEnabled(enabled);
            this.referenceBandTargetWidthNameLabel.setEnabled(enabled);
            this.referenceBandTargetHeightNameLabel.setEnabled(enabled);
            if (enabled) {
                this.updateReferenceBandName();
            }
        }

        private void updateReferenceBandTargetWidthAndHeight() {
            if (this.referenceBandNameBox.getSelectedItem() != null) {
                String bandName = this.referenceBandNameBox.getSelectedItem().toString();
                Band band = ResamplingUI.this.sourceProducts[0].getBand(bandName);
                this.referenceBandTargetWidthLabel.setText("" + band.getRasterWidth());
                this.referenceBandTargetHeightLabel.setText("" + band.getRasterHeight());
            }
        }

        private void updateReferenceBandName() {
        }

        private void reactToSourceProductChange(Product product) {
            Object selected = this.referenceBandNameBox.getSelectedItem();
            this.referenceBandNameBox.removeAllItems();
            String[] bandNames = new String[]{};
            if (product != null) {
                bandNames = product.getBandNames();
            }
            this.referenceBandNameBox.setModel(new DefaultComboBoxModel<String>(bandNames));
            this.referenceBandNameBox.setEditable(false);
            if (selected != null) {
                this.referenceBandNameBox.setSelectedItem(selected);
            }
            this.updateReferenceBandTargetWidthAndHeight();
        }
    }

    private class TargetWidthAndHeightPanel
    extends JPanel {
        private JSpinner widthSpinner;
        private JSpinner heightSpinner;
        private double targetWidthHeightRatio;
        private final JLabel targetWidthNameLabel;
        private final JLabel targetHeightNameLabel;
        private final JLabel widthHeightRatioNameLabel;
        private JLabel widthHeightRatioLabel;

        TargetWidthAndHeightPanel() {
            this.setToolTipText("<html>Set explicitly the width and height of the resampled product.<br/>This option is only available when all bands have the same offset.</html>");
            this.targetWidthHeightRatio = 1.0;
            GridLayout layout = new GridLayout(3, 2);
            layout.setVgap(2);
            this.setLayout(layout);
            this.targetWidthNameLabel = new JLabel("Target width:");
            this.targetWidthNameLabel.setEnabled(false);
            this.add(this.targetWidthNameLabel);
            this.widthSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 1000000, 1));
            this.widthSpinner.setEnabled(false);
            this.add(this.widthSpinner);
            this.targetHeightNameLabel = new JLabel("Target height:");
            this.targetHeightNameLabel.setEnabled(false);
            this.add(this.targetHeightNameLabel);
            this.heightSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 1000000, 1));
            this.heightSpinner.setEnabled(false);
            this.add(this.heightSpinner);
            this.widthHeightRatioNameLabel = new JLabel("Width / height ratio: ");
            this.widthHeightRatioNameLabel.setEnabled(false);
            this.add(this.widthHeightRatioNameLabel);
            this.widthHeightRatioLabel = new JLabel();
            this.widthHeightRatioLabel.setEnabled(false);
            this.add(this.widthHeightRatioLabel);
            this.widthSpinner.addChangeListener(e -> this.updateTargetWidth());
            this.heightSpinner.addChangeListener(e -> this.updateTargetHeight());
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.widthSpinner.setEnabled(enabled);
            this.heightSpinner.setEnabled(enabled);
            this.widthHeightRatioLabel.setEnabled(enabled);
            this.targetWidthNameLabel.setEnabled(enabled);
            this.targetHeightNameLabel.setEnabled(enabled);
            this.widthHeightRatioNameLabel.setEnabled(enabled);
        }

        private void updateTargetWidth() {
            if (!ResamplingUI.this.updatingTargetWidthAndHeight) {
                ResamplingUI.this.updatingTargetWidthAndHeight = true;
                int targetWidth = Integer.parseInt(this.widthSpinner.getValue().toString());
                int targetHeight = (int)((double)targetWidth / this.targetWidthHeightRatio);
                this.heightSpinner.setValue(targetHeight);
                ResamplingUI.this.updatingTargetWidthAndHeight = false;
            }
        }

        private void updateTargetHeight() {
            if (!ResamplingUI.this.updatingTargetWidthAndHeight) {
                ResamplingUI.this.updatingTargetWidthAndHeight = true;
                int targetHeight = Integer.parseInt(this.heightSpinner.getValue().toString());
                int targetWidth = (int)((double)targetHeight * this.targetWidthHeightRatio);
                this.widthSpinner.setValue(targetWidth);
                ResamplingUI.this.updatingTargetWidthAndHeight = false;
            }
        }

        private void reactToSourceProductChange(Product product) {
            if (!(product == null || ResamplingUI.this.paramMap.containsKey("targetWidth") && ResamplingUI.this.paramMap.containsKey("targetHeight"))) {
                this.targetWidthHeightRatio = (double)product.getSceneRasterWidth() / (double)product.getSceneRasterHeight();
                this.widthSpinner.setValue(product.getSceneRasterWidth());
                this.heightSpinner.setValue(product.getSceneRasterHeight());
            } else if (product == null) {
                this.targetWidthHeightRatio = 1.0;
                this.widthSpinner.setValue(0);
                this.heightSpinner.setValue(0);
            }
            this.widthHeightRatioLabel.setText(String.format("%.5f", this.targetWidthHeightRatio));
        }
    }

    private class TargetResolutionPanel
    extends JPanel {
        private JSpinner resolutionSpinner;
        private JLabel targetResolutionTargetWidthLabel;
        private JLabel targetResolutionTargetHeightLabel;
        private final JLabel targetResolutionTargetWidthNameLabel;
        private final JLabel targetResolutionNameTargetHeightLabel;

        TargetResolutionPanel() {
            this.setToolTipText("<html>Define the target resolution of the resampled product.<br/>This option is only available for products with a geocoding based on a cartographic map CRS.</html>");
            this.resolutionSpinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            this.resolutionSpinner.setEnabled(false);
            this.resolutionSpinner.addChangeListener(e -> this.updateTargetResolutionTargetWidthAndHeight());
            GridLayout layout = new GridLayout(3, 1);
            layout.setVgap(2);
            this.setLayout(layout);
            JPanel targetResolutionTargetWidthPanel = new JPanel(new GridLayout(1, 2));
            this.targetResolutionTargetWidthNameLabel = new JLabel("Resulting target width: ");
            this.targetResolutionTargetWidthNameLabel.setEnabled(false);
            targetResolutionTargetWidthPanel.add(this.targetResolutionTargetWidthNameLabel);
            this.targetResolutionTargetWidthLabel = new JLabel();
            this.targetResolutionTargetWidthLabel.setEnabled(false);
            targetResolutionTargetWidthPanel.add(this.targetResolutionTargetWidthLabel);
            JPanel targetResolutionTargetHeightPanel = new JPanel(new GridLayout(1, 2));
            this.targetResolutionNameTargetHeightLabel = new JLabel("Resulting target height: ");
            this.targetResolutionNameTargetHeightLabel.setEnabled(false);
            targetResolutionTargetHeightPanel.add(this.targetResolutionNameTargetHeightLabel);
            this.targetResolutionTargetHeightLabel = new JLabel();
            this.targetResolutionTargetHeightLabel.setEnabled(false);
            targetResolutionTargetHeightPanel.add(this.targetResolutionTargetHeightLabel);
            this.add(this.resolutionSpinner);
            this.add(targetResolutionTargetWidthPanel);
            this.add(targetResolutionTargetHeightPanel);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.resolutionSpinner.setEnabled(enabled);
            this.targetResolutionTargetWidthLabel.setEnabled(enabled);
            this.targetResolutionTargetHeightLabel.setEnabled(enabled);
            this.targetResolutionTargetWidthNameLabel.setEnabled(enabled);
            this.targetResolutionNameTargetHeightLabel.setEnabled(enabled);
            if (enabled) {
                this.updateTargetResolutionTargetWidthAndHeight();
            }
        }

        private void updateTargetResolutionTargetWidthAndHeight() {
            if (ResamplingUI.this.hasSourceProducts()) {
                Product selectedProduct = ResamplingUI.this.sourceProducts[0];
                RasterDataNode node = ResamplingUI.this.getAnyRasterDataNode(selectedProduct);
                int targetWidth = 0;
                int targetHeight = 0;
                if (node != null) {
                    int resolution = Integer.parseInt(this.resolutionSpinner.getValue().toString());
                    double nodeResolution = node.getImageToModelTransform().getScaleX();
                    targetWidth = (int)((double)node.getRasterWidth() * (nodeResolution / (double)resolution));
                    targetHeight = (int)((double)node.getRasterHeight() * (nodeResolution / (double)resolution));
                }
                this.targetResolutionTargetWidthLabel.setText("" + targetWidth);
                this.targetResolutionTargetHeightLabel.setText("" + targetHeight);
            }
        }

        private void reactToSourceProductChange(Product product) {
            if (product != null && !ResamplingUI.this.paramMap.containsKey("targetResolution")) {
                this.resolutionSpinner.setValue(this.determineResolutionFromProduct(product));
            } else if (product == null) {
                this.resolutionSpinner.setValue(0);
            }
        }

        private int determineResolutionFromProduct(Product product) {
            RasterDataNode node = ResamplingUI.this.getAnyRasterDataNode(product);
            if (node != null) {
                return (int)node.getImageToModelTransform().getScaleX();
            }
            return 1;
        }
    }
}

