/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuiler.rcp.dialogs.support;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import java.awt.Point;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.core.gpf.graph.NodeSource;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGraphNode {
    private Node node;
    private GraphNode graphNode;

    @Before
    public void setUp() throws Exception {
        this.node = new Node("id", "readOp");
        XppDomElement parameters = new XppDomElement("parameters");
        this.node.setConfiguration((DomElement)parameters);
        this.graphNode = new GraphNode(this.node);
    }

    @Test
    public void testPosition() {
        Point p1 = new Point(1, 2);
        this.graphNode.setPos(p1);
        Point p2 = this.graphNode.getPos();
        Assert.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void testNode() {
        Assert.assertEquals((Object)this.node, (Object)this.graphNode.getNode());
        Assert.assertEquals((Object)this.node.getId(), (Object)this.graphNode.getID());
        Assert.assertEquals((Object)this.node.getOperatorName(), (Object)this.graphNode.getOperatorName());
    }

    @Test
    public void testSourceConnection() {
        Node sourceNode = new Node("sourceID", "testSourceNodeOp");
        XppDomElement parameters = new XppDomElement("parameters");
        sourceNode.setConfiguration((DomElement)parameters);
        GraphNode sourceGraphNode = new GraphNode(sourceNode);
        this.graphNode.connectOperatorSource(sourceGraphNode.getID());
        NodeSource ns = this.node.getSource(0);
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)ns.getSourceNodeId(), (Object)sourceNode.getId());
        this.graphNode.disconnectOperatorSources(sourceGraphNode.getID());
        NodeSource[] nsList = this.node.getSources();
        Assert.assertEquals((long)nsList.length, (long)0L);
    }
}

