/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuiler.rcp.dialogs.support;

import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphExecuter;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGraphExecuter
implements Observer {
    private GraphExecuter graphEx;
    private String updateValue = "";

    @Before
    public void setUp() throws Exception {
        this.graphEx = new GraphExecuter();
        this.graphEx.addObserver((Observer)this);
    }

    @Test
    public void testGetOperators() {
        Set opList = this.graphEx.GetOperatorList();
        Assert.assertTrue((!opList.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testAddOperator() {
        this.updateValue = "";
        this.graphEx.addOperator("testOp");
        GraphNode[] nodeList = this.graphEx.GetGraphNodes();
        Assert.assertEquals((long)1L, (long)nodeList.length);
        Assert.assertEquals((Object)this.updateValue, (Object)"Add");
    }

    @Test
    public void testClear() {
        this.graphEx.addOperator("testOp");
        GraphNode[] nodeList = this.graphEx.GetGraphNodes();
        Assert.assertEquals((long)1L, (long)nodeList.length);
        this.graphEx.ClearGraph();
        Assert.assertEquals((long)0L, (long)this.graphEx.GetGraphNodes().length);
    }

    @Test
    public void testRemoveOperator() {
        GraphNode node = this.graphEx.addOperator("testOp");
        GraphNode[] nodeList = this.graphEx.GetGraphNodes();
        Assert.assertEquals((long)1L, (long)nodeList.length);
        this.updateValue = "";
        this.graphEx.removeOperator(node);
        Assert.assertEquals((long)0L, (long)this.graphEx.GetGraphNodes().length);
        Assert.assertEquals((Object)this.updateValue, (Object)"Remove");
    }

    @Test
    public void testFindGraphNode() {
        GraphNode lostNode = this.graphEx.addOperator("lostOp");
        GraphNode foundNode = this.graphEx.getGraphNodeList().findGraphNode(lostNode.getID());
        Assert.assertTrue((boolean)foundNode.equals(lostNode));
        this.graphEx.ClearGraph();
    }

    @Test
    public void testSetSelected() {
        GraphNode node = this.graphEx.addOperator("testOp");
        this.updateValue = "";
        this.graphEx.setSelectedNode(node);
        Assert.assertEquals((Object)this.updateValue, (Object)"Selected");
        this.graphEx.ClearGraph();
    }

    @Test
    public void testCreateGraph() throws GraphException {
        GraphNode nodeA = this.graphEx.addOperator("testOp");
        GraphNode nodeB = this.graphEx.addOperator("testOp");
        nodeB.connectOperatorSource(nodeA.getID());
    }

    @Override
    public void update(Observable subject, Object data) {
        GraphExecuter.GraphEvent event = (GraphExecuter.GraphEvent)data;
        GraphNode node = (GraphNode)event.getData();
        String opID = node.getNode().getId();
        if (event.getEventType() == GraphExecuter.events.ADD_EVENT) {
            this.updateValue = "Add";
        } else if (event.getEventType() == GraphExecuter.events.REMOVE_EVENT) {
            this.updateValue = "Remove";
        } else if (event.getEventType() == GraphExecuter.events.SELECT_EVENT) {
            this.updateValue = "Selected";
        }
    }
}

