/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.progress;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;

public class StatusProgressPanel
extends JPanel
implements StatusProgressMonitor.Listener {
    private final StatusProgressMonitor pm;
    private final ProgressHandle p;
    private boolean active;

    public StatusProgressPanel(StatusProgressMonitor pm) {
        this.pm = pm;
        if (pm != null) {
            this.p = ProgressHandleFactory.createHandle((String)pm.getName());
            this.p.start(100);
            this.p.switchToDeterminate(100);
            this.active = true;
            pm.addListener((StatusProgressMonitor.Listener)this);
        } else {
            this.p = null;
            this.active = false;
        }
    }

    private void update() {
        this.runInUI(new Runnable(){

            @Override
            public void run() {
                if (StatusProgressPanel.this.active) {
                    StatusProgressPanel.this.p.progress(StatusProgressPanel.this.pm.getText(), StatusProgressPanel.this.pm.getPercentComplete());
                }
            }
        });
    }

    private void runInUI(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    public void notifyMsg(StatusProgressMonitor.Notification msg) {
        if (msg.equals((Object)StatusProgressMonitor.Notification.UPDATE)) {
            this.update();
        } else if (msg.equals((Object)StatusProgressMonitor.Notification.DONE)) {
            this.active = false;
            this.p.finish();
        }
    }
}

