/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.ReadOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.Node;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphExecuter;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNodeList;

public class ProductSetUIHandler {
    private final Graph graph;
    private final GraphNodeList graphNodeList;
    private final GraphNode[] savedProductSetList;

    public ProductSetUIHandler(Graph graph, GraphNodeList graphNodeList) {
        this.graph = graph;
        this.graphNodeList = graphNodeList;
        this.savedProductSetList = this.replaceProductSetReaders();
    }

    private GraphNode[] replaceProductSetReaders() {
        ProductSetData[] productSetDataList = this.findProductSets("ProductSet-Reader");
        ArrayList<GraphNode> savedProductSetList = new ArrayList<GraphNode>();
        int cnt = 0;
        for (ProductSetData psData : productSetDataList) {
            GraphNode sourceNode = this.graphNodeList.findGraphNode(psData.nodeID);
            for (String filePath : psData.fileList) {
                this.replaceProductSetWithReaders(sourceNode, "inserted--" + sourceNode.getID() + "--" + cnt++, filePath);
            }
            if (psData.fileList.isEmpty()) continue;
            this.removeNode(sourceNode);
            savedProductSetList.add(sourceNode);
        }
        return savedProductSetList.toArray(new GraphNode[savedProductSetList.size()]);
    }

    private ProductSetData[] findProductSets(String readerName) {
        ArrayList<ProductSetData> productSetDataList = new ArrayList<ProductSetData>();
        for (Node n : this.graph.getNodes()) {
            DomElement[] params;
            if (!n.getOperatorName().equalsIgnoreCase(readerName)) continue;
            ProductSetData psData = new ProductSetData();
            psData.nodeID = n.getId();
            DomElement config = n.getConfiguration();
            for (DomElement p : params = (DomElement[])config.getChildren()) {
                if (!p.getName().equals("fileList") || p.getValue() == null) continue;
                StringTokenizer st = new StringTokenizer(p.getValue(), ",");
                int length = st.countTokens();
                for (int i = 0; i < length; ++i) {
                    String str = st.nextToken().replace("\\u002C", ",");
                    psData.fileList.add(str);
                }
                break;
            }
            productSetDataList.add(psData);
        }
        return productSetDataList.toArray(new ProductSetData[productSetDataList.size()]);
    }

    public void restore() {
        for (GraphNode multiSrcNode : this.savedProductSetList) {
            ArrayList<GraphNode> nodesToRemove = new ArrayList<GraphNode>();
            for (GraphNode n : this.graphNodeList.getGraphNodes()) {
                String id = n.getID();
                if (!id.startsWith("inserted--" + multiSrcNode.getID()) || !id.contains(multiSrcNode.getID())) continue;
                this.graphNodeList.switchConnections(n, multiSrcNode.getID());
                nodesToRemove.add(n);
            }
            for (GraphNode r : nodesToRemove) {
                this.removeNode(r);
            }
            this.graphNodeList.add(multiSrcNode);
            this.graph.addNode(multiSrcNode.getNode());
        }
    }

    private void replaceProductSetWithReaders(GraphNode sourceNode, String id, String value) {
        GraphNode newReaderNode = GraphExecuter.createNewGraphNode(this.graph, this.graphNodeList, OperatorSpi.getOperatorAlias(ReadOp.class), id);
        newReaderNode.setOperatorUI(null);
        DomElement config = newReaderNode.getNode().getConfiguration();
        XppDomElement fileParam = new XppDomElement("file");
        fileParam.setValue(value);
        config.addChild((DomElement)fileParam);
        String format = CommonReaders.findCommonProductFormat((File)new File(value));
        if (format != null) {
            XppDomElement formatParam = new XppDomElement("formatName");
            formatParam.setValue(format);
            config.addChild((DomElement)formatParam);
        }
        this.graphNodeList.switchConnections(sourceNode, newReaderNode.getID());
    }

    private void removeNode(GraphNode node) {
        this.graphNodeList.remove(node);
        this.graph.removeNode(node.getID());
    }

    private static class ProductSetData {
        String nodeID = null;
        final List<String> fileList = new ArrayList<String>(10);

        private ProductSetData() {
        }
    }
}

