/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileModel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTableModel;
import org.esa.snap.graphbuilder.rcp.utils.ClipboardUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.nodes.PNode;
import org.esa.snap.rcp.util.Dialogs;

public class FileTable
extends JTable {
    private final FileTableModel fileModel;

    public FileTable() {
        this(new FileModel());
    }

    public FileTable(FileTableModel fileModel) {
        this(fileModel, new Dimension(500, 100));
    }

    public FileTable(FileTableModel fileModel, Dimension dim) {
        if (fileModel == null) {
            fileModel = new FileModel();
        }
        this.fileModel = fileModel;
        this.setModel(fileModel);
        this.setPreferredScrollableViewportSize(dim);
        fileModel.setColumnWidths(this.getColumnModel());
        this.setColumnSelectionAllowed(true);
        this.setDropMode(DropMode.ON);
        this.setDragEnabled(true);
        this.setComponentPopupMenu(this.createTablePopup());
        this.setTransferHandler(new ProductSetTransferHandler(fileModel));
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        try {
            tip = this.getValueAt(rowIndex, colIndex).toString();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return tip;
    }

    public void setFiles(File[] fileList) {
        if (fileList != null) {
            this.fileModel.clear();
            for (File file : fileList) {
                this.fileModel.addFile(file);
            }
        }
    }

    public void setFiles(String[] fileList) {
        if (fileList != null) {
            this.fileModel.clear();
            for (String str : fileList) {
                this.fileModel.addFile(new File(str));
            }
        }
    }

    public void setProductEntries(ProductEntry[] productEntryList) {
        if (productEntryList != null) {
            this.fileModel.clear();
            for (ProductEntry entry : productEntryList) {
                this.fileModel.addFile(entry);
            }
        }
    }

    public int getFileCount() {
        File file;
        int cnt = this.fileModel.getRowCount();
        if (cnt == 1 && (file = this.fileModel.getFileAt(0)).getName().isEmpty()) {
            return 0;
        }
        return cnt;
    }

    public File[] getFileList() {
        return this.fileModel.getFileList();
    }

    @Override
    public FileTableModel getModel() {
        return this.fileModel;
    }

    private JPopupMenu createTablePopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem pastelItem = new JMenuItem("Paste");
        pastelItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTable.this.paste();
            }
        });
        popup.add(pastelItem);
        return popup;
    }

    private void paste() {
        block3: {
            try {
                File[] fileList = ClipboardUtils.getClipboardFileList();
                if (fileList != null) {
                    this.setFiles(fileList);
                }
            }
            catch (Exception e) {
                if (SnapApp.getDefault() == null) break block3;
                Dialogs.showError((String)("Unable to paste from clipboard: " + e.getMessage()));
            }
        }
    }

    public static class ProductSetTransferHandler
    extends TransferHandler {
        private final FileTableModel fileModel;

        public ProductSetTransferHandler(FileTableModel model) {
            this.fileModel = model;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return true;
            }
            try {
                return info.getDataFlavors().length > 0 && info.getTransferable().getTransferData(info.getDataFlavors()[0]) instanceof PNode;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String[] values;
                    String data = (String)t.getTransferData(DataFlavor.stringFlavor);
                    for (String value : values = data.split("\n")) {
                        File file = new File(value);
                        if (!file.exists() || !ProductFunctions.isValidProduct((File)file)) continue;
                        this.fileModel.addFile(file);
                    }
                } else {
                    PNode node = (PNode)t.getTransferData(t.getTransferDataFlavors()[0]);
                    File file = node.getProduct().getFileLocation();
                    if (file.exists()) {
                        this.fileModel.addFile(file);
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JTable table = (JTable)c;
            int[] rows = table.getSelectedRows();
            StringBuilder listStr = new StringBuilder(256);
            for (int row : rows) {
                File file = this.fileModel.getFileAt(row);
                listStr.append(file.getAbsolutePath());
                listStr.append('\n');
            }
            if (rows.length != 0) {
                return new StringSelection(listStr.toString());
            }
            return null;
        }
    }
}

