/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.media.jai.JAI;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.esa.snap.core.gpf.internal.OperatorProductReader;
import org.esa.snap.core.gpf.internal.RasterDataNodeValues;
import org.esa.snap.core.gpf.ui.DefaultIOParametersPanel;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.ParameterUpdater;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.util.MemUtils;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIRegistry;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class SingleOperatorDialog
extends SingleTargetProductDialog {
    private final OperatorUI opUI;
    private JLabel statusLabel;
    private JComponent parametersPanel;
    private final String operatorName;
    private final OperatorDescriptor operatorDescriptor;
    private DefaultIOParametersPanel ioParametersPanel;
    private final OperatorParameterSupport parameterSupport;
    private final BindingContext bindingContext;
    private JTabbedPane form;
    private PropertyDescriptor[] rasterDataNodeTypeProperties;
    private String targetProductNameSuffix;
    private ProductChangedHandler productChangedHandler;

    public SingleOperatorDialog(String operatorName, AppContext appContext, String title, String helpID) {
        super(appContext, title, 24, helpID);
        this.operatorName = operatorName;
        this.targetProductNameSuffix = "";
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new IllegalArgumentException("No SPI found for operator name '" + operatorName + "'");
        }
        this.operatorDescriptor = operatorSpi.getOperatorDescriptor();
        this.ioParametersPanel = new DefaultIOParametersPanel(this.getAppContext(), this.operatorDescriptor, this.getTargetProductSelector());
        this.parameterSupport = new OperatorParameterSupport(this.operatorDescriptor, null, null, (ParameterUpdater)new GraphBuilderParameterUpdater());
        ArrayList sourceProductSelectorList = this.ioParametersPanel.getSourceProductSelectorList();
        PropertySet propertySet = this.parameterSupport.getPropertySet();
        this.bindingContext = new BindingContext(propertySet);
        if (propertySet.getProperties().length > 0 && !sourceProductSelectorList.isEmpty()) {
            Property[] properties = propertySet.getProperties();
            ArrayList<PropertyDescriptor> rdnTypeProperties = new ArrayList<PropertyDescriptor>(properties.length);
            for (Property property : properties) {
                PropertyDescriptor parameterDescriptor = property.getDescriptor();
                if (parameterDescriptor.getAttribute("rasterDataNodeType") == null) continue;
                rdnTypeProperties.add(parameterDescriptor);
            }
            this.rasterDataNodeTypeProperties = rdnTypeProperties.toArray(new PropertyDescriptor[rdnTypeProperties.size()]);
        }
        this.productChangedHandler = new ProductChangedHandler();
        if (!sourceProductSelectorList.isEmpty()) {
            ((SourceProductSelector)sourceProductSelectorList.get(0)).addSelectionChangeListener((SelectionChangeListener)this.productChangedHandler);
        }
        this.opUI = OperatorUIRegistry.CreateOperatorUI(operatorName);
        this.addParameters();
        this.getJDialog().setMinimumSize(new Dimension(450, 450));
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(new Color(255, 0, 0));
        this.getJDialog().getContentPane().add((Component)this.statusLabel, "North");
    }

    public int show() {
        this.ioParametersPanel.initSourceProductSelectors();
        if (this.form == null) {
            this.initForm();
            if (this.getJDialog().getJMenuBar() == null) {
                OperatorMenu operatorMenu = this.createDefaultMenuBar();
                this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
            }
        }
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.productChangedHandler.releaseProduct();
        this.ioParametersPanel.releaseSourceProductSelectors();
        super.hide();
    }

    protected Product createTargetProduct() throws Exception {
        if (this.validateUI()) {
            MemUtils.freeAllMemory();
            this.opUI.updateParameters();
            HashMap sourceProducts = this.ioParametersPanel.createSourceProductsMap();
            return GPF.createProduct((String)this.operatorName, (Map)this.parameterSupport.getParameterMap(), (Map)sourceProducts);
        }
        return null;
    }

    public String getTargetProductNameSuffix() {
        return this.targetProductNameSuffix;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.targetProductNameSuffix = suffix;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    private void initForm() {
        this.form = new JTabbedPane();
        this.form.add("I/O Parameters", (Component)this.ioParametersPanel);
        this.parametersPanel = this.opUI.CreateOpTab(this.operatorName, this.parameterSupport.getParameterMap(), this.appContext);
        this.parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.form.add("Processing Parameters", new JScrollPane(this.parametersPanel));
    }

    private OperatorMenu createDefaultMenuBar() {
        return new OperatorMenu((Component)this.getJDialog(), this.operatorDescriptor, this.parameterSupport, this.getAppContext(), this.getHelpID());
    }

    private void updateSourceProduct() {
        try {
            Property property = this.bindingContext.getPropertySet().getProperty("SOURCE_PRODUCT");
            if (property != null) {
                property.setValue((Object)this.productChangedHandler.currentProduct);
            }
        }
        catch (ValidationException e) {
            throw new IllegalStateException("Property 'SOURCE_PRODUCT' must be of type " + Product.class + ".", e);
        }
    }

    private void addParameters() {
        PropertySet propertySet = this.parameterSupport.getPropertySet();
        ArrayList sourceProductSelectorList = this.ioParametersPanel.getSourceProductSelectorList();
        if (sourceProductSelectorList.isEmpty()) {
            Dialogs.showError((String)"SourceProduct @Parameter not found in operator");
        } else {
            ((SourceProductSelector)sourceProductSelectorList.get(0)).addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

                public void selectionChanged(SelectionChangeEvent event) {
                    Product selectedProduct = (Product)event.getSelection().getSelectedValue();
                    if (selectedProduct != null) {
                        TargetProductSelectorModel targetProductSelectorModel = SingleOperatorDialog.this.getTargetProductSelector().getModel();
                        targetProductSelectorModel.setProductName(selectedProduct.getName() + SingleOperatorDialog.this.getTargetProductNameSuffix());
                        SingleOperatorDialog.this.opUI.setSourceProducts(new Product[]{selectedProduct});
                    }
                }
            });
        }
        if (propertySet.getProperties().length > 0 && !sourceProductSelectorList.isEmpty()) {
            Property[] properties = propertySet.getProperties();
            ArrayList<PropertyDescriptor> rdnTypeProperties = new ArrayList<PropertyDescriptor>(properties.length);
            for (Property property : properties) {
                PropertyDescriptor parameterDescriptor = property.getDescriptor();
                if (parameterDescriptor.getAttribute("rasterDataNodeType") == null) continue;
                rdnTypeProperties.add(parameterDescriptor);
            }
            this.rasterDataNodeTypeProperties = rdnTypeProperties.toArray(new PropertyDescriptor[rdnTypeProperties.size()]);
        }
    }

    private boolean validateUI() {
        UIValidation validation = this.opUI.validateParameters();
        if (validation.getState() == UIValidation.State.WARNING) {
            String msg = "Warning: " + validation.getMsg() + "\n\nWould you like to continue?";
            return Dialogs.requestDecision((String)"Warning", (String)msg, (boolean)false, null) == Dialogs.Answer.YES;
        }
        if (validation.getState() == UIValidation.State.ERROR) {
            String msg = "Error: " + validation.getMsg();
            Dialogs.showError((String)msg);
            return false;
        }
        return true;
    }

    protected void onApply() {
        if (!this.canApply()) {
            return;
        }
        String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
        SnapApp.getDefault().getPreferences().put("last_product_save_dir", productDir);
        this.statusLabel.setText("");
        Product targetProduct = null;
        try {
            targetProduct = this.createTargetProduct();
        }
        catch (Throwable t) {
            this.handleInitialisationError(t);
        }
        if (targetProduct == null) {
            return;
        }
        targetProduct.setName(this.targetProductSelector.getModel().getProductName());
        if (this.targetProductSelector.getModel().isSaveToFileSelected()) {
            targetProduct.setFileLocation(this.targetProductSelector.getModel().getProductFile());
            ProductWriterWorker worker = new ProductWriterWorker(targetProduct);
            worker.execute();
        } else if (this.targetProductSelector.getModel().isOpenInAppSelected()) {
            this.appContext.getProductManager().addProduct(targetProduct);
            this.showOpenInAppInfo();
        }
    }

    private static void updateValueSet(PropertyDescriptor propertyDescriptor, Product product) {
        Object object;
        Object[] values = new String[]{};
        if (product != null && (object = propertyDescriptor.getAttribute("rasterDataNodeType")) != null) {
            Class rasterDataNodeType = (Class)object;
            boolean includeEmptyValue = !propertyDescriptor.isNotNull() && !propertyDescriptor.isNotEmpty() && !propertyDescriptor.getType().isArray();
            values = RasterDataNodeValues.getNames((Product)product, (Class)rasterDataNodeType, (boolean)includeEmptyValue);
        }
        propertyDescriptor.setValueSet(new ValueSet(values));
    }

    private class GraphBuilderParameterUpdater
    implements ParameterUpdater {
        private GraphBuilderParameterUpdater() {
        }

        public void handleParameterSaveRequest(Map<String, Object> parameterMap) {
            SingleOperatorDialog.this.opUI.updateParameters();
        }

        public void handleParameterLoadRequest(Map<String, Object> parameterMap) throws ValidationException, ConversionException {
            SingleOperatorDialog.this.opUI.initParameters();
        }
    }

    private class ProductChangedHandler
    extends AbstractSelectionChangeListener
    implements ProductNodeListener {
        private Product currentProduct;

        private ProductChangedHandler() {
        }

        public void releaseProduct() {
            if (this.currentProduct != null) {
                this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                this.currentProduct = null;
                SingleOperatorDialog.this.updateSourceProduct();
            }
        }

        public void selectionChanged(SelectionChangeEvent event) {
            Product selectedProduct;
            Selection selection = event.getSelection();
            if (selection != null && (selectedProduct = (Product)selection.getSelectedValue()) != this.currentProduct) {
                if (this.currentProduct != null) {
                    this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                }
                this.currentProduct = selectedProduct;
                if (this.currentProduct != null) {
                    this.currentProduct.addProductNodeListener((ProductNodeListener)this);
                }
                this.updateTargetProductName();
                this.updateValueSets(this.currentProduct);
                SingleOperatorDialog.this.updateSourceProduct();
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        private void updateTargetProductName() {
            String productName = "";
            if (this.currentProduct != null) {
                productName = this.currentProduct.getName();
            }
            TargetProductSelectorModel targetProductSelectorModel = SingleOperatorDialog.this.getTargetProductSelector().getModel();
            targetProductSelectorModel.setProductName(productName + SingleOperatorDialog.this.getTargetProductNameSuffix());
        }

        private void handleProductNodeEvent() {
            this.updateValueSets(this.currentProduct);
        }

        private void updateValueSets(Product product) {
            if (SingleOperatorDialog.this.rasterDataNodeTypeProperties != null) {
                for (PropertyDescriptor propertyDescriptor : SingleOperatorDialog.this.rasterDataNodeTypeProperties) {
                    SingleOperatorDialog.updateValueSet(propertyDescriptor, product);
                }
            }
        }
    }

    private class ProductWriterWorker
    extends ProgressMonitorSwingWorker<Product, Object> {
        private final Product targetProduct;
        private Date executeStartTime;

        private ProductWriterWorker(Product targetProduct) {
            super((Component)SingleOperatorDialog.this.getJDialog(), "Writing Target Product");
            this.targetProduct = targetProduct;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Product doInBackground(ProgressMonitor pm) throws Exception {
            TargetProductSelectorModel model = SingleOperatorDialog.this.getTargetProductSelector().getModel();
            pm.beginTask("Writing...", model.isOpenInAppSelected() ? 100 : 95);
            Product product = null;
            try {
                OperatorProductReader opReader;
                Operator op;
                OperatorDescriptor descriptor;
                JAI.getDefaultInstance().getTileCache().flush();
                System.gc();
                this.executeStartTime = Calendar.getInstance().getTime();
                long t0 = System.currentTimeMillis();
                Operator operator = null;
                if (this.targetProduct.getProductReader() instanceof OperatorProductReader && (descriptor = (op = (opReader = (OperatorProductReader)this.targetProduct.getProductReader()).getOperatorContext().getOperator()).getSpi().getOperatorDescriptor()).isAutoWriteDisabled()) {
                    operator = op;
                }
                if (operator == null) {
                    WriteOp writeOp = new WriteOp(this.targetProduct, model.getProductFile(), model.getFormatName());
                    writeOp.setDeleteOutputOnFailure(true);
                    writeOp.setWriteEntireTileRows(true);
                    writeOp.setClearCacheAfterRowWrite(false);
                    operator = writeOp;
                }
                OperatorExecutor executor = OperatorExecutor.create(operator);
                executor.execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)95));
                File targetFile = model.getProductFile();
                if (model.isOpenInAppSelected() && targetFile.exists()) {
                    product = CommonReaders.readProduct((File)targetFile);
                    if (product == null) {
                        product = this.targetProduct;
                    }
                    pm.worked(5);
                }
            }
            finally {
                JAI.getDefaultInstance().getTileCache().flush();
                System.gc();
                pm.done();
                if (product != this.targetProduct) {
                    this.targetProduct.dispose();
                }
            }
            return product;
        }

        protected void done() {
            TargetProductSelectorModel model = SingleOperatorDialog.this.getTargetProductSelector().getModel();
            try {
                Product targetProduct = (Product)this.get();
                if (targetProduct != null) {
                    Date now = Calendar.getInstance().getTime();
                    long totalSeconds = (now.getTime() - this.executeStartTime.getTime()) / 1000L;
                    long totalBytes = ProductFunctions.getRawStorageSize((Product)targetProduct);
                    long totalPixels = ProductFunctions.getTotalPixels((Product)targetProduct);
                    SingleOperatorDialog.this.statusLabel.setText(ProductFunctions.getProcessingStatistics((Long)totalSeconds, (Long)totalBytes, (Long)totalPixels));
                    if (model.isOpenInAppSelected()) {
                        SingleOperatorDialog.this.appContext.getProductManager().addProduct(targetProduct);
                    }
                }
            }
            catch (InterruptedException targetProduct) {
            }
            catch (ExecutionException e) {
                SingleOperatorDialog.this.handleProcessingError(e.getCause());
            }
            catch (Throwable t) {
                SingleOperatorDialog.this.handleProcessingError(t);
            }
        }
    }
}

