/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.DBSearch;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTable;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTableModel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.TargetFolderSelector;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.FileChooserFactory;
import org.esa.snap.ui.GridLayout2;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;

public class ProductSetPanel
extends JPanel
implements TableModelListener {
    private final FileTable productSetTable;
    private final TargetFolderSelector targetProductSelector;
    private final AppContext appContext;
    private String targetProductNameSuffix = "";
    private JPanel buttonPanel = null;
    private JButton addButton = null;
    private JButton addAllOpenButton = null;
    private JButton dbQueryButton = null;
    private JButton removeButton = null;
    private JButton moveTopButton = null;
    private JButton moveUpButton = null;
    private JButton moveDownButton = null;
    private JButton moveBottomButton = null;
    private JButton refreshButton = null;
    private JButton clearButton = null;
    final JLabel countLabel = new JLabel();
    private static final ImageIcon addIcon = TangoIcons.actions_list_add((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon addOpenedIcon = new ImageIcon(ProductSetPanel.class.getClassLoader().getResource("org/esa/snap/graphbuilder/icons/add-opened22.png"));
    private static final ImageIcon removeIcon = TangoIcons.actions_list_remove((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon searchIcon = TangoIcons.actions_system_search((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon moveTopIcon = TangoIcons.actions_go_top((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon moveUpIcon = TangoIcons.actions_go_up((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon moveDownIcon = TangoIcons.actions_go_down((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon moveBottomIcon = TangoIcons.actions_go_bottom((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon refreshIcon = TangoIcons.actions_view_refresh((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon clearIcon = TangoIcons.actions_edit_clear((TangoIcons.Res)TangoIcons.Res.R22);

    public ProductSetPanel(AppContext theAppContext, String title) {
        this(theAppContext, title, new FileTable(), false, false);
    }

    public ProductSetPanel(AppContext theAppContext, String title, FileTableModel fileModel) {
        this(theAppContext, title, new FileTable(fileModel), false, false);
    }

    public ProductSetPanel(AppContext theAppContext, String title, FileTable fileTable, boolean incTrgProduct, boolean incButtonPanel) {
        super(new BorderLayout());
        this.appContext = theAppContext;
        this.productSetTable = fileTable;
        this.setBorderTitle(title);
        JPanel productSetContent = ProductSetPanel.createComponent(this.productSetTable);
        if (incButtonPanel) {
            this.buttonPanel = this.createButtonPanel(this.productSetTable);
            productSetContent.add((Component)this.buttonPanel, "East");
        }
        this.add((Component)productSetContent, "Center");
        if (incTrgProduct) {
            this.targetProductSelector = new TargetFolderSelector();
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String saveDir = SnapApp.getDefault().getPreferences().get("last_product_save_dir", homeDirPath);
            this.targetProductSelector.getModel().setProductDir(new File(saveDir));
            this.targetProductSelector.getOpenInAppCheckBox().setText("Open in " + theAppContext.getApplicationName());
            this.targetProductSelector.getOpenInAppCheckBox().setVisible(false);
            this.add((Component)this.targetProductSelector.createPanel(), "South");
        } else {
            this.targetProductSelector = null;
        }
        fileTable.getModel().addTableModelListener(this);
        this.updateComponents();
    }

    public void setBorderTitle(String title) {
        if (title != null) {
            this.setBorder(BorderFactory.createTitledBorder(title));
        }
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    private static JPanel createComponent(FileTable table) {
        JPanel fileListPanel = new JPanel(new BorderLayout(4, 4));
        JScrollPane scrollPane = new JScrollPane(table);
        fileListPanel.add((Component)scrollPane, "Center");
        return fileListPanel;
    }

    private void updateComponents() {
        boolean enableButtons;
        int rowCount = this.productSetTable.getFileCount();
        boolean bl = enableButtons = rowCount > 0;
        if (this.dbQueryButton != null) {
            this.dbQueryButton.setEnabled(enableButtons);
        }
        if (this.removeButton != null) {
            this.removeButton.setEnabled(enableButtons);
        }
        if (this.moveTopButton != null) {
            this.moveTopButton.setEnabled(rowCount > 1);
        }
        if (this.moveUpButton != null) {
            this.moveUpButton.setEnabled(rowCount > 1);
        }
        if (this.moveDownButton != null) {
            this.moveDownButton.setEnabled(rowCount > 1);
        }
        if (this.moveBottomButton != null) {
            this.moveBottomButton.setEnabled(rowCount > 1);
        }
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(rowCount > 1);
        }
        if (this.clearButton != null) {
            this.clearButton.setEnabled(enableButtons);
        }
        if (this.addAllOpenButton != null) {
            this.addAllOpenButton.setEnabled(SnapApp.getDefault().getProductManager().getProducts().length > 0);
        }
        String cntMsg = rowCount == 1 ? rowCount + " Product" : rowCount + " Products";
        this.countLabel.setText(cntMsg);
    }

    public JPanel createButtonPanel(final FileTable table) {
        final FileTableModel tableModel = table.getModel();
        JPanel panel = new JPanel((LayoutManager)new GridLayout2(20, 1));
        this.addButton = DialogUtils.createButton("addButton", "Add", addIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] files = ProductSetPanel.GetFilePath(ProductSetPanel.this.addButton, "Add Product");
                if (files != null) {
                    ProductSetPanel.addProducts(tableModel, files);
                }
            }
        });
        this.addAllOpenButton = DialogUtils.createButton("addAllOpenButton", "Add Opened", addOpenedIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.addAllOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductSetPanel.addAllOpenProducts(tableModel);
            }
        });
        this.dbQueryButton = DialogUtils.createButton("dbQueryButton", "DB Query", searchIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.dbQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File mstFile = tableModel.getFileAt(0);
                    if (mstFile.exists()) {
                        ProductEntry[] entryList;
                        for (ProductEntry entry : entryList = DBSearch.search((File)mstFile)) {
                            if (tableModel.getIndexOf(entry.getFile()) >= 0) continue;
                            tableModel.addFile(entry);
                        }
                    }
                }
                catch (Exception ex) {
                    ProductSetPanel.this.appContext.handleError("Unable to query DB", (Throwable)ex);
                }
            }
        });
        this.removeButton = DialogUtils.createButton("removeButton", "Remove", removeIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowCount = ProductSetPanel.this.productSetTable.getFileCount();
                if (rowCount == 1) {
                    tableModel.clear();
                    return;
                }
                int[] selRows = table.getSelectedRows();
                ArrayList<File> filesToRemove = new ArrayList<File>(selRows.length);
                for (int row : selRows) {
                    filesToRemove.add(tableModel.getFileAt(row));
                }
                Object object = filesToRemove.iterator();
                while (object.hasNext()) {
                    File file = (File)object.next();
                    int index = tableModel.getIndexOf(file);
                    tableModel.removeFile(index);
                }
            }
        });
        this.moveTopButton = DialogUtils.createButton("moveTopButton", "Move Top", moveTopIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.moveTopButton.addActionListener(new MoveButtonActionListener(table, tableModel, MOVE.TOP));
        this.moveUpButton = DialogUtils.createButton("moveUpButton", "Move Up", moveUpIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.moveUpButton.addActionListener(new MoveButtonActionListener(table, tableModel, MOVE.UP));
        this.moveDownButton = DialogUtils.createButton("moveDownButton", "Move Down", moveDownIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.moveDownButton.addActionListener(new MoveButtonActionListener(table, tableModel, MOVE.DOWN));
        this.moveBottomButton = DialogUtils.createButton("moveBottomButton", "Move Bottom", moveBottomIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.moveBottomButton.addActionListener(new MoveButtonActionListener(table, tableModel, MOVE.BOTTOM));
        this.refreshButton = DialogUtils.createButton("refreshButton", "Refresh", refreshIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.refresh();
            }
        });
        this.clearButton = DialogUtils.createButton("clearButton", "Clear", clearIcon, panel, DialogUtils.ButtonStyle.Icon);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tableModel.clear();
            }
        });
        panel.add(this.addButton);
        panel.add(this.addAllOpenButton);
        panel.add(this.removeButton);
        panel.add(this.moveTopButton);
        panel.add(this.moveUpButton);
        panel.add(this.moveDownButton);
        panel.add(this.moveBottomButton);
        panel.add(this.refreshButton);
        panel.add(this.clearButton);
        panel.add(this.countLabel);
        return panel;
    }

    private static void addProducts(FileTableModel tableModel, File[] files) {
        ProgressHandleMonitor pm = ProgressHandleMonitor.create((String)"Populating table");
        Runnable operation = () -> {
            pm.beginTask("Populating table...", files.length);
            for (File file : files) {
                if (ProductFunctions.isValidProduct((File)file)) {
                    tableModel.addFile(file);
                }
                pm.worked(1);
            }
            pm.done();
        };
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)"Adding Products", (ProgressHandle)pm.getProgressHandle(), (boolean)true, (int)50, (int)1000);
    }

    private static void addAllOpenProducts(FileTableModel tableModel) {
        ProgressHandleMonitor pm = ProgressHandleMonitor.create((String)"Populating table");
        Runnable operation = () -> {
            Product[] products = SnapApp.getDefault().getProductManager().getProducts();
            pm.beginTask("Populating table...", products.length);
            for (Product prod : products) {
                File file = prod.getFileLocation();
                if (file != null && file.exists()) {
                    tableModel.addFile(file);
                }
                pm.worked(1);
            }
            pm.done();
        };
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)"Adding Products", (ProgressHandle)pm.getProgressHandle(), (boolean)true, (int)50, (int)1000);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateComponents();
    }

    private static File[] GetFilePath(Component component, String title) {
        File[] files = null;
        File openDir = new File(SnapApp.getDefault().getPreferences().get("last_product_open_dir", "."));
        JFileChooser chooser = FileChooserFactory.getInstance().createFileChooser(openDir);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(title);
        if (chooser.showDialog(component, "OK") == 0) {
            files = chooser.getSelectedFiles();
            SnapApp.getDefault().getPreferences().put("last_product_open_dir", chooser.getCurrentDirectory().getAbsolutePath());
        }
        return files;
    }

    public void setTargetProductName(String name) {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            targetProductSelectorModel.setProductName(name + this.getTargetProductNameSuffix());
        }
    }

    public void onApply() {
        if (this.targetProductSelector != null) {
            String productDir = this.targetProductSelector.getModel().getProductDir().getAbsolutePath();
            SnapApp.getDefault().getPreferences().put("last_product_save_dir", productDir);
        }
    }

    String getTargetProductNameSuffix() {
        return this.targetProductNameSuffix;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.targetProductNameSuffix = suffix;
    }

    public File getTargetFolder() {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            return targetProductSelectorModel.getProductDir();
        }
        return null;
    }

    public String getTargetFormat() {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            return targetProductSelectorModel.getFormatName();
        }
        return null;
    }

    public void setTargetFolder(File path) {
        if (this.targetProductSelector != null) {
            TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
            targetProductSelectorModel.setProductDir(path);
        }
    }

    public File[] getFileList() {
        return this.productSetTable.getFileList();
    }

    public File[] getSelectedFiles() {
        return this.productSetTable.getModel().getFilesAt(this.productSetTable.getSelectedRows());
    }

    public Object getValueAt(int r, int c) {
        return this.productSetTable.getModel().getValueAt(r, c);
    }

    public void setProductFileList(File[] productFileList) {
        this.productSetTable.setFiles(productFileList);
    }

    public void setProductEntryList(ProductEntry[] productEntryList) {
        this.productSetTable.setProductEntries(productEntryList);
    }

    public boolean isSkippingExistingTargetFiles() {
        return this.targetProductSelector.isSkippingExistingTargetFiles();
    }

    public boolean isReplacingWritersWithUniqueTargetProduct() {
        return this.targetProductSelector.isReplacingWritersWithUniqueTargetProduct();
    }

    private static class MoveButtonActionListener
    implements ActionListener {
        private final FileTable table;
        private final FileTableModel tableModel;
        private final MOVE movement;

        public MoveButtonActionListener(FileTable table, FileTableModel tableModel, MOVE movement) {
            this.table = table;
            this.tableModel = tableModel;
            this.movement = movement;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selRows = this.table.getSelectedRows();
            ArrayList<File> filesToMove = new ArrayList<File>(selRows.length);
            for (int row : selRows) {
                filesToMove.add(this.tableModel.getFileAt(row));
            }
            int pos = 0;
            for (File file : filesToMove) {
                int index = this.tableModel.getIndexOf(file);
                if (index > 0 && this.movement.equals((Object)MOVE.TOP)) {
                    this.tableModel.move(index, pos++);
                    continue;
                }
                if (index > 0 && this.movement.equals((Object)MOVE.UP)) {
                    this.tableModel.move(index, index - 1);
                    continue;
                }
                if (index < this.tableModel.getRowCount() && this.movement.equals((Object)MOVE.DOWN)) {
                    this.tableModel.move(index, index + 1);
                    continue;
                }
                if (index >= this.tableModel.getRowCount() || !this.movement.equals((Object)MOVE.BOTTOM)) continue;
                this.tableModel.move(index, this.tableModel.getRowCount() - 1);
            }
        }
    }

    private static enum MOVE {
        UP,
        DOWN,
        TOP,
        BOTTOM;

    }
}

