/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.util.MemUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.IOPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphExecuter;
import org.esa.snap.graphbuilder.rcp.progress.LabelBarProgressMonitor;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModelessDialog;

public abstract class MultiGraphDialog
extends ModelessDialog
implements LabelBarProgressMonitor.ProgressBarListener {
    protected final AppContext appContext;
    protected final IOPanel ioPanel;
    protected final List<GraphExecuter> graphExecuterList = new ArrayList<GraphExecuter>(3);
    private final JPanel mainPanel;
    protected final JTabbedPane tabbedPane;
    private final JLabel statusLabel;
    private final JPanel progressPanel;
    private final JProgressBar progressBar;
    private LabelBarProgressMonitor progBarMonitor = null;
    private boolean isProcessing = false;
    protected static final String TMP_FILENAME = "tmp_intermediate";

    public MultiGraphDialog(AppContext theAppContext, String title, String helpID, boolean useSourceSelector) {
        super(theAppContext.getApplicationWindow(), title, 152, helpID);
        this.appContext = theAppContext;
        this.mainPanel = new JPanel(new BorderLayout(4, 4));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MultiGraphDialog.this.ValidateAllNodes();
            }
        });
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        this.ioPanel = new IOPanel(this.appContext, this.tabbedPane, useSourceSelector);
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(new Color(255, 0, 0));
        this.mainPanel.add((Component)this.statusLabel, "North");
        this.progressBar = new JProgressBar();
        this.progressBar.setName(this.getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout(2, 2));
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.progBarMonitor = new LabelBarProgressMonitor(this.progressBar);
        this.progBarMonitor.addListener(this);
        JButton progressCancelBtn = new JButton("Cancel");
        progressCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiGraphDialog.this.CancelProcessing();
            }
        });
        this.progressPanel.add((Component)progressCancelBtn, "East");
        this.progressPanel.setVisible(false);
        this.mainPanel.add((Component)this.progressPanel, "South");
        this.getButton(8).setText("Run");
        super.getJDialog().setMinimumSize(new Dimension(500, 300));
    }

    public int show() {
        this.ioPanel.initProducts();
        this.setContent(this.mainPanel);
        this.initGraphs();
        return super.show();
    }

    public void hide() {
        this.ioPanel.releaseProducts();
        super.hide();
    }

    protected void onApply() {
        if (this.isProcessing) {
            return;
        }
        this.ioPanel.onApply();
        try {
            this.DoProcessing();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
        }
    }

    protected void onClose() {
        this.CancelProcessing();
        super.onClose();
    }

    void initGraphs() {
        try {
            this.deleteGraphs();
            this.createGraphs();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
        }
    }

    private void DoProcessing() {
        if (this.ValidateAllNodes()) {
            MemUtils.freeAllMemory();
            this.progressBar.setValue(0);
            ProcessThread processThread = new ProcessThread(this.progBarMonitor);
            processThread.execute();
        } else {
            this.showErrorDialog(this.statusLabel.getText());
        }
    }

    @Override
    public void notifyProgressStart() {
        this.progressPanel.setVisible(true);
    }

    @Override
    public void notifyProgressDone() {
        this.progressPanel.setVisible(false);
    }

    private void CancelProcessing() {
        if (this.progBarMonitor != null) {
            this.progBarMonitor.setCanceled(true);
        }
    }

    private void deleteGraphs() {
        for (GraphExecuter gex : this.graphExecuterList) {
            gex.ClearGraph();
        }
        this.graphExecuterList.clear();
    }

    public void LoadGraph(GraphExecuter executer, File file) {
        try {
            executer.loadGraph(new FileInputStream(file), file, true, true);
        }
        catch (Exception e) {
            this.showErrorDialog(e.getMessage());
        }
    }

    protected abstract void createGraphs() throws GraphException;

    protected abstract void assignParameters() throws GraphException;

    protected abstract void cleanUpTempFiles();

    private boolean ValidateAllNodes() {
        boolean result;
        if (this.isProcessing) {
            return false;
        }
        if (this.ioPanel == null || this.graphExecuterList.isEmpty()) {
            return false;
        }
        this.statusLabel.setText("");
        try {
            Product srcProduct = this.ioPanel.getSelectedSourceProduct();
            if (srcProduct != null && (srcProduct.isModified() || srcProduct.getFileLocation() == null)) {
                throw new OperatorException("The source product has been modified. Please save it before using it in " + this.getTitle());
            }
            this.assignParameters();
            result = this.graphExecuterList.get(0).InitGraph();
        }
        catch (Exception e) {
            this.statusLabel.setText(e.getMessage());
            result = false;
        }
        return result;
    }

    private void openTargetProducts(List<File> fileList) {
        if (!fileList.isEmpty()) {
            for (File file : fileList) {
                try {
                    Product product = CommonReaders.readProduct((File)file);
                    if (product == null) continue;
                    this.appContext.getProductManager().addProduct(product);
                }
                catch (Exception e) {
                    this.showErrorDialog(e.getMessage());
                }
            }
        }
    }

    protected IOPanel getIOPanel() {
        return this.ioPanel;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.ioPanel.setTargetProductNameSuffix(suffix);
    }

    public void testRunGraph() throws Exception {
        this.ioPanel.initProducts();
        this.initGraphs();
        if (this.ValidateAllNodes()) {
            for (GraphExecuter graphEx : this.graphExecuterList) {
                String desc = graphEx.getGraphDescription();
                if (desc != null && !desc.isEmpty()) {
                    System.out.println("Processing " + graphEx.getGraphDescription());
                }
                graphEx.InitGraph();
                graphEx.executeGraph(ProgressMonitor.NULL);
                graphEx.disposeGraphContext();
            }
        } else {
            throw new OperatorException(this.statusLabel.getText());
        }
        this.cleanUpTempFiles();
    }

    private class ProcessThread
    extends SwingWorker<Boolean, Object> {
        private final ProgressMonitor pm;
        private Date executeStartTime = null;
        private boolean errorOccured = false;

        public ProcessThread(ProgressMonitor pm) {
            this.pm = pm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Boolean doInBackground() throws Exception {
            this.pm.beginTask("Processing Graph...", 100 * MultiGraphDialog.this.graphExecuterList.size());
            try {
                this.executeStartTime = Calendar.getInstance().getTime();
                MultiGraphDialog.this.isProcessing = true;
                for (GraphExecuter graphEx : MultiGraphDialog.this.graphExecuterList) {
                    String desc = graphEx.getGraphDescription();
                    if (desc != null && !desc.isEmpty()) {
                        MultiGraphDialog.this.statusLabel.setText("Processing " + graphEx.getGraphDescription());
                    }
                    graphEx.InitGraph();
                    graphEx.executeGraph(SubProgressMonitor.create((ProgressMonitor)this.pm, (int)100));
                    graphEx.disposeGraphContext();
                }
            }
            catch (Exception e) {
                System.out.print(e.getMessage());
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    MultiGraphDialog.this.statusLabel.setText(e.getMessage());
                } else {
                    MultiGraphDialog.this.statusLabel.setText(e.toString());
                }
                this.errorOccured = true;
            }
            finally {
                MultiGraphDialog.this.isProcessing = false;
                this.pm.done();
                if (SnapApp.getDefault().getPreferences().getBoolean("snap.gpf.beepAfterProcessing", false)) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            return true;
        }

        @Override
        public void done() {
            if (!this.errorOccured) {
                Date now = Calendar.getInstance().getTime();
                long diff = (now.getTime() - this.executeStartTime.getTime()) / 1000L;
                if (diff > 120L) {
                    float minutes = (float)diff / 60.0f;
                    MultiGraphDialog.this.statusLabel.setText("Processing completed in " + minutes + " minutes");
                } else {
                    MultiGraphDialog.this.statusLabel.setText("Processing completed in " + diff + " seconds");
                }
                MemUtils.freeAllMemory();
                if (MultiGraphDialog.this.ioPanel.isOpenInAppSelected()) {
                    GraphExecuter graphEx = MultiGraphDialog.this.graphExecuterList.get(MultiGraphDialog.this.graphExecuterList.size() - 1);
                    MultiGraphDialog.this.openTargetProducts(graphEx.getProductsToOpenInDAT());
                }
            }
            MultiGraphDialog.this.cleanUpTempFiles();
        }
    }
}

