/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.esa.snap.GlobalTestConfig;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.graphbuilder.gpf.ui.SourceUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.product.ProductSceneView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SourceUITest {
    SourceUI sourceUI;
    private Product[] defaultProducts;
    private AppContext appContext;
    private final Map<String, Object> parameterMap = new HashMap<String, Object>(5);
    private static final String FILE_PARAMETER = "file";

    @Before
    public void setUp() throws Exception {
        this.sourceUI = new SourceUI();
        this.appContext = new MockAppContext();
        File path = GlobalTestConfig.getBeamTestDataOutputDirectory();
        this.defaultProducts = new Product[2];
        for (int i = 0; i < this.defaultProducts.length; ++i) {
            Product prod = new Product("P" + i, "T" + i, 10, 10);
            prod.setFileLocation(path);
            this.appContext.getProductManager().addProduct(prod);
            this.defaultProducts[i] = prod;
        }
    }

    @Test
    public void testCreateOpTab() {
        JComponent component = this.sourceUI.CreateOpTab("testOp", this.parameterMap, this.appContext);
        Assert.assertNotNull((Object)component);
        Assert.assertEquals((long)this.sourceUI.sourceProductSelector.getProductNameComboBox().getModel().getSize(), (long)2L);
    }

    @Test
    public void testValidateParameters() {
        this.sourceUI.CreateOpTab("testOp", this.parameterMap, this.appContext);
        UIValidation valid = this.sourceUI.validateParameters();
        Assert.assertTrue((valid.getState() == UIValidation.State.OK ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateParameters() {
        this.sourceUI.CreateOpTab("testOp", this.parameterMap, this.appContext);
        this.parameterMap.put(FILE_PARAMETER, this.defaultProducts[0]);
        this.sourceUI.updateParameters();
        File path = (File)this.parameterMap.get(FILE_PARAMETER);
        Assert.assertTrue((boolean)path.getAbsolutePath().equals(this.defaultProducts[0].getFileLocation().getAbsolutePath()));
    }

    private class MockAppContext
    implements AppContext {
        private PropertyMap preferences = new DefaultPropertyMap();
        private ProductManager prodMan = new ProductManager();

        private MockAppContext() {
        }

        public Window getApplicationWindow() {
            return null;
        }

        public String getApplicationName() {
            return "Killer App";
        }

        public Product getSelectedProduct() {
            return SourceUITest.this.defaultProducts[0];
        }

        public void handleError(Throwable e) {
            JOptionPane.showMessageDialog(this.getApplicationWindow(), e.getMessage());
        }

        public void handleError(String message, Throwable e) {
            JOptionPane.showMessageDialog(this.getApplicationWindow(), message);
        }

        public PropertyMap getPreferences() {
            return this.preferences;
        }

        public ProductManager getProductManager() {
            return this.prodMan;
        }

        public ProductSceneView getSelectedProductSceneView() {
            return null;
        }
    }
}

